/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <stdio.h>
#include <sgtty.h>
#include <strings.h>

#include <plog.h>
#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pmachine.h>

extern char	hostname[];
extern char	hostwport[];

/*
 * dsdb - Make a database query as if it were a directory lookup
 *
 */
dsdb(name,componentsp,rcompp,dir,verify)
    char	*name;         /* Name of the directory                     */
    char	**componentsp; /* Next component of name                    */
    char	**rcompp;      /* Additional components                     */
    VDIR	dir;           /* Directory to be filled in                 */
    int		verify;	       /* If set, only want to verify the directory */
    {
	/* Note that componentspp and rcompp are pointers to */
	/* character pointers.  This is necessary because    */
	/* this routine must be able to update these values  */
	/* if more than one component of the name is         */
	/* resolved.                                         */
	char 		*components = NULL;
	char		*rcomp = NULL;
	VLINK		cur_link = NULL;
	char		newdirname[MAXPATHLEN];

	if(componentsp) components = *componentsp;
	if(rcompp) rcomp = *rcompp;

	/* Directory already initialized, but remember that this */
	/* is not a real directory                               */
	dir->version = -1;
	dir->inc_native = 3;		/* Not really a directory */

/* If the component is "*" then the result should be all entries      */
/* returned by the database query.  If the component is something     */
/* else, then if the component matches one of the values returned by  */
/* the query, it should be that value.  Otherwise, it might be the    */
/* next component in the path, and a suitable response must be        */
/* generated. If it is possible to determine before making the query  */
/* that the component is part of the path, and not an individual      */
/* result, then the query can be skipped entirely.                    */

/* Although not necessary that you be able to make this determination */
/* before making the query, doing so will improve preformance by      */
/* eliminating the need to make unnecessary queries.  As presently    */
/* implemented, each component in a name will involve a query to the  */
/* directory server.  In future implementations of prospero, it will  */
/* be possible to resolve multiple components of a name in a single   */
/* message, and this problem will be eliminated.                      */

/* One way to make it possible to determine this would be if all      */
/* arguments to a query include a special character (e.g. "=").       */
/* Only a component name without that character would result in a     */ 
/* query.  Note that when a user lists a directory, the component     */
/* name is "*", so the query would be performed.  It is the           */
/* intermediate requests for which we want to supress the query.      */
/* An example of a query format that follows the convention described */
/* is /archive-db/author=author/keyword=kw1                           */


	if(index(components,'=')) goto noquery; 

	/* The following code is for debuging without a read DB */
	/* and it should be removed when a real DB is used.     */
	cur_link = vlalloc();

	cur_link->name = stcopy("result");
	cur_link->filename = stcopy("/filename");
	cur_link->host = stcopy("JUNE.CS.WASHINGTON.EDU");
	cur_link->linktype = 'L';
	
	vl_insert(cur_link,dir,VLI_NOCONFLICT);
	

#ifdef NOTDEF
	/* The following is a sample of how to convert the response */
	/* of the query into a directory                            */

	resp = query(name);
	
	while(resp) {
	    if(wcmatch(resp->filename,components)) {
		cur_link = vlalloc();

		cur_link->name = stcopy(resp->filename);
		cur_link->filename = stcopy(resp->filename);
		cur_link->host = stcopy(resp->hostwport);
		cur_link->linktype = 'L';
		
		vl_insert(cur_link,dir,VLI_NOCONFLICT);
	    }
	    resp = resp->next;
	}

#endif NOTDEF

	if((dir->links) || (strcmp("*",components) == 0)) return(PSUCCESS);

    noquery:
	
	cur_link = vlalloc();

	cur_link->name = stcopy(components);
	sprintf(newdirname,"%s/%s",name,components);
	cur_link->filename = stcopy(newdirname);
	cur_link->host = stcopy(hostwport);
	cur_link->linktype = 'L';
		
	vl_insert(cur_link,dir,VLI_NOCONFLICT);

	return(PSUCCESS);
    }
