/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#define ABSOLUTE_MAX_HITS 2500
#define ABSOLUTE_MAX_GIF  100

#include <uw-copyright.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <stdio.h>
#include <sgtty.h>
#include <strings.h>

/* Archie defines */
#include <defines.h>
#include <structs.h>
#include <error.h>
#include <database.h>

#include "prarch.h"

#include <psite.h>
#include <pfs.h>
#include <plog.h>
#include <pprot.h>
#include <perrno.h>
#include <pmachine.h>

extern char	hostname[];
extern char	hostwport[];

char	*zerop = NULL;

/*
 * dsdb - Make a database query as if it were a directory lookup
 *
 */
dsdb(name,componentsp,rcompp,dir,verify)
    char	*name;         /* Name of the directory                     */
    char	**componentsp; /* Next component of name                    */
    char	**rcompp;      /* Additional components                     */
    VDIR	dir;           /* Directory to be filled in                 */
    int		verify;	       /* If set, only want to verify the directory */
    {
      /* Note that componentspp and rcompp are pointers to */
      /* character pointers.  This is necessary because    */
      /* this routine must be able to update these values  */
      /* if more than one component of the name is         */
      /* resolved.                                         */
	char 		*components = NULL;
	char		*rcomp = NULL;
	int		unresolvedcnt = 0;
	VLINK		cur_link = NULL;
	char		newdirname[MAXPATHLEN];
	static int	dbopen = 0;
        char		fullquery[MAXPATHLEN];
	char		*dbpart;
        char		dbquery[MAXPATHLEN];
        char		dbargs[MAXPATHLEN];
        char		dbarg1[MAXPATHLEN];
        char		dbarg2[MAXPATHLEN];
        char		dbarg3[MAXPATHLEN];
        char		dirlinkname[MAXPATHLEN];
	char		sep;
	char		*lastsep;
	int		tmp;
	VLINK		dirlink = NULL;

	if(componentsp) components = *componentsp;
	if(rcompp) rcomp = *rcompp;

	/* Directory already initialized, but note that this */
	/* is not a real directory                           */
	dir->version = -1;
	dir->inc_native = 3;	   /* Not really a directory */

	/* Note that if we are resolving multiple components */
	/* (rcomp!=NULL) the directory will already be empty */
	/* since had anything been in it dirsrv would have   */
	/* already cleared it and moved on to the next comp  */

	/* Do only once */
	if(!dbopen++) {
	    set_default_dir(DEFAULT_DBDIR);
	    if((tmp = open_db_files(DB_RDONLY)) != A_OK) {
		dbopen = 0;
		plog(L_DB_ERROR,0,0,"Can't open archie database",0);
		return(PFAILURE);
	    }
	}

	/* For now, if only verifying, indicate success */
	/* We don't want to do a DB search.  Eventually */
	/* we might actually check that the directory   */
	/* is valid.                                    */
	if(verify) return(PSUCCESS);

	/* Construct the full query from thje pieces passed to us */
	sprintf(fullquery,"%s%s%s%s%s",name,
	      ((components && *components) ? "/" : ""),
	      ((components && *components) ? components : ""),
	      ((rcomp && *rcomp) ? "/" : ""),
	      ((rcomp && *rcomp) ? rcomp : ""));

	/* The format for the queries is            */
	/* DATABASE_PREFIX/COMMAND(PARAMETERS)/ARGS */

	/* Strip off the database prefix */
	dbpart = fullquery + strlen(DATABASE_PREFIX);

	/* And we want to skip the next slash */
	dbpart++;

	/* Find the query (up to the next /), determine if the */
	/* / exists and then read the args                     */
	tmp = sscanf(dbpart,"%[^/]%c%s",dbquery,&sep,dbargs);
	
	/* If no separator, for now return nothing         */
	/* Eventually, we might return a list of the query */
	/* types supported                                 */
	if(tmp < 2) return(PSUCCESS);

	/* Check query type */
	if(strncmp(dbquery,"MATCH",5)==0) {
	  char	stype = 'R';     /* search type           */
	  int	maxhit = 100;    /* max entries to return */
	  int   offset = 0;      /* entries to skip       */
	  search_sel method;	 /* Search method         */

	  /* if no strings to match, return nothing */
	  if(tmp < 3) return(PSUCCESS);

	  /* Get arguments */
	  sscanf(dbquery,"MATCH(%d,%d,%c",&maxhit,&offset,&stype);

	  /* Don't let the user request more than ABSOLUTE_MAX_HITS */
	  if((maxhit > ABSOLUTE_MAX_HITS) || (maxhit < 1)) {
	      sprintf(p_err_string,"Legal values for max hits are between 1 and %d ",ABSOLUTE_MAX_HITS);
	      return(DIRSRV_NOT_AUTHORIZED);
	  }

	  switch(stype) {
	  case '=':
	      method = S_EXACT ;
	      break;
	  case 'S':
	      method = S_SUB_NCASE_STR ;
	      break;
	  case 's':
	      method = S_E_SUB_NCASE_STR ;
	      break;
	  case 'C':
	      method = S_SUB_CASE_STR ;
	      break;
	  case 'c':
	      method = S_E_SUB_CASE_STR ;
	      break;
	  case 'r':
	      method = S_E_FULL_REGEX ;
	      break;
	  case 'R':
	  default:
	      method = S_FULL_REGEX ;
	      break;
	  }

	  *dbarg1 = *dbarg2 = *dbarg3 = '\0';

	  tmp = sscanf(dbargs,"%[^/]%c%[^/]%c%s",dbarg1,&sep,dbarg2,
		       &sep,dbarg3); 

	  if(tmp < 2) {
	      /* This specifies a directory, but not a link within it  */
	      /* create a pseudo directory and return a pointer        */
	      if(*dbarg1 && (strcmp(dbarg1,"*")!= 0)) {
		  dirlink = vlalloc();
		  dirlink->type = stcopyr("DIRECTORY",dirlink->type);
		  dirlink->name = stcopyr(dbarg1,dirlink->name);
		  dirlink->host = stcopyr(hostwport,dirlink->host);
		  sprintf(dirlinkname,"%s/%s/%s",DATABASE_PREFIX,dbquery,
			  dbarg1);
		  dirlink->filename = stcopyr(dirlinkname,dirlink->filename);
		  vl_insert(dirlink,dir,VLI_ALLOW_CONF);
	      }
	  }
	  else {
	      if(tmp > 4) {
		  /* There are remaining components */
		  unresolvedcnt = strlen(dbarg3);
	      }
#ifdef ABSOLUTE_MAX_GIF
	      /* If looking for GIF files (arrgh) don't allow them */
	      /* to set an unreasonable number of hits, this is    */
	      /* promted by someone who set max hits to 10,000     */
	      if((maxhit+offset > ABSOLUTE_MAX_GIF)&&(((strlen(dbarg1) >= 4)&&
		         (strcasecmp(dbarg1+strlen(dbarg1)-4,".gif") == 0)) ||
		         (strcasecmp(dbarg1,"gif") == 0))) {
		  sprintf(p_err_string,"Max hits for GIF searches is %d - See archie/doc/giflist.Z on archie.mcgill.ca for full gif list",ABSOLUTE_MAX_GIF);
		  return(DIRSRV_NOT_AUTHORIZED);
	      }
#endif ABSOLUTE_MAX_GIF

	      tmp = prarch_match(dbarg1,maxhit,offset,method,dir,FALSE);
	      if(tmp) return(PFAILURE);
	  }
	}
	else if (strncmp(dbquery,"HOST",4)==0) {
	    /* First component of args is the site name    */
	    /* remaining components are the directory name */

	    *dbarg1 = *dbarg2 = '\0';

	    tmp = sscanf(dbargs,"%[^/]%c%s",dbarg1,&sep,dbarg2);

	    /* If first component is null, return an empty directory */
	    if(tmp < 1) return(PSUCCESS);

	    /* If first component is a wildcard, and no additional */
	    /* components, then return matching list of sites.     */
	    /* ---Not implemented for now.                         */
	    
	    /* if first component exist, but is last component,  */
	    /* then it is the name of the subdirectory for the   */
	    /* host, create a pseudo directory and return a      */
	    /* pointer                                           */
	    /* Eventually check to make sure host is known       */
	    if((tmp == 1) && (strcmp(dbarg1,"*")!= 0)) {
		dirlink = vlalloc();
		dirlink->type = stcopyr("DIRECTORY",dirlink->type);
		dirlink->name = stcopyr(dbarg1,dirlink->name);
		dirlink->host = stcopyr(hostwport,dirlink->host);
		sprintf(dirlinkname,"%s/%s/%s",DATABASE_PREFIX,dbquery,
			dbarg1);
		dirlink->filename = stcopyr(dirlinkname,dirlink->filename);
		vl_insert(dirlink,dir,VLI_ALLOW_CONF);
	    }	    
	    /* More than one component, Look up the requested directory  */
	    /* Note that the since the full query is passed to us, it    */
	    /* includes the component name, thus the directory name is   */
	    /* what you get when you strip off the last component of the */
	    /* name                                                      */
	    else {
		lastsep = rindex(dbarg2,'/');
		if(lastsep) *lastsep++ = '\0';
		else *dbarg2 = '\0';
		tmp = prarch_host(dbarg1,dbarg2,dir,TRUE);
		if(tmp == PRARCH_DONT_HAVE_SITE) 
		    return(DSRDIR_NOT_A_DIRECTORY);
		else if(tmp) return(PFAILURE);
	    }
	}
	else {
	  /* Query type not supported */
	  return(DSRDIR_NOT_A_DIRECTORY);
	}

	/* We are done, but we need to figure out if we */
	/* resolved multiple components                 */
	if(unresolvedcnt && rcomp) {
	    int		skipover;
	    skipover = strlen(rcomp) - unresolvedcnt;
	    if(skipover > 0) {
		/* Skipover, and update compoents */
		components = rcomp;
		rcomp + skipover;
		*(rcomp-1) = '\0';
		*rcompp = rcomp;
		*componentsp = rindex(components,'/');
		if(!(*componentsp)) *componentsp = components;
		return(PSUCCESS);
	    }
	    else if(skipover < 0) {
		return(DSRDIR_NOT_A_DIRECTORY);
	    }
	    else if(skipover = 0) return(PSUCCESS);
	}
	else if(rcomp) {
	  *componentsp = rindex(rcomp,'/');
	  if(!(*componentsp)) *componentsp = rcomp;
	  else (*componentsp)++;
	  *rcompp = zerop;
	  return(PSUCCESS);
	}
	return(PSUCCESS);
    }
