/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <pmachine.h>

/*
 * sindex - Find first instance of string 2 in string 1 
 *
 *	      SINDEX scans string 1 for the first instance of string
 *	      2.  If found, SINDEX returns a pointer to the first
 *	      character of that instance.  If no instance is found, 
 *	      SINDEX returns NULL (0).
 *
 *    ARGS:   s1 - string to be searched
 *            s2 - string to be found
 * RETURNS:   First instance of s2 in s1, or NULL (0) if not found
 */
char *
sindex(s1,s2)
    char	*s1;		/* String to be searched   */
    char	*s2;		/* String to be found      */
    {
	char	*s = s1;	/* Temp pointer to string  */

	/* Check for first character of s2 */
	while((s = index(s,*s2)) != NULL) {
	    if(strncmp(s,s2,strlen(s2)) == 0)
		return(s);
	    s++;
	}

	/* We didn't find it */
	return(NULL);
    }

