/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <perrno.h>

scan_error(erst)
    char	*erst;
    {
	*p_err_string = '\0';

	if(strncmp(erst,"NOT-A-DIRECTORY",15) == 0) 
	    return(DIRSRV_NOT_DIRECTORY);

	if(strncmp(erst,"UNIMPLEMENTED",13) == 0) {
	    perrno = DIRSRV_UNIMPLEMENTED;
	    sscanf(erst+13,"%*[^\n \t\r]%*[ \t]%[^\n]",p_err_string);
	    return(perrno);
	}

	if(strncmp(erst,"WARNING ",8) == 0) {
	    erst += 8;
	    *p_warn_string = '\0';
	    sscanf(erst,"%*[^\n \t\r]%*[ \t]%[^\n]",p_warn_string);
	    /* Return values for warnings are negative */
	    if(strncmp(erst,"OUT-OF-DATE",11) == 0) {
		pwarn = PWARN_OUT_OF_DATE;
		return(PSUCCESS);
	    }
	    if(strncmp(erst,"MESSAGE",7) == 0) {
		pwarn = PWARN_MSG_FROM_SERVER;
		return(PSUCCESS);
	    }
	    pwarn = PWARNING;
	    sscanf(erst,"%[^\n]",p_warn_string);
	    return(PSUCCESS);
	}
	else if(strncmp(erst,"ERROR",5) == 0) {
	    if(*(erst+5)) sscanf(erst+6,"%[^\n]",p_err_string);
	    perrno = DIRSRV_ERROR;
	    return(perrno);
	}
	/* The rest start with "FAILURE" */
	else if(strncmp(erst,"FAILURE",7) != 0) {
	    /* Unrecognized - Give warning, but return PSUCCESS */
	    if(pwarn == 0) {
		*p_warn_string = '\0';
		pwarn = PWARN_UNRECOGNIZED_RESP;
		sscanf(erst,"%[^\n]",p_warn_string);
	    }
	    return(PSUCCESS);
	}

	if(strncmp(erst,"FAILURE ",8) != 0) {
	    perrno = PFAILURE;
	    return(perrno);
	}	
	erst += 8;
	
	sscanf(erst,"%*[^\n \t\r]%*[ \t]%[^\n]",p_err_string);

	/* Still to add               */
	/* DIRSRV_AUTHENT_REQ     242 */
	/* DIRSRV_BAD_VERS        245 */

	if(strncmp(erst,"NOT-FOUND",9) == 0) 
	    perrno = DIRSRV_NOT_FOUND;
	else if(strncmp(erst,"NOT-AUTHORIZED",13) == 0) 
	    perrno = DIRSRV_NOT_AUTHORIZED;
	else if(strncmp(erst,"ALREADY-EXISTS",14) == 0) 
	    perrno = DIRSRV_ALREADY_EXISTS;
	else if(strncmp(erst,"NAME-CONFLICT",13) == 0) 
	    perrno = DIRSRV_NAME_CONFLICT;
	else if(strncmp(erst,"SERVER-FAILED",13) == 0) 
	    perrno = DIRSRV_SERVER_FAILED;
 	/* Use it whether it starts with FAILURE or not */
	else if(strncmp(erst,"NOT-A-DIRECTORY",15) == 0) 
	    perrno = DIRSRV_NOT_DIRECTORY;
	else perrno = PFAILURE;

	return(perrno);
    }
