/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>
#include <pmachine.h>

extern int	pfs_debug;

extern int	perrno;
extern		char p_err_string[];

/*
 */
mk_vdir(vpath,flags)
    char	*vpath;		/* Name of the new directory       */ 
    int		flags;		/* Options for directory           */
    {

	char		*dirhst;	   /* Host of current directory    */
	char		*remdir;	   /* Dir on remote host	   */
	
	char		*cname = "";	   /* Component name               */
        char	        *pname = "";	   /* Parent name		   */

	char		pathcpy[MAX_VPATH];

	int		fwdcnt = MAX_FWD_DEPTH;
	char		fwdhst[MAX_DIR_LINESIZE];
	char		fwdfnm[MAX_DIR_LINESIZE];

        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */

	VDIR_ST		dir_st;
	VDIR		dir = &dir_st;

	PAUTH		authinfo;

	int		tmp;

	vdir_init(dir);

	strcpy(pathcpy,vpath);
	cname = rindex(pathcpy,'/');
	if(!cname)  cname = pathcpy;
	else {
	    *cname++ = '\0';
	    pname = pathcpy;
	    if(cname == (pname + 1)) pname = "/";
	}


        /* We must first find the directory into which the link  */
        /* will be inserted                                      */

	tmp = rd_vdir(pname,0,dir,RVD_DFILE_ONLY);
	if (tmp || (dir->links == NULL)) return(DIRSRV_NOT_DIRECTORY);
	dirhst = dir->links->host;
	remdir = dir->links->filename;

    startover:

	request = ptalloc();

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

	sprintf(request->start,
          "VERSION %d %s\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nCREATE-DIRECTORY VIRTUAL%s %s\n",
		VFPROT_VNO, PFS_SW_ID, authinfo->auth_type, 
		authinfo->authenticator, remdir, 
		((flags&MKVD_LPRIV) ? "+LPRIV" : ""), cname);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,dirhst,0);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	if(resp == NULL) return(perrno);

	/* Here we must parse reponse - While looking at each packet */
	while(resp) {
	    PTEXT		vtmp;
	    char		*line;

	    vtmp = resp;

	    if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	    /* Look at each line in packet */
	    for(line = resp->start;line != NULL;line = nxtline(line)) {
		switch (*line) {
		    
		case 'F': /* FAILURE or FORWARDED */
		    /* FORWARDED */
		    if(strncmp(line,"FORWARDED",9) == 0) {
			if(fwdcnt-- <= 0) {
			    ptlfree(resp);
			    perrno = PFS_MAX_FWD_DEPTH;
			    return(perrno);
			}
			/* parse and start over */
			tmp = sscanf(line,"FORWARDED %*s %s %*s %s %*d %*d", 
				     fwdhst,fwdfnm);
			dirhst = stcopy(fwdhst);
			remdir = stcopy(fwdfnm);

			if(tmp < 2) {
			    ptlfree(resp);
			    perrno = DIRSRV_BAD_FORMAT;
			    break;
			}
			ptlfree(resp);
			goto startover;
		    }
		    /* If FAILURE or anything else scan error */
		    goto scanerr;

		case 'M': /* MULTI-PACKET (processed by dirsend) */
		case 'P': /* PACKET (processed by dirsend) */
		    break;

		case 'S': /* SUCCESS */
		    if(strncmp(line,"SUCCESS",7) == 0) {
			ptlfree(resp);
			return(PSUCCESS);
		    }
		    goto scanerr;

		case 'V': /* VERSION-NOT-SUPPORTED */
		    if(strncmp(line,"VERSION-NOT-SUPPORTED",21) == 0) {
			perrno = DIRSRV_BAD_VERS;
			return(perrno);
		    }
		    goto scanerr;

		scanerr:
		default:
		    if(*line && (tmp = scan_error(line))) {
			ptlfree(resp);
			return(tmp);
		    }
		    break;
		}
	    }

	    resp = resp->next;
	    ptfree(vtmp);
	}
	
	perrno = DIRSRV_BAD_FORMAT;
	return(perrno);
    }
