/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <syscall.h>
#include <errno.h>

#include <pfs.h>
#include <pcompat.h>
#include <perrno.h>

extern int	pfs_enable;
extern int	perrno;
extern int	errno;

/* Call stat_l indicating normal stat */
stat(path,buf)
    char 	*path;
    struct stat *buf;
    {
	return(stat_l(path,buf,0));
    }


/* Call stat_l indicating lstat */
lstat(path,buf)
    char 	*path;
    struct stat *buf;
    {
	return(stat_l(path,buf,1));
    }


static
stat_l(path,buf,lflag)
    char 	*path;
    struct stat *buf;
    int		lflag;
    {
	VDIR_ST		dir_st;
	VDIR		dir= &dir_st;
	PATTRIB		ap,nextap;
	int		tmp;

	vdir_init(dir);
	check_pfs_default();
	    
	/* If disabled, make system call */
	if(pfs_enable == PMAP_DISABLE) {
	    return(syscall((lflag ? SYS_lstat : SYS_stat), path, buf));
	}

	if(pfs_enable == PMAP_COLON) {
	    if(*path == ':') path++;
	    else if(index(path,':'));
	    else return(syscall((lflag ? SYS_lstat : SYS_stat), path, buf));
	}

	if((pfs_enable == PMAP_ATSIGN_NF) || (pfs_enable == PMAP_ATSIGN)) {
	    if(*path == '@') {
		path++;
		return(syscall((lflag ? SYS_lstat : SYS_stat), path, buf));
	    }
	}

	bzero(buf,sizeof(struct stat));
	buf->st_uid = (uid_t) -1;
	buf->st_gid = (gid_t) -1;

	/* I should probably choose better values for errno */
	tmp = rd_vdir(path,0,dir,RVD_DFILE_ONLY|RVD_ATTRIB);
	if((dir->links == NULL) || (tmp && (tmp != DIRSRV_NOT_DIRECTORY))) {

	   if(((tmp == PFS_DIR_NOT_FOUND)||(tmp == RVD_DIR_NOT_THERE)|| !tmp)&&
	      (pfs_enable == PMAP_ATSIGN_NF) && (*path == '/')) {
	       return(syscall((lflag ? SYS_lstat : SYS_stat), path, buf));
	   }
	   errno = ENOENT;
	   return(-1);
	}

	if(tmp == 0) buf->st_mode |= (S_IFDIR | 0555);
	else buf->st_mode |= 0444;

	if(strncmp(dir->links->type,"EXTERNAL",8) == 0) ap = NULL;
	else ap = pget_at(dir->links,"ALL");

	/* If can't get real attributes, try those stored with link */
	if((ap == NULL) && dir->links->lattrib) {
	    ap = dir->links->lattrib;
	    dir->links->lattrib = NULL;
	}

	while(ap) {
	    switch (*(ap->aname)) {
	    case 'L':
		if((strcmp(ap->aname,"LAST-MODIFIED") == 0) &&
		   (strcmp(ap->avtype,"ASCII") == 0)) {
		    buf->st_mtime = asntotime(ap->value.ascii);
		}
		break;

	    case 'S':
		if((strcmp(ap->aname,"SIZE") == 0) &&
		   (strcmp(ap->avtype,"ASCII") == 0)) {
		    int		size;
		    sscanf(ap->value.ascii,"%d",&size);
		    buf->st_size = size;
		    /* The following is a good guess at number of blocks */
		    buf->st_blocks = (size+511) / 512;
		}
		break;

	    default:
		break;
	    }

	    nextap = ap->next;
	    atfree(ap);
	    ap = nextap;
	}
	vllfree(dir->links);
	vllfree(dir->ulinks);
	return(0);
    }
