/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

/*
 * pmachine.h - Processor/OS specific definitions
 */

/*
 * Machine types - Supported values
 *
 *   VAX, SUN, HP9000_S300, IBM_RTPC, ENCORE_NS32K,
 *   ENCORE_S93, ENCORE_S91, APOLLO, 
 * 
 *   MIPS_BE - MIPS Chip (Big Endian Byte Order)
 *   MIPS_LE - MIPS Chip (Little Endian Byte Order)
 *
 * Add others as needed.  
 *
 * Files that check these defintions:
 *   include/pmachine.h
 */
#define P_MACHINE_TYPE 		"VAX"
#define VAX

/*
 * Operating system - Supported values
 * 
 * ULTRIX, BSD43, SUNOS, SUNOS_V3, HPUX, SYSV, MACH, DOMAINOS
 *
 * Add others as needed.  
 *
 * Files that check these defintions:
 *   include/pmachine.h, lib/pcompat/opendir.c, lib/pcompat/readdir.c
 */
#define P_OS_TYPE		"ULTRIX"
#define ULTRIX

/*
 * Shell types - Supported values
 *
 *   CSH, SH
 *
 * The vcd and vfsetup commands and the vfsetup.source script
 * return commands to the shell that must be interpreted.  These 
 * commands set variables and define aliases.  By default,
 * Prospero is configured to return commands that can be
 * interpreted by the C shell.  If you would prefer to use
 * a different shell, define the shell type here.  You may have to 
 * add commands in the appropriate syntax to lib/pfs/penviorn.c
 * and to user/gen_vfsetup.c.  Note that whatever shell you use must
 * support aliases.  Only some versions of the Bourne shell do.  
 * Unfortunately, at present, only one shell type can be supported 
 * at a time.  This may be fixed in future releases.
 */
#define P_SHELL_TYPE		"CSH"
#define CSH


/*
 * Miscellaneous definitions
 *
 * Even within a particular hardware and OS type, not all systems
 * are configured identically.  Some systems may need additinal
 * definitions, some of which are included below.   Note that for
 * some system types, these are automatically defined.
 *
 * define NEED_MODE_T if mode_t is not typedefed on your system
 * define DD_SEEKLEN if your system doesn't support dd_bbase and dd_bsize
 * define DIRECT if direct is the name of your dirent structure
 * define USE_SYS_DIR_H if your system doesn't include dirent.h
 * define CLOSEDIR_RET_TYPE_VOID if your closedir returns void
 * Define GETDENTS if your system supports getdents instead of getdirentries
 */

/*****************************************************************/
/* If your machine and OS type are listed above, and if your     */
/* configuration is relatively standard for your machine and     */
/* OS, there should be no need for any changes below this point. */
/*****************************************************************/

/*
 * Machine or OS dependent parameters
 *
 *  The comment at the head of each section names the paramter
 *  and the files that use the definition
 */

/*
 *  BYTE_ORDER: lib/psrv/plog.c, lib/psrv/check_acl.c
 */
#define BIG_ENDIAN		1
#define LITTLE_ENDIAN		2

#if defined(SUN)        || defined(HP9000_S300) || defined(IBM_RTPC) || \
    defined(ENCORE_S91) || defined(ENCORE_S93)  || defined(APOLLO)   || \
    defined(MIPS_BE)
#define BYTE_ORDER BIG_ENDIAN
#else
#define BYTE_ORDER LITTLE_ENDIAN
#endif

/*
 * PUTENV: lib/pfs/vfsetenv.c
 *
 * PUTENV must be defined if your C library supports the putenv
 * call instead of setenv (e.g. Ultrix and SunOS).
 */
#if defined(ULTRIX) || defined(SUNOS) || defined(SUNOS_V3) || defined(HPUX)
#define PUTENV
#endif

/*
 * BADSETENV: lib/pfs/penviron.c
 *
 * Older BSD 4.3 systems have a bug in the C library routine setenv.
 * Define BADSETENV if you wish to compile a working version of this
 * this routine.
 * 
 * #define BADSETENV
 */

/*
 * NOREGEX: lib/pfs/wcmatch.c
 *
 * NOREGEX must be defined if your C library does not support the
 * re_comp and re_exec regular expression routines.
 */
#if defined(HPUX)
#define NOREGEX
#endif

/*
 * String and byte manipulating 
 * procedures: lib/pfs/nlsindex.c, lib/pfs/nxtline.c,
 *             lib/pfs/sindex.c, lib/pcompat/pfs_access.c
 */
#if defined(HPUX) || defined(SYSV)
#define index		strchr
#define rindex		strrchr
#define bcopy(a,b,n)	memmove(b,a,n)
#define bzero(a,n)	memset(a,0,n)
#endif

/*
 * getwd: server/pstart.c
 */
#if defined(HPUX) || defined(SYSV)
#define getwd(d)	getcwd(d, MAXPATHLEN)
#endif

/*
 * SETSID:  server/dirsrv.c
 *
 * SETSID is to be defined if the system supports the POSIX
 * setsid routine to create a new session and set the process 
 * group ID.
 */
#if defined(HPUX)
#define SETSID
#endif

/*
 * NFILES: user/vget/pclose.c
 *
 * NFILES is the size of the descriptor table.
 */
#if defined(HPUX)
#define NFILES _NFILE
#else
#define NFILES getdtablesize()
#endif

/*
 * SIGNAL_RET_TYPE: user/vget/ftp.c, user/vget/pclose.c
 *
 * This is the type retruned by the procedure returned by
 * signal.  In some systems it is void, in others int.
 *
 */
#if defined (BSD43) || defined(SUNOS_V3)
#define SIGNAL_RET_TYPE int
#else
#define SIGNAL_RET_TYPE void
#endif

/*
 * CLOSEDIR_RET_TYPE_VOID: lib/pcompat/closedir.c
 *
 * If set, closedir returns void.
 */
#if defined (NOTDEFINED) 
#define CLOSEDIR_RET_TYPE_VOID
#endif

/*
 * DIRECT: lib/pcompat/*dir.c app/ls.c
 *
 *  Use direct as the name of the dirent struct
 */
#if defined (NOTDEFINED) || defined(DIRECT)
#define dirent direct
#endif

/*
 * USE_SYS_DIR_H: lib/pcompat/*dir.c app/ls.c
 *
 *  Include the file <sys/dir.h> instead of <dirent.h>
 */
#if defined (NOTDEFINED)
#define USE_SYS_DIR_H
#endif

/*
 * DIR structure definitions: lib/pcompat/telldir.c,opendir.c
 */
#if defined (SUNOS) || defined(SUNOS_V3)
#define dd_bbase dd_off
#endif

#if defined (DD_SEEKLEN)
#define dd_bbase dd_seek
#define dd_bsize dd_len
#endif
 
/*
 * GETDENTS: lib/pcompar/readdir.c
 *
 * Define GETDENTS if your system supports getdents instead of
 * getdirentries.
 */
#if defined (GETDENTS)
#define getdirentries(F,B,N,P) getdents(F,B,N)
#endif

/*
 * NEED MODE_T typedef: ls.c
 *
 * Define this if mode_t is not defined my your systems include
 * files (sys/types.h or sys/stdtypes.h or sys/stat.h).
 */
#if defined (NEED_MODE_T)
typedef unsigned short mode_t;
#endif

/*
 * Catch any definitions not in system include files
 *
 *  The comment at the head of each section names the paramter
 *  and the files that use the definition
 */

/*
 * OPEN_MAX: Maximum number of files a process can have open
 */
#ifndef OPEN_MAX
#define OPEN_MAX 64
#endif

/*
 * FD_SET: lib/pfs/dirsend.c, user/vget/ftp.c
 */
#ifndef FD_SET
#define	NFDBITS		32
#define	FD_SETSIZE	32
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif
 
/*
 * howmany: app/ls.c
 */
#ifndef	howmany
#define	howmany(x, y)   ((((u_int)(x))+(((u_int)(y))-1))/((u_int)(y)))
#endif

/*
 * MAXHOSTNAMELEN: user/vget/ftp.c
 */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/*
 * O_ACCMODE: lib/pcompat/open.c
 */
#ifndef O_ACCMODE
#define O_ACCMODE         (O_RDONLY|O_WRONLY|O_RDWR)
#endif

/*
 * Definitions from stat.h: app/ls.c lib/pfs/mkdirs.c
 */
#ifndef S_IFMT
#define S_IFMT	 070000
#endif
#ifndef S_IFDIR
#define S_IFDIR	 040000
#endif
#ifndef S_IFCHR
#define S_IFCHR 020000
#endif
#ifndef S_IFBLK
#define S_IFBLK 060000
#endif
#ifndef S_IXUSR
#define S_IXUSR 0100
#endif
#ifndef S_IXGRP
#define S_IXGRP 0010
#endif
#ifndef S_IXOTH
#define S_IXOTH 0001
#endif
#ifndef S_ISDIR
#define	S_ISDIR(mode)  (((mode) & S_IFMT) == S_IFDIR)
#endif
#ifndef S_ISCHR
#define S_ISCHR(m)  ((S_IFLNK & m) == S_IFCHR)
#endif  
#ifndef S_ISBLK
#define S_ISBLK(m)  ((S_IFLNK & m) == S_IFBLK)
#endif
