/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993  by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 *
 * Written  by bcn 1989     modified 1989-1992
 * Modified by swa 3Q/92    V5 support, modularize, quoting, multiple names
 * Modified by bcn 1/20/93  support multiple database prefixes
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <netdb.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/param.h>

#include <ardp.h>
#include <pfs.h>
#include <pparse.h>
#include <pserver.h>
#include <psrv.h>
#include <plog.h>
#include <pprot.h>
#include <perrno.h>
#include <pmachine.h>

#include "dirsrv.h"

TOKEN p__tokenize_midstyle_mcomp(char *nextname);

/*
    Uncomment this for debugging purposes.

    #define SERVER_PREDEFINED_IDENTITY_FILTER
    static identity_filter(VDIR dir, TOKEN args);
*/

static int list_name(RREQ req, char *command, char arg_client_dir[],
        int dir_magic_no, TOKEN components, int verify_dir,
        int localexp, int attribfl, int alllinks, FILTER filters);

#ifdef ARCHIE
extern int archie_supported_version;
#endif

int list(RREQ req, char **commandp, char **next_wordp, INPUT in,
        char client_dir[], int dir_magic_no)
{
 /* Flags */
    int attribfl;	/* Send back atribues in list  */
    int localexp;	/* OK to exp ul for remcomp    */
    int verify_dir;	/* Only verifying the directory */
    int filterfl = 0;	/* specified the filter flag. */
    FILTER filters = NULL;	/* filters to apply */
    optdecl;
    int tmp;
    char t_options[MAX_DIR_LINESIZE];
    char t_name[MAX_DIR_LINESIZE];
    char *nextname;	/* Next name to be resolved. */
    int retval;	/* Value returned by list_name.  */
    long dummy_magic_no;	/* XXX currently ignored; shouldn't be. */

    nextname = NULL;
 /* Assume we can freely overwrite the buffer. */
    tmp = qsscanf(*next_wordp, "%'!!s COMPONENTS %r",
	t_options, sizeof t_options, &nextname);
    if (tmp < 0)
	interr_buffer_full();

    if (in_select(in, &dummy_magic_no))
	return error_reply(req, "LIST: %'s", p_err_string);
 /* At this point, t_options is a '+'-separated list of options and nextname
    should point to a space-separated list of names. */

 /* Parse the options. */
    optstart(t_options);
    verify_dir = opttest("VERIFY") ? 1 : 0;
 /* If EXPAND specified, remeber that fact */
    if (opttest("EXPAND") || opttest("LEXPAND"))
	localexp = 2;
    else
	localexp = 0;
    if (opttest("ATTRIBUTES"))
	attribfl = DSRD_ATTRIBUTES;
    else
	attribfl = 0;
    if (opttest("FILTER")) {
    /* leave commandp set the way it was, since we need it to report errors. */
	char *line, *next_word;
	filterfl = 1;
        if (localexp)
            return error_reply(req, "FILTER flag cannot be specified with \
LEXPAND or EXPAND flags: %'s\n", *commandp); 
        while (in_nextline(in) && strnequal(in_nextline(in), "FILTER", 6)) {
	    FILTER cur_fil;

	    if (in_line(in, &line, &next_word)) {
		fllfree(filters);
		return PFAILURE;	/* error reporting done by in_line() */
	    }
	    if (in_filter(in, line, next_word, 0, &cur_fil)) {
		fllfree(filters);
		return error_reply(req, "Could not parse a filter: %'s",
		    p_err_string, 0);
	    }
	    if (cur_fil->execution_location != FIL_SERVER || cur_fil->link
		|| (cur_fil->type != FIL_DIRECTORY
		    && cur_fil->type != FIL_HIERARCHY)
		|| cur_fil->pre_or_post != FIL_PRE) {
		fllfree(filters);
		flfree(cur_fil);
		return error_reply(req, "All filters to be applied at the\
 server must have an execution location of SERVER and be PRE-expansion and be\
 DIRECTORY or HIERARCHY filters and be PREDEFINED.  This one\
 does not meet those criteria: %'s", line);
	    }
	    APPEND_ITEM(cur_fil, filters);
	/* Checking for whether this filter is defined on this server occurs
	   in list_name(), when we dispatch to the particular filter. */
	}
	if (!filters)
	    return error_reply(req, "LIST had FILTER option specified, but no \
filters were given.");
    } else {
	filterfl = 0;
    }

    plog(L_DIR_REQUEST, req, "L%s %s %s",
	(verify_dir ? "V" : " "), client_dir, (nextname ? nextname : "*"));
    {
        int listall_flag;
        TOKEN comps;

#ifdef REALLY_NEW_MCOMP
         /* No clients left that transmit old styles, so guaranteed not to need
            to adapt to both. */
        if (nextname) comps = qtokenize(nextname);
#else   /* There are some old-style clients.  (accept both styles; transmit
           old). */ 
        if (nextname) comps = p__tokenize_midstyle_mcomp(nextname);
#endif        
        else {
            listall_flag = 1;
            /* COMPS shouldn't ever be looked at when listall flag is passed, but it is. */
            comps = tkalloc("*");                      
        }
        retval = list_name(req, *commandp, client_dir, dir_magic_no, comps, verify_dir, 
                           localexp, attribfl, listall_flag, filters); 
        tklfree(comps);
    }
    fllfree(filters);
    return retval;
}



static int list_name(RREQ req, char *command, char arg_client_dir[], int dir_magic_no,
        TOKEN remcomp, int verify_dir,
        int localexp, int attribfl, int alllinks, FILTER filters)
{
    char *thiscomp;             /* component being worked on */
    TOKEN orig_remcomp = remcomp; /* pointer to original value of remcomp.
                                       Never changes. */ 
    VLINK uexp;	/* Current link being expanded, or NULL, or pointer to a
                   PLACEHOLDER union link (referring to current directory) */
    VLINK real_uexp;            /* ulink really being expanded (if any) */
    char client_dir[MAXPATHLEN];	/* Current directory.  We make this a
					   temporary, because it is modified
					   by list_name. */
    int item_count = 0;	/* Count of returned items                 */
    FILTER cfil;	/* For iterating through filters.          */
    VLINK clink;	/* For stepping through links              */
    VLINK crep;	/* For stepping through replicas           */
    long dir_version = 0;	/* Directory version nbr-currently ignored */
    char dir_type[40];	/* Type of dir name (Currently, the only supported
			   value is ASCII)  */
    VDIR_ST dir_st;	/* Directory contents used ...             */
    VDIR dir = &dir_st;	/* by individual lines                     */
    int dsdb_options = 0;	/* Options to pass to dsdb                 */
    int retval;	/* Return value from subfunctions          */
    int laclchkl;	/* Cached ACL check                        */
    int daclchkl;	/* Cached ACL check                        */
    int laclchkr;	/* Cached ACL check                        */
    int daclchkr;	/* Cached ACL check                        */
    PATTRIB ca;	/* Current Attribute                       */
    OUTPUT_ST out_st;
    OUTPUT out = &out_st;
    int i;
    int orig_localexp = localexp;	/* don't change this cached copy. */
#ifdef ARCHIE
    int already_applied_ar_domain = 0;
    int already_applied_ar_pathcomp = 0;
#endif

    reqtoout(req, out);
    vdir_init(dir);

    strcpy(client_dir, arg_client_dir);

    goto list_start;	/* Start in the middle :) This actually makes
			   reasonable sense. */

 /* Here's where we start to resolve additional components */

more_comps:
 /* Set the directory for the next component */

 /* At this point, clink contains the link for the next */
 /* directory, and the directory itself is still filled */
 /* in.  We should save away the directory information, */
 /* then free what remains                              */
    dir_version = clink->version;
    dir_magic_no = clink->f_magic_no;

    strcpy(dir_type, clink->hsonametype);
    strcpy(client_dir, clink->hsoname);

    if (strcmp(dir_type, "ASCII")) {
	creplyf(req, "ERROR id-type %'s not supported\n", dir_type);
	plog(L_DIR_ERR, req, "Invalid id-type: %s", command, 0);
	vdir_freelinks(dir);
	return PFAILURE;
    }
    if (check_handle(client_dir) == FALSE) {
	creply(req, "FAILURE NOT-AUTHORIZED\n");
	plog(L_AUTH_ERR, req, "Invalid directory name: %s", client_dir, 0);
    /* Free the directory links */
	vdir_freelinks(dir);
	return PFAILURE;
    }
    vdir_freelinks(dir);

list_start:

    /* list_start always is entered with a clean directory. */
    thiscomp = remcomp->token;
    remcomp = remcomp->next;
 /* THISCOMP refers to a single name-component.  REMCOMP may refer to
    additional components of a multiple-component name that should be
    resolved. */
    real_uexp = uexp = NULL;
    if (localexp) {
        /* Add a placeholder union link to indicate that the current directory
           is already being expanded, so don't expand it again.  This handles
           recursive union links (a fairly frequent case) more efficiently than
           not including this check.  */
        assert(uexp = vlalloc());
        uexp->host = stcopyr(hostwport, uexp->host);
        uexp->hsoname = stcopyr(client_dir, uexp->hsoname);
        uexp->f_magic_no = dir_magic_no;
        uexp->expanded = ULINK_PLACEHOLDER; 
        dir->ulinks = uexp;
    }

 /* If only expanding last component, clear the flag */
    if (localexp == 1)
	localexp = 0;

 /* If remaining components, expand for this component only */
    if (remcomp && !localexp)
	localexp = 1;
exp_ulink:

    *p_err_string = '\0';
    *p_warn_string = '\0';

    if (*client_dir != '/') {	/* Database or special prefix in use */
    /* XXX Code in the functions, such as create_link, should check for */
    /* attempts to write to database directories and return a message   */
    /* explaining that database directories are READ-ONLY.  Right now,  */
    /* the user gets incomprehensible error messages.  This will be     */
    /* especially needed when people try to customize directories.      */

	for (i = 0; i < db_num_ents; i++) {
	    if (strncmp(client_dir, db_prefixes[i].db_prefix,
		    strlen(db_prefixes[i].db_prefix)) == 0) {
                if (real_uexp) {
                    /* Don't attempt to use database function to locally expand
                       union links.  Otherwise we'd have to pass a uexp
                       argument to dsdb(). */
                    real_uexp->expanded = FAILED;
                    goto dbquery_done;
                }
		if (db_prefixes[i].db_acl &&
		    !check_acl(db_prefixes[i].db_acl, NULL, req, "r")) {
		    creply(req, "FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR, req, "Unauthorized database request: %s %s",
			client_dir, thiscomp, 0);
		    return PFAILURE;
		}
	    /* This could take a while, tell client not to retry */
		ardp_rwait(req, 180, 0, 0);
		if (verify_dir)
		    dsdb_options |= DSDB_VERIFY;
		retval = db_prefixes[i].db_function(req, client_dir, 
                     &thiscomp, &remcomp, dir, dsdb_options,
		    "#INTERESTING" /* requested attributes */ , filters);
		goto dbquery_done;
	    }
	}
    /* Here we have a prefix that is not a database, */
    /* but probably not a normal filename either     */

    /* If normal file names need not begin with /    */
    /* fall through and try a normal query           */
    }
    retval = dsrdir(client_dir, dir_magic_no, dir, uexp, attribfl);

    if (retval > 0 && real_uexp) real_uexp->expanded = FAILED;
dbquery_done:

    /* This code handles the case of a failure return from dsrdir() or dsdb()
       while we're locally expanding a union link. */
    /* XXX This is not a perfect  patch, because, in the case of the PFAILURE 
       return, the directory may already contain partial information from
       expanding the intermediate union link.    We really need to save the old
       state of the directory (immediately previous to the failed link
       expansion attempt) and return just that.  However, for all other error
       returns from dsrdir() (which don't leave a partially munged directory),
       this will solve most cases of the problem.   Don't know about dsdb()
       though -- that may be written by those who don't adhere to this
       convention. */
    /* If we have a directory with more than just the PLACEHOLDER union
       link, then we should return the union links & UNRESOLVED if
       necessary. */
    if (real_uexp && real_uexp->expanded == FAILED) goto return_links;

    if (retval == DSRFINFO_FORWARDED) {
        /* We are NOT in the process of expanding a union link, since if we
           were, the above test would have caught it. */
        if (orig_remcomp != remcomp) {
            /* XXX We should update the local link to point to the new location
               too. */
            retval = dlinkforwarded(req, out, client_dir, dir_magic_no, dir,
                                    thiscomp);
            if (retval) return retval;
            if (remcomp) {
#ifdef REALLY_NEW_MCOMP
                replyf(req, "UNRESOLVED");
                out_sequence(out, remcomp);
#else
                TOKEN acp;

                replyf(req, "UNRESOLVED %'s", remcomp->token);
                for (acp = remcomp->next; acp; acp = acp->next)
                    replyf(req, "/%'s", acp->token);
                reply(req, "\n");
#endif
            }
        } else
            dforwarded(req, client_dir, dir_magic_no, dir);
	return (PSUCCESS);
    }
 /* If not a directory, say so */
    if (retval == DSRDIR_NOT_A_DIRECTORY) {
	creply(req, "FAILURE NOT-A-DIRECTORY\n");
	return (PFAILURE);
    }
 /* If not authorized, say so */
    if (retval == DIRSRV_NOT_AUTHORIZED) {
	if (*p_err_string)
	    creplyf(req, "FAILURE NOT-AUTHORIZED %'s\n", p_err_string, 0);
	else
	    creply(req, "FAILURE NOT-AUTHORIZED\n");
	return (PFAILURE);
    }
 /* If too many links in response, say so */
    if (retval == DIRSRV_TOO_MANY) {
	if (*p_err_string)
	    creplyf(req, "FAILURE TOO-MANY %'s\n", p_err_string, 0);
	else
	    creply(req, "FAILURE TOO-MANY\n");
	return (PFAILURE);
    }
 /* If some other failure, say so */
    if (retval) {
	if (*p_err_string)
	    creplyf(req, "FAILURE SERVER-FAILED %'s\n", p_err_string, 0);
	else
	    creply(req, "FAILURE SERVER-FAILED\n");
	return (retval);
    }
    if (*p_warn_string) {
	replyf(req, "WARNING MESSAGE %'s\n", p_warn_string);
	*p_warn_string = '\0';
    }
 /* Cache the default answers for ACL checks */
    daclchkl = check_acl(dir->dacl, NULL, req, "l");
    daclchkr = check_acl(dir->dacl, NULL, req, "r");

    for (; filters; filters = filters->next) {
        if (filters->pre_or_post == FIL_ALREADY) {
#ifdef ARCHIE
            if (strequal(filters->name, "AR_DOMAIN")) 
                ++already_applied_ar_domain;
            if (strequal(filters->name, "AR_PATHCOMP")) 
                ++already_applied_ar_pathcomp;
#endif
            continue;
        }

        /* PUT IN CODE HERE TO PROCESS PREDEFINED SERVER FILTERS */

#ifdef SERVER_PREDEFINED_IDENTITY_FILTER
        /* this only exists for debugging and demonstration purposes.  */
	if (strequal(filters->name, "IDENTITY")) {
	    retval = identity_filter(dir, filters->args);
	    if (retval) {
		creplyf(req, "FAILURE FILTER-APPLICATION Applying the %'s \
PREDEFINED SERVER filter yielded an error: %'s\n",
		    filters->name, p_err_string);
		return retval;
	    }
	} else
#endif

#ifdef ARCHIE
        /* If specified should have been applied as part of query. 
           If it were applied as part of the archie database query, it would 
           have been taken care of by the test above against FIL_ALREADY. */
        if (strequal(filters->name, "AR_DOMAIN") ||
	    strequal(filters->name, "AR_PATHCOMP")) {
            if (!already_applied_ar_domain || !already_applied_ar_pathcomp)
                creplyf(req, "FAILURE NOT-FOUND FILTER version %d archie servers do not support the PREDEFINED SERVER filter named %'s.\n",
                        archie_supported_version, filters->name);
            else
                creplyf(req, "FAILURE FILTER-APPLICATION The filter %'s \
cannot be applied more than once.\n", filters->name);
            return (PFAILURE);
	} else
#endif	/* ARCHIE */

	{
	/* Filter not found. */
	    creplyf(req, "FAILURE NOT-FOUND FILTER This server does not \
support the PREDEFINED SERVER filter named %'s.\n", filters->name);
	    return PFAILURE;
	}
    }

 return_links:

    /* Here we must send back the links, excluding those that do */
    /* not match the component name. For each link, we must also */
    /* send back any replicas or links with conflicting names    */
    for (clink = dir->links; clink; clink = clink->next) {
	crep = clink;
	while (crep) {
            /* If ->expanded set means we already returned it */
	    if (crep->expanded) {
		crep = crep->next;
		continue;
	    }
            /* Check individual ACL only if necessary */
	    laclchkl = daclchkl;
	    laclchkr = daclchkr;
	    if (crep->acl) {
		laclchkl = check_acl(dir->dacl, crep->acl, req, "l");
		laclchkr = check_acl(dir->dacl, crep->acl, req, "r");
	    }
	    if (!verify_dir && wcmatch(crep->name, thiscomp) &&
		(laclchkl || (laclchkr &&
			(strcmp(crep->name, thiscomp) == 0)))) {
		if (laclchkr) {
		    if (remcomp && strequal(crep->host, hostwport) &&
			!(crep->filters) && !item_count) {
		    /* If components remain on this host    */
		    /* don't reply, but continue searching  */
			goto more_comps;
		    }
		    qoprintf(out, "LINK ");
		    out_link(out, crep, 0, (TOKEN) NULL);
		/* If link attributes are to be returned, do so */
		/* For now, only link attributes returned       */
		/* XXX this is not all of what we want.  We need to be able to
		   explicitly read the values of attributes such as DEST-EXP
		   and ID.  But this is all we need to get Gopher running. */
		    if (attribfl) {
			for (ca = crep->lattrib; ca; ca = ca->next) {
			/* For now return all attributes. To be done: */
			/* return only those requested                */
			    if (1) {
				out_atr(out, ca, 0);
			    }
			}
		    } else {
		    /* No attribute flag specified.   Return ACCESS-METHOD for
		       EXTERNAL links anyway. */
			if (strequal(crep->target, "EXTERNAL"))
			    for (ca = crep->lattrib; ca; ca = ca->next)
				if (strequal(ca->aname, "ACCESS-METHOD"))
				    out_atr(out, ca, 0);
		    }
		/* If there are any filters, send them back too */

		    if (laclchkr) {
			for (cfil = crep->filters; cfil; cfil = cfil->next) {
#ifdef REALLY_NEW_FIELD
			    qoprintf(out,
                                     "ATTRIBUTE LINK FIELD FILTER FILTER ");
#else
			    qoprintf(out, "ATTRIBUTE LINK FIELD FILTER ");
#endif
			    out_filter(out, cfil, 0);
			}
		    }
		} else {
		/* If list access but no read access, just acknowledge that
		   the link exists. */
		    replyf(req, "LINK L NULL %s NULL NULL NULL NULL 0\n",
			crep->name);
		}
	    /* Using ->expanded to indicate returned */
		crep->expanded = TRUE;
		item_count++;
	    }
	/* Replicas are linked through next, not replicas */
	/* But the primary link is linked to the replica  */
	/* list through replicas                          */
	    if (crep == clink)
		crep = crep->replicas;
	    else
		crep = crep->next;
	}
    }

    /* here we must send back the unexpanded union links */
    for(clink = dir->ulinks; clink && !verify_dir; clink = clink->next) {
	if (clink->expanded == ULINK_PLACEHOLDER)
	    continue;	/* never return or process this link. */
        /* Neither return nor expand links that have been successfully expanded
           */ 
	if (clink->expanded != TRUE &&
	    check_acl(dir->dacl, clink->acl, req, "r")) {
	    if (!clink->expanded && localexp && !(clink->filters) &&
		strequal(clink->host, hostwport)) {
	    /* Set the directory for the next component   */
	    /* At this point, clink contains the link     */
	    /* for the next directory                     */
		dir_version = clink->version;
		dir_magic_no = clink->f_magic_no;

		strcpy(dir_type, clink->hsonametype);
		strcpy(client_dir, clink->hsoname);

		if (!strequal(dir_type, "ASCII")) {
		    creplyf(req,
			"ERROR Directory Handle Type %s not supported\n",
			dir_type, 0);
		    plog(L_DIR_ERR, req, "Invalid id-type: %s", command, 0);
		    vdir_freelinks(dir);
		    return PFAILURE;
		}
		if (check_handle(client_dir) == FALSE) {
		    creply(req, "FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR, req, "Invalid directory name: %s",
			client_dir, 0);
		    vdir_freelinks(dir);
		    return PFAILURE;
		}
		clink->expanded = TRUE;	/* Probably won't fail for current
                                           link.  If it does, code above will
                                           reset this to FAILED. */
		real_uexp = uexp = clink;
		goto exp_ulink;
	    }
            /* If the user explicitly requested that union links be expanded
               (original localexp == 2) or if we ended up expanding these links
               as part of the intermediate stages of processing a multi-
               component name (localexp == 1) then the user doesn't care about
               seeing union links for the current directory, nor does he or she
               care about getting two union links that agree in hsoname and
               host but disagree in their NAME field.  */
	    if (clink->expanded == ULINK_DONT_EXPAND 
                && orig_localexp)
		continue;
            /* Once one union link is going to be returned, don't do any more
               expanding. */ 
	    localexp = 0;
	    qoprintf(out, "LINK ");
	    out_link(out, clink, 0, (TOKEN) NULL);
	    item_count++;
            /* if there are any filters */
	    for (cfil = clink->filters; cfil; cfil = cfil->next) {
#ifdef REALLY_NEW_FIELD
		qoprintf(out, "ATTRIBUTE LINK FIELD FILTER FILTER ");
#else
		qoprintf(out, "ATTRIBUTE LINK FIELD FILTER ");
#endif
		out_filter(out, cfil, 1);
	    }
	}
    }

 /* If none match, say so */
    if (!item_count)
	reply(req, "NONE-FOUND\n");
 /* Otherwise, if components remain say so */
    else if (remcomp) {
#ifdef REALLY_NEW_MCOMP
	replyf(req, "UNRESOLVED");
        out_sequence(out, remcomp);
#else
        TOKEN acp;

        replyf(req, "UNRESOLVED %'s", remcomp->token);
        for (acp = remcomp->next; acp; acp = acp->next)
            replyf(req, "/%'s", acp->token);
        reply(req, "\n");
#endif
    }

   /* Free the directory links */
    vdir_freelinks(dir);
    return PSUCCESS;
}


#ifdef SERVER_PREDEFINED_IDENTITY_FILTER
/* Return PSUCCESS on success; failure indication otherwise & set p_err_string.
   This is a sample filter to demonstrate how one writes such things.  It's
   also useful for debugging filters. */
static int identity_filter(VDIR dir, TOKEN args)
{
    dir->inc_native = VDIN_PSEUDO;
    return PSUCCESS;
}

#endif /* SERVER_PREDEFINED_IDENTITY_FILTER */
