/* replyf.c */
/*
 * Copyright (c) 1989, 1990 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdarg.h>

#include <ardp.h>
#include <pfs.h>
#include <plog.h>
#include <pprot.h>


/*
 * Note: If you are looking for the definitions of reply and creply
 *       they are defined as macros that call ardp_reply with
 *       the ARDP_R_COMPLETE or ARDP_R_INCOMPLETE flags.  
 *       This file defines the formatted versions of these
 *       commands, replyf and creplyf.
 */


int
replyf(RREQ req, char *format, ...)
{
    va_list ap;
    int retval;

    va_start(ap, format);
    retval = vreplyf(req, format, ap);
    va_end(ap);
    return retval;
}

int
vreplyf(RREQ req, char *format, va_list ap)
{
    char 	buf[MAX_DIR_LINESIZE];
    int n;                      /* # of characters possibly written. */

    n = vqsprintf(buf, sizeof buf, format, ap);
    /* XXX We need an error handler if we run out of space. */
    /* Perform the reply and pass through any error codes */
    return(ardp_reply(req, ARDP_R_INCOMPLETE, buf));
}


int
creplyf(RREQ req, char *format, ...)
{
    va_list ap;
    int retval;

    va_start(ap, format);
    retval = vcreplyf(req, format, ap);
    va_end(ap);
    return retval;
}

int
vcreplyf(RREQ req, char *format, va_list ap)
{
    char 	buf[MAX_DIR_LINESIZE];
    int n;                      /* # of characters possibly written. */

    n = vqsprintf(buf, sizeof buf, format, ap);
    /* XXX We need an error handler if we run out of space. */
    /* Perform the reply and pass through any error codes */
    return(ardp_reply(req, ARDP_R_COMPLETE, buf));
}


