/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>
 */

#include <usc-copyr.h>
#include <pfs.h>                /* def of PATTRIB */
#include <psrv.h>               /* prototype for delete_matching_at() */
#include <list_macros.h>        /* EXTRACT_ITEM macro */

/* Looks for an attribute equal to the key according to the equal function.
   Deletes & frees it. 
   Returns: PSUCCESS or PFAILURE 
   This is currently only used in ed_link_info.c and ed_obj_info.c
*/
int
delete_matching_at(PATTRIB key, PATTRIB *headp, int (*equal)(PATTRIB, PATTRIB))
{
    PATTRIB index;
    /* Find the match. */
    for (index = *headp; index; index = index->next) {
        if ((*equal)(key, index)) {
            EXTRACT_ITEM(index, (*headp));
            atfree(index);
            return PSUCCESS;
        }
    }
    return PFAILURE;
}
                   
int
delete_matching_fl(FILTER key, FILTER *headp)
{
    FILTER index;
    /* Find the match. */
    for (index = *headp; index; index = index->next) {
        if (equal_filters(key, index)) {
            EXTRACT_ITEM(index, (*headp));
            flfree(index);
            return PSUCCESS;
        }
    }
    return PFAILURE;
}
