/*
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the file <usc-copyr.h>
 */

#include <usc-copyr.h>

/* Written, 9/18/92, swa@isi.edu */

/* Break up a string into space-separated tokens and recognize Prospero
   quoting.   This strips off the quoting in the process.  This function could
   also be called p__tokenize_newstyle_mcomp(), and it serves that function.
 */

#include <pfs.h>
#include <pprot.h>

TOKEN
qtokenize(s)
char *s;
{
    TOKEN retval;
    int tmp;
    char buf[MAX_DIR_LINESIZE];

    if (!s)
        return NULL;
    tmp = qsscanf(s, "%'!!s %r", buf, sizeof buf, &s);
    if (tmp < 0)
        internal_error("Buffer overflow!");
    if (tmp == 0)
        return NULL;
    if ((retval = tkalloc(buf)) == NULL)
        internal_error("tkalloc() out of memory!");
    if (tmp == 2)
        retval->next = qtokenize(s);
    return retval;
}
