/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <perrno.h>
#include <pmachine.h>

extern int	pfs_debug;
static PATTRIB expand_amat(PATTRIB ca, VLINK link);

/* Returns the chosen access method, or zero if failure. */
pget_am(link,ainfop,methods)
    VLINK	link;
    TOKEN	*ainfop;         /* This will be filled in with access info
                                   data.  */
    int		methods;        /* Methods this client supports */
{
    PATTRIB     hits = NULL;    /* list of the hits.                     */
    PATTRIB     ca;

    perrno = PSUCCESS;


    if(strcmp(link->target,"NULL") == 0) 
        return(0);
    *ainfop = (TOKEN) NULL;
    if (strequal(link->target,"EXTERNAL")) {
        /* For an EXTERNAL link, the access method should be somewhere on
           the lattrib list.   This is guaranteed by the way I implemented
           the LIST operation on the server.   Yes, I KNOW this is a hack, and
           should be fixed.  XXX --swa */
        PATTRIB ca;
        for (ca = link->lattrib; ca; ca = ca->next)
            if (strequal(ca->aname, "ACCESS-METHOD")) {
                PATTRIB amat = expand_amat(ca, link);
                APPEND_ITEM(amat, hits);
            }
    } else {
        /* For a link that's not external, the access method must be
           retrieved via pget_at.  HMM.  We could try to retrieve it off of the
           lattrib member, if present, but that value is not guaranteed to be
           accurate. */
        hits = pget_at(link, "ACCESS-METHOD");
    }            
    /* Now, go through each of the hits, if any.  */
    for (ca = hits; ca; ca = ca->next) {
        /* First element of the sequence is the name of the access method. */
        
        if((methods & P_AM_LOCAL) 
           && (strequal(ca->value.sequence->token,"LOCAL"))) {
            if (length(ca->value.sequence) != 5)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_LOCAL);
        }
        if((methods & P_AM_NFS) 
           && (strequal(ca->value.sequence->token,"NFS"))) {
            if (length(ca->value.sequence) != 6)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_NFS);
        }
        if((methods & P_AM_AFS) 
           && (strequal(ca->value.sequence->token,"AFS"))) {
            if (length(ca->value.sequence) != 5)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_AFS);
        }
        if((methods & P_AM_AFTP) 
           && (strequal(ca->value.sequence->token,"AFTP"))) {
            if (length(ca->value.sequence) != 6)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_AFTP);
        }
        if((methods & P_AM_GOPHER) 
           && (strequal(ca->value.sequence->token,"GOPHER"))) {
            if (length(ca->value.sequence) != 5)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_GOPHER);
        }
        if((methods & P_AM_RCP) 
           && (strequal(ca->value.sequence->token,"RCP"))) {
            if (length(ca->value.sequence) != 5)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_RCP);
        }
        /* The FTP method requires prompting for a password, which is not
           transparent to the user.  Thus, it is the least desirable method,
           from our point of view. */
        if((methods & P_AM_FTP) 
           && (strequal(ca->value.sequence->token,"FTP"))) {            
            if (length(ca->value.sequence) != 6)
                goto wrong_length;
            *ainfop = ca->value.sequence;
            ca->value.sequence = (TOKEN) NULL;
            atlfree(hits);
            return(P_AM_FTP);
        }
    }
    atlfree(hits);
    return 0;

 wrong_length:
    qsprintf(p_err_string, P_ERR_STRING_SZ, "Parse error: the server returned \
ACCESS-METHOD %s%swith %d elements; not what was expected by pget_am()!", 
             length(ca->value.sequence) > 0 ? ca->value.sequence->token : "",
             length(ca->value.sequence) > 0 ? " " : "",
             length(ca->value.sequence));
    perrno = PARSE_ERROR;
    atlfree(hits);
    return 0;
}


/* Copy an attribute and expand it. */
static PATTRIB 
expand_amat(PATTRIB ca, VLINK link)
{
    TOKEN tk;

    /* Check both that the copy had enough memory and that the passed access
       method attribute was correctly formed. */
    assert((ca = atcopy(ca)) && ca->value.sequence 
            && length(ca->value.sequence) >= 5);
    tk = ca->value.sequence;

    tk = tk->next;              /* skip access method name */
    if(*tk->token == '\0') tk->token = stcopyr(link->hosttype, tk->token);
    tk = tk->next;              /* go on */
    if(*tk->token == '\0') tk->token = stcopyr(link->host, tk->token);
    tk = tk->next;              /* go on */
    if(*tk->token == '\0') tk->token = stcopyr(link->hsonametype, tk->token);
    tk = tk->next;              /* go on */
    if(*tk->token == '\0') tk->token = stcopyr(link->hsoname, tk->token);
    return ca;
}
