/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 *
 * The menu API and client were written by Kwynn Buess (buess@isi.edu)
 */

#include <usc-copyr.h>



#include <stdio.h>
#include <string.h>
#include <pfs.h>
#include "config.h"
#include "p_menu.h"
#include "menu.h"
char *getenv();

void 
open_and_display(VLINK link) { 
  pid_t pid;
  int fd ;
  char *dummy_argv[2];
  char *error_msg = "\nunable to retrieve this file\n\n";
  void save_file(VLINK);
  void mail_file(VLINK);
  void print_file(VLINK);
  int get_option();
  int option;
  static char *pager;           /* pager to use */

  if (!pager) {
      pager = getenv("PAGER");
      if (!pager) pager = "more";
  }
  fd = m_open_file(link);
  if (fd == -1) {
    fprintf(stderr,"%s",error_msg);
    return;
  }

  pid = fork();
  if (pid == -1) {
    fprintf(stderr,"%s",error_msg);
    return;
  }
  if (pid == 0) { 
    if (dup2(fd,0) == -1) {
      fprintf(stderr,"%s",error_msg);
      return;
    }
    dummy_argv[0] = pager;
    dummy_argv[1] = NULL;
    printf("\n\nOpening %s...\n\n\n\n",m_item_description(link));
    if (execvp(pager,dummy_argv) == -1) {
      fprintf(stderr,"%s",error_msg);
      return;
    }
    exit(0);
  }
  else {
    wait((int *)NULL);
    close(fd);    

    printf(
"\n\nPress <RETURN> to continue, <m> to mail, <s> to save, or <p> to print:");
    option = get_option();
    if (option == -1) return;
    if (option == 's') save_file(link);
    else if (option == 'm') mail_file(link);
    else if (option == 'p') print_file(link);


  }
}

void save_file (VLINK link) { 
  char *name;
  FILE *org_file;
  FILE *save_file;
  int temp = 25;
  int err;
  char *get_line();

  printf("\n\nEnter save file name: ");
  name = get_line();

  if (name == NULL) return;

  save_file = fopen(name,"w");
  while (save_file == NULL) { 
    printf("Error opening :  Enter new name or <Enter> to cancel: ");
    stfree(name);
    name = get_line();
    save_file = fopen(name,"w");
  }

  org_file = m_fopen_file(link);
  if (org_file == NULL) {
    fprintf(stderr,"\nunable to save file\n\n");
    fclose(save_file);
    return;
  }

  while (temp != EOF) {
    temp = fgetc(org_file);
    if (temp != EOF) err = fputc(temp,save_file);

    if (err == EOF) {
      fprintf(stderr,"\nunable to save file\n\n");
      fclose(save_file);
      fclose(org_file);
      return;
    }
    
  }

  fclose(save_file);
  fclose(org_file);
  
  return;
}

void mail_file(VLINK link) { 
  char *address;
  FILE *org_file;
  FILE *mail_file;
  int temp = 25;
  int err;
  int is_eof;
  char *get_line();
  static char *command = NULL;  /* KWYNN: NOTE THIS */

  printf("\n\nMail document to:");
  fflush(stdout);                /* KWYNN: NOTE THIS */
  address = get_line();
  if (address == NULL) return;
  
  command = qsprintf_stcopyr(command, "%s %s", MAIL_SENDING_PROGRAM, address);
           
  org_file = m_fopen_file(link);
  if (org_file == NULL) {
      fprintf(stderr,"\nUnable to retrieve file\n\n");
      return;
  }

  mail_file = popen(command,"w");
  if (mail_file == NULL) {
    fprintf(stderr,"\nUnable to invoke mail command\n\n");
    fclose(org_file);
    return;
  }

  while (temp != EOF) {
    temp = fgetc(org_file);
    if (temp != EOF) err = fputc(temp,mail_file);

    if (err == EOF) {
      fprintf(stderr,"\nunable to save file\n\n");
      fclose(save_file);
      fclose(org_file);
      return;
    }
  }    
  
  fclose(org_file);
  pclose(mail_file);

  return;
}

void print_file(VLINK link) { 
  FILE *org_file;
  FILE *print_file;
  int temp = 25;
  int err;
  int is_eof;
  char *get_line();
  char *command;

  org_file = m_fopen_file(link);
  if (org_file == NULL) {
    fprintf(stderr,"\nunable to print file\n\n");
    return;
  }


  print_file = popen(PRINT_PROGRAM,"w");
  if (print_file == NULL) {
    fprintf(stderr,"\nunable to print file\n\n");
    fclose(org_file);
    return;
  }

  while (temp != EOF) {
    temp = fgetc(org_file);
    if (temp != EOF) err = fputc(temp,print_file);

    if (err == EOF) {
      fprintf(stderr,"\nunable to print file\n\n");
      fclose(print_file);
      fclose(org_file);
      return;
    }
  }    
  
  fclose(org_file);
  pclose(print_file);

  return;

}

void open_telnet(VLINK link) 
{ 
    TOKEN args;                 /* Used to get access method args. */
    char *paren;                /* used during parsing. */
    char *endparen;             /* Used during parsing. */
    char *hostpart;             /* HOST breaks into host part & port part.  */
    char *portpart;             /* Either NULL or the start of a string whose
                                     numeric interpretation is the appropriate
                                     port.  */
    int ch_par;                 /* Used for fork(). */
    int tmp;                    /* Return from subfunctions */

    if(pget_am(link, &args, P_AM_TELNET) != P_AM_TELNET) {
    cant_find_am:
        fprintf(stderr, "Unable to find an appropriate access method to use \
this portal -- sorry.\n");
        return;
    }
    /* ARGS are guaranteed to be a safe copy for us to work with. */
    /* Length guaranteed by pget_am to be at least 5 elements. */
    tmp = qsscanf(elt(args, 2), "%r%*[^(]%r(%r%*d%r)", &hostpart, &paren, 
                  &portpart, &endparen);
    if (tmp < 1) goto cant_find_am;
    if (tmp >= 2) *paren = '\0';
    if (tmp < 4) portpart = NULL;
    else *endparen = '\0';

    /* HOSTPART and PORTPART are now both correctly set. */

    /* display prompt if present and not just the empty string. */    
    if (elt(args, 5) && *elt(args, 5)) 
        puts(elt(args, 5)); 
    /* Now fork.  */
    ch_par = fork();
    
    if (ch_par == -1) {
        perror("menu: fork() failed");
        return;
    } else if (ch_par == 0) { 
        /* CHILD */
        if (portpart) 
            execlp(TELNET_PROGRAM,TELNET_PROGRAM, hostpart,portpart,(char *)0);
        else execlp(TELNET_PROGRAM,TELNET_PROGRAM,hostpart, (char *) NULL);
        /* Only get here if the execlp() failed. */
        fprintf(stderr, 
                "Couldn't run the telnet program \"%s\" -- sorry!\n",
                TELNET_PROGRAM);
        _exit(1);
    } else {
        /* Parent */
        wait((int *)NULL);
    }
}

void open_data(VLINK link) { 
  int query_save_data();

  if (query_save_data()) save_file(link);
}


struct token *get_token (VLINK link,char *which_token) { 
  PATTRIB temp;
  PATTRIB highest = NULL;
  int compare_precedence(char,char); /* defined in comp.c */
  struct token *temp_tok;

  if (link == NULL) return NULL;
  if ((temp = link->lattrib) == NULL) return NULL;

  while (temp != NULL) { 
    if (!strcmp(which_token,temp->aname)) 
      if (highest == NULL) highest = temp;
      else if (
	       compare_precedence(highest->precedence,temp->precedence) == -1
	       )
	highest = temp;
    temp = temp->next;
  } /* while temp != NULL */

  if (highest == NULL) return NULL;
  return highest->value.sequence;
}

