/* Copyright (c) 1992 by the University of Southern California. */
/* For copying and distribution information, see the file <usc-copyr.h> */
#include <usc-copyr.h>

#include <pfs.h>
#include <pprot.h>

/* Returns PFAILURE or PSUCCESS. */
int
vqfprintf(FILE *outf, const char fmt[], va_list ap)
{
    int retval;
    
    static char *buf = NULL;
    static size_t bufsiz = 0;
    int n;

 again:
    if ((n = vqsprintf(buf, bufsiz, fmt, ap)) > bufsiz) {
        if (buf) stfree(buf);
        buf = stalloc(bufsiz = n);
        goto again;
    } else if (fputs(buf, outf) == EOF) {
        retval = PFAILURE;
    } else {
        retval = PSUCCESS;
    }
    return retval;
}
