/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 */

#include <usc-copyr.h>
#include <pfs.h>

char *
qsprintf_stcopyr(char *buf, char *fmt, ...)
{
    va_list ap;

    va_start(ap, buf);
    buf = vqsprintf_stcopyr(buf, fmt, ap);
    va_end(ap);
    return buf;
}


char *
vqsprintf_stcopyr(char *buf, char *fmt, va_list ap)
{
    int tmp;
 again:
    tmp = vqsprintf(buf, stsize(buf), fmt, ap);
    if (tmp > stsize(buf)) {
        stfree(buf);
        buf = stalloc(tmp);
        goto again;
    }
    return buf;
}

