/* psrv.h */

/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file <usc-copyr.h>
 */

#include <usc-copyr.h>
/* Cranked out by swa@isi.edu */

/* Definition for dsdb database functions */
#define	DSDB_VERIFY	0x1

#ifndef PPARSE_H_INCLUDED       /* needed for INPUT */
#include <pparse.h>
#endif

#if 0 /* This is ridiculous; I don't need it right now. */
/* Return values for the optquery() function. */
#define OPT_UNSET   0           /* Option not set. */
#define OPT_ARGS    1           /* Option set with arguments */
#define OPT_NOARGS  2           /* Option set with no arguments. */

struct opt {
    char *name;
    int used;                   /* reference if used. */
    struct opt *args;          /* The parsed argument string, set by the
                                  application. */ 
    char *argstring;            /* The unparsed arguments.  Not necessarily
                                   useful once the args have been generated. */
    struct opts *next;
};
typedef struct opt *OPT;
typedef struct opt OPT_ST;

extern OPT optalloc(char *name);
extern void optlfree(OPT);
extern OPT optparse(char * optionstr, char separator);
extern int optquery(OPT opts, char * optname);
extern OPT optargs(OPT opts, char * optname); /* Returns a list of tokens that
                                                 are the option's arguments. */
extern int optnargs(OPT opts, char *);    /* # of arguments to the option.  0
                                             if none specified. */
extern OPT optremaining(OPT opts);    /* Any options which haven't been queried
                                         yet. Check for leftovers! */
#endif /* 0 */

/* Temporary hack to get this going.  Don't want to waste the time to do more.
   The only option that currently takes arguments is "attributes".  And sending
   too much stuff back is never wrong, only slightly inefficient.  So we will
   Not Worry About It.
   */ 
#define optdecl char *optset_options
#define optstart(optstr) (optset_options = optstr)
#define opttest(optname) (sindex(optset_options, optname))

/* Flags for srv_change_acl */
#define SCA_LINK 0
#define SCA_DIRECTORY 1
#define SCA_LINKDIR 2
#define SCA_OBJECT 3
#define SCA_MISC 4
#define SCA_CONTAINER 4

#define reply(req, mesg) ardp_reply((req), ARDP_R_INCOMPLETE, (mesg))
#define creply(req, mesg) ardp_reply((req), ARDP_R_COMPLETE, (mesg))
extern int cvreplyf(RREQ, char *, va_list);
extern int creplyf(RREQ, char *, ...);
extern int replyf(RREQ, char *, ...);
int error_reply(RREQ req, char formatstring[], ...);

extern int dsrfinfo(char *nm, int magic, PFILE fi);
extern int dswfinfo(char *nm, PFILE fi);
extern int dsrdir(char *name,int magic,VDIR dir,VLINK ul,int flags);
extern int dswdir(char *name, VDIR dir);
extern int fdswdir_v5(FILE *vfs_dir, VDIR dir);
TOKEN   check_nfs(char filename[], long client_addr);
char *check_localpath(char filename[], long client_addr);
extern int srv_check_acl(ACL pacl,ACL sacl,RREQ req,char *op,int flags,char *objid,char *itemid);

extern int change_acl(ACL *aclp, ACL ae, RREQ req, int flags, ACL diracl);
extern ACL get_container_acl(char *path);

extern ACL maint_acl;

extern int delete_matching_at(PATTRIB key, PATTRIB *headp, 
                              int (*equal)(PATTRIB, PATTRIB));
extern int delete_matching_fl(FILTER key, FILTER *headp);


#ifdef PSRV_ARCHIE
int arch_dsdb(RREQ req, char name[], char **componentsp, TOKEN *rcompp, 
              VDIR dir, int options, const char *rattrib, FILTER filters);
#endif
#ifdef PSRV_GOPHER
int gopher_dsdb(RREQ req, char name[], char **componentsp, TOKEN *rcompp, 
                VDIR dir, int options, const char *rattrib, FILTER filters);
#endif
#ifdef PSRV_GOPHER_GW
int gopher_gw_dsdb(RREQ req, char name[], char **componentsp, TOKEN *rcompp, 
                   VDIR dir, int options, const char *rattrib, FILTER filters);
#endif
#ifdef PSRV_KERBEROS
extern int 
check_krb_auth(char *auth, struct sockaddr_in client, char **ret_client_name);
#endif


