/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 *
 * Written  by bcn 1989     modified 1989-1992
 * Modified by swa 7/28/92  to use qsscanf()
 * Modified by swa 1992     to break individual commands into modules
 * Modified by swa 1992     to support V5 protocol
 * Modified by bcn 1/19/93  to take args from environment and command loop
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <sgtty.h>
#include <strings.h>
#include <sys/signal.h>
#ifdef AIX
#include <time.h>
#include <signal.h>
#endif

#include <ardp.h>
#include <pserver.h>            /* must precede psrv.h since psrv.h prototypes
                                   check_krb_auth() only if
				   PSRV_KERBEROS defined. 
                                   */
#include <pfs.h>
#include <plog.h>
#include <pprot.h>
#include <psrv.h>
#include <perrno.h>
#include <pparse.h>

#include <pmachine.h>
#ifdef PSRV_P_PASSWORD
#include <ppasswd.h>
#endif
#include "dirsrv.h"

#define THREAD_COUNT	4       /* XXX threads not currently implemented.  */


extern int errno;

extern char	*acltypes[];

/* To check for memory leaks */
extern int vlink_count, pattrib_count, acl_count,    pfile_count;
extern int rreq_count,  ptext_count,   string_count, token_count; 
extern int pauth_count, opt_count,     filter_count;

extern int vlink_max,   pattrib_max,   acl_max,      pfile_max;
extern int rreq_max,    ptext_max,     string_max,   token_max;
extern int pauth_max,   opt_max,       filter_max;
#ifdef PSRV_GOPHER_GW
extern int glink_count, glink_max;
#endif

extern int pQlen;

static	cmd_lookup();
VLINK	check_fwd();
char	*month_sname();
char	*getenv();
static int auth_fail_reply(RREQ req, char formatstring[], ...);

char    	prog[MAXPATHLEN];
int 		fault_count = 0; /* # of serious faults in the server -- # of
                                  times it has had to be automatically
                                  restarted.  */
/* #define DIRSRV_EXPLAIN_LAST_RESTART to report on the last request made to
   the server before it crashed. */ 
#ifdef DIRSRV_EXPLAIN_LAST_RESTART
char		last_request[ARDP_PTXT_LEN_R] = "";
#endif
char		*last_error = NULL;
char		st_time_str[40];

int		in_port = -1;
char		*portname = NULL;

static int    		mflag = 0;       /* Manual start of server         */

int		req_count = 0;
#ifdef SERVER_SUPPORT_V1
int             v1_req_count = 0;
int             crdir_count = 0;
#endif
int		crlnk_count = 0;
int		crobj_count = 0;
int		dellnk_count = 0;
int		eoi_count = 0;
int		goi_count = 0;
int		list_count = 0;
int		lacl_count = 0;
int		eli_count = 0;
int		eacl_count = 0;
int		status_count = 0;
int		upddir_count = 0;
int             parameter_count = 0;

char    shadow[MAXPATHLEN]    = PSRV_FSHADOW;
char	pfsdat[MAXPATHLEN]    = PSRV_FSTORAGE;
char	dirshadow[MAXPATHLEN] = DSHADOW;
char	dircont[MAXPATHLEN]   = DCONTENTS;

char    root[MAXPATHLEN]      = "";
char	aftpdir[MAXPATHLEN]   = "";
char	afsdir[MAXPATHLEN]    = "";

char	*logfile_arg = NULL;
extern int p__server;

#ifdef PSRV_ARCHIE
extern int 	arch_prioritize_request();
#endif /* PSRV_ARCHIE */


struct db_entry db_prefixes[] = DATABASE_PREFIXES;
int		db_num_ents = sizeof(db_prefixes)/sizeof(db_prefixes[0]);

char	hostname[MAXPATHLEN]  = "";    /* Server's host name                */
char	hostwport[MAXPATHLEN+30] = ""; /* Host name w/ port if non-standard */

main(argc, argv)
    int     argc;
    char   *argv[];
{
    char		*cur_arg;        /* For argument parsing           */
    int     		on = 1;

    struct sockaddr_in 	from;
    int			port_no;
    struct hostent		*current_host;
    int     		fromlen;
    PTEXT   		pkt;
    RREQ			curr_req;
    register int		n;
    int     		child;
    int			retval;
    char		*envv;  /* Temp pointer to environment variable */

    /* To initialize database ACLs */
    VDIR_ST		dir_st;            /* Directory contents used ... */
    VDIR		dir = &dir_st;     /* by individual lines         */
    int			i;

    time_t 		now;
    struct tm 		*tm;
    static int dirsrv_internal_error_handler();
    extern int fseek();         /* RHS of assignment. */

    umask(0);

    /* These function-valued variables depend upon whether we're the */
    /* server or the client.  The default values are the client      */
    /* values; the server values are these.                          */
    internal_error_handler = dirsrv_internal_error_handler;
    qoprintf = srv_qoprintf;
    stdio_fseek = fseek;
    p__server = 1;              /* We are the Server. */


    strcpy(prog,argv[0]);
    argc--;argv++;

    if(envv = getenv("PSRV_ROOT"))
	strcpy(root,envv);
#ifdef PSRV_ROOT
    else strcpy(root,PSRV_ROOT);
#endif

    if(envv = getenv("PSRV_FSHADOW"))
        strcpy(shadow,envv);

    if(envv = getenv("PSRV_FSTORAGE"))
        strcpy(pfsdat,envv);

    if(envv = getenv("PSRV_AFTPDIR"))
        strcpy(aftpdir,envv);
#ifdef AFTPDIRECTORY
    else strcpy(aftpdir,AFTPDIRECTORY);
#endif

    if(envv = getenv("PSRV_AFSDIR"))
        strcpy(afsdir,envv);
#ifdef AFSDIRECTORY
    else strcpy(afsdir,AFSDIRECTORY);
#endif

    if(envv = getenv("PSRV_HOSTNAME"))
        strncpy(hostname,envv,sizeof(hostname));
#ifdef PSRV_HOSTNAME
    else strncpy(hostname,PSRV_HOSTNAME,sizeof(hostname));
#else
    else strncpy(hostname,myhostname(),sizeof(hostname));
#endif

    if(envv = getenv("PSRV_LOGFILE"))
	set_logfile(envv);

    while (argc > 0 && **argv == '-') {
        cur_arg = argv[0]+1;

        while (*cur_arg) {
            switch (*cur_arg++) {

            case 'a':	/* Set AFS directory */
		if(*cur_arg) {
		    strncpy(afsdir,cur_arg,sizeof(afsdir));
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    strncpy(afsdir,argv[1],sizeof(afsdir));
		    argc--;argv++;
		}
		else strcpy(afsdir,"/afs");
		break;

	    case 'E':	/* Set last error */
		if(*cur_arg) {
		    last_error = cur_arg;
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    last_error = argv[1];
		    argc--;argv++;
		}
		else goto parse_err;
		break;

            case 'f':	/* Set anonymous ftp area */
		if(*cur_arg) {
		    strncpy(aftpdir,cur_arg,sizeof(aftpdir));
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    strncpy(aftpdir,argv[1],sizeof(aftpdir));
		    argc--;argv++;
		}
		else goto parse_err;
		break;

	    case 'F':	/* Set fault count from next argument */
		fault_count = -1;
		if(*cur_arg && index("0123456789",*cur_arg)) {
		    sscanf(cur_arg,"%d",&fault_count);
		    cur_arg += strspn(cur_arg,"0123456789");
		}
		else if(argc > 1) {
		    retval = sscanf(argv[1],"%d",&fault_count);
		    if (retval == 1) {argc--;argv++;}
		}
		else goto parse_err;
		break;

            case 'h':	/* Set hostname */
		if(*cur_arg) {
		    strncpy(hostname,cur_arg,sizeof(hostname));
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    strncpy(hostname,argv[1],sizeof(hostname));
		    argc--;argv++;
		}
		else goto parse_err;
		break;

            case 'L':	/* Set logfile */
		if(*cur_arg) {
		    set_logfile(cur_arg);
		    logfile_arg = cur_arg;
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    set_logfile(argv[1]);
		    logfile_arg = cur_arg;
		    argc--;argv++;
		}
		else goto parse_err;
		break;
		
            case 'm':	/* Run server from terminal */
		mflag++;
                break;

	    /* If form of port identifier is a positive integer, then  */
	    /* integer reperesents the file descriptor of a privileged */
	    /* port already open.  If it is of any other form, it is   */
	    /* a port identifier to be opened later by bind_port.  At  */
	    /* most one of each may be specified.  If neither, then    */
	    /* -p dirsrv is assumed.  Because most clients don't use   */
	    /* the privileged prospero port, for the time being dirsrv */
	    /* is assumed even if a file descriptor is specified as    */
	    /* as no other port is specified. For port names, a name   */
            /* is looked up in the /etc/services files.  If the first  */
            /* char is #, then what follows is the port number itself. */
	    case 'p':	/* Port on which to listen */
		in_port = -1;
		if(*cur_arg) {
		    if(index("0123456789",*cur_arg)) {
			sscanf(cur_arg,"%d",&in_port);
			ardp_set_prvport(in_port);
			cur_arg += strspn(cur_arg,"0123456789");
		    }
		    else {
			portname = cur_arg;
			cur_arg += strlen(cur_arg);
		    }
		}
		else if(argc > 1) {
		    if(index("0123456789",*argv[1])) {
			sscanf(argv[1],"%d",&in_port);
			ardp_set_prvport(in_port);
			cur_arg += strspn(cur_arg,"0123456789");
		    }
		    else {
			portname = argv[1];
		    }
		    argc--;argv++;
		}
		else goto parse_err;
		break;

            case 'r':	/* Set root of tree to make available */
		if(*cur_arg) {
		    strncpy(root,cur_arg,sizeof(root));
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    strncpy(root,argv[1],sizeof(root));
		    argc--;argv++;
		}
		else goto parse_err;
		break;

            case 'S':	/* Set shadow hierarchy */
		if(*cur_arg) {
		    strncpy(shadow,cur_arg,sizeof(shadow));
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    strncpy(shadow,argv[1],sizeof(shadow));
		    argc--;argv++;
		}
		else goto parse_err;
		break;

            case 'T':	/* Set storage hierarchy */
		if(*cur_arg) {
		    strncpy(pfsdat,cur_arg,sizeof(pfsdat));
		    cur_arg += strlen(cur_arg);
		}
		else if (argc > 1) {
		    strncpy(pfsdat,argv[1],sizeof(pfsdat));
		    argc--;argv++;
		}
		else goto parse_err;
		break;

	    parse_err:
            default:
                fprintf(stderr,
                   "Usage: dirsrv [-m] [-p<port>] [-r root] [-h hostname]\n");
                exit(1);
            }
        }
        argc--, argv++;
    }

    if (argc > 0) {
	fprintf(stderr,
		"Usage: dirsrv [-m] [-p<port>] [-r root] [-h hostname]\n");
	exit(1);
    }

    /* Here re really should get the host name in cannonical form */
    ucase(hostname);

    if (!mflag) {
	if(envv = getenv("PSRV_RUNDIR")) 
	    retval = chdir(envv);
	else {
#ifdef P_RUNDIR
	    retval = chdir(P_RUNDIR);
#else
	    retval = chdir("/tmp");
#endif
	}
	if(retval) plog(L_STATUS,NOREQ,"Startup - chdir failed: %d",errno);
    }

    /* Note our start time */
    (void) time(&now);
    tm = gmtime(&now);
    sprintf(st_time_str,"%2d-%s-%02d %02d:%02d:%02d UTC",tm->tm_mday,
             month_sname(tm->tm_mon + 1),tm->tm_year,
             tm->tm_hour, tm->tm_min, tm->tm_sec);


    /* Eventually, we will only set up and bind a port if one    */
    /* wasn't already passed to us using the -p option.  Until   */
    /* all clients can support alternative ports, however, we    */
    /* must bind the DIRSRV port in addition to any that were    */
    /* passed to us.  Note that at this point, unless we are     */
    /* running as root (which we should not be) we would not     */
    /* have been able to bind the priveleged port.               */

    port_no = ardp_bind_port(portname ? portname : "dirsrv");

#ifdef TAG_UNASSIGNED_PORT
    if((in_port < 0) && (port_no != PROSPERO_PORT)) 
        sprintf(hostwport,"%s(%d)",hostname,port_no);
    else
#endif 
    if((port_no != PROSPERO_PORT) && (port_no != DIRSRV_PORT)) 
        sprintf(hostwport,"%s(%d)",hostname,port_no);
    else strcpy(hostwport,hostname);

#ifdef PSRV_ARCHIE
    ardp_set_queuing_policy(arch_prioritize_request,0);
#endif /* PSRV_ARCHIE */

    if (!mflag) {
        if ((child = fork()) != 0) {
            printf("%s started, PID=%d, PORT=%d\n", 
                   prog, child, port_no);
            exit(0);
        }
        setup_disc();
    }
    else {
        plog_manual(stderr);
        printf("%s started, PORT=%d\n", prog, port_no);
    }
    
    plog(L_STATUS,NOREQ,
	 "Startup - %sPID: %d, Root: %s, Shadow: %s, Aftpdir: %s, %s%s%sHost: %s", 
         (mflag ? "Mode: manual " : ""), getpid(), root, shadow,
	 aftpdir, (*afsdir ? "Afsdir: " : ""), afsdir, (*afsdir ? ", " : ""),
         hostwport);

    /* set dirsend timeout for chasing forwarding pointers */
    ardp_set_retry(4,1);

    /* Initialize database ACLs */
    vdir_init(dir);
    for(i=0;i<db_num_ents;i++) {
        retval = dsrdir(db_prefixes[i].db_prefix,0,dir,NULL,0);
        if(!retval) {
	    db_prefixes[i].db_acl = dir->dacl;
	    dir->dacl = NULL;
	}
        vdir_freelinks(dir);
    }

#ifndef THREADS
    /* receive loop */
    for (;;) {
        curr_req = ardp_get_nxt();
#ifdef DIRSRV_EXPLAIN_LAST_RESTART		
        pkt = curr_req->rcvd;
        strcpy(last_request,pkt->text); /* For error logging */
#endif DIRSRV_EXPLAIN_LAST_RESTART
            req_count++;
            dirsrv(curr_req);
    }	
#else /* THREADS */
    /* receive loop */
    for (;;) {
        int		free_count = THREAD_COUNT;

        if(threadcount > 0) {
            curr_req = ardp_get_nxt();
#ifdef DIRSRV_EXPLAIN_LAST_RESTART		
            pkt = curr_req->rcvd;
            strcpy(last_request,pkt->text); /* For error logging */
#endif DIRSRV_EXPLAIN_LAST_RESTART
            req_count++;
            free_count--;
            dirsrv(curr_req);
        }
        else {
            free_count++;
        }
    }	
#endif
}

dirsrv(req)
    RREQ req;
{

/*************************/

    /* The following are set in one line and used by subsequent */
    /* lines of the same message                                */

    int	client_version = MAX_VERSION;   /* Protocol version no.; 
                                           default to max version. */
    /* These store directory information, set on one line and used in
       subsequent lines of the message. */
    char        dir_type[40];     /* Type of dir name (Currently, the
                                             only supported value is ASCII) */
    char	client_dir[MAXPATHLEN] = ""; 	/* Current directory      */
    long	dir_version = -1;       	/* Directory version nbr.
                                                   Currently ignored.  */
    long	dir_magic_no = -1;      	/* Directory magic number */

#ifdef PSRV_ARCHIE
    int	max_list_commands = 5;		/* Max lists in request   */
#endif /* PSRV_ARCHIE */


    /* used to parse commands. */
    char                *tmpline;  /* line returned by in_line()  */
    static char		*command = NULL;     /* The current line.  This is
                                                memory allocated through 
                                                stcopy(). */
    char *next_word;         /* next_word:    a temporary pointer to a position
                                within the command line.  Points to the
                                next place from which we'll want to read
                                data. */ 
    
    int		retval;         /* Return value from subfunctions */
    INPUT_ST in_st;
    INPUT in = &in_st;

    *client_dir = '\0';

    /* in_nextline(): the start of the next command line in the packet, or
       NULL.  
       command: the head of the current command line, without newline, NULL
       terminated. */
    rreqtoin(req, in);

    if (in_eof(in))
        return error_reply(req, "ERROR Received empty Prospero request packet");
    /* This loop always begins with in_nextline() either the head of the
       next command line in the packet, or NULL. */
    while (!in_eof(in)) {
        /* get the next line. */
        if(in_line(in, &tmpline, &next_word)) {
            creplyf(req, "ERROR Malformed input line: %'s\n", p_err_string);
            plog(L_DIR_ERR, req, "Malformed input line: %s", p_err_string);
            return PFAILURE;
        }
        command = stcopyr(tmpline, command);
        next_word = command + (next_word - tmpline);
        /* now, in_nextline(in) either points to the start of the following
           line or is NULL.  command points to the start of a NUL-terminated
           string which contains what's supposed to be a Prospero protocol
           command line.   next_word points to the first word in that string
           after command. */ 

        switch(cmd_lookup(command)) {
        case AUTHENTICATE:
	{
            static char	*auth_type = NULL;    /* Type of Authentication */ 
            /* Authentication data */ 
            static char *t_options = NULL;
            static char	*authent = NULL;
            static char        *t_client_id = NULL;
            int tmp;
            char *cp;           /* Temporary variable for use by qsscanf() */
            PAUTH patmp;

            tmp = qsscanf(next_word,"%'&s %'&s %'&s %r", 
                          &t_options, &auth_type, &authent, &cp);
            /* Additional tokens are just principal names; purely
               informational. */ 
            if(tmp < 3)
                return error_reply(req, "Invalid arguments: %s", command);

            if ((patmp = paalloc()) == NULL)
                return error_reply(req, "Out of Memory (paalloc())!");
            /* This memory will be freed by the rdgram transmit() function. */
            patmp->next = req->auth_info;
            req->auth_info = patmp;

#ifdef PSRV_KERBEROS
            if (strequal(auth_type,"KERBEROS")) {
                if (retval = check_krb_auth(authent, req->peer, 
					    &t_client_id)) {
		    if (!t_options || strequal(t_options, "MANDATORY"))
			return auth_fail_reply(req, 
					       "Invalid Kerberos Authenticator");
		}
		else {
		    patmp->principals = tkalloc(t_client_id);
		    patmp->ainfo_type = PFSA_KERBEROS;
		    req->client_name = stcopyr(t_client_id,
					       req->client_name);
		}
            } else 
#endif
#ifdef PSRV_P_PASSWORD
            if (strequal(auth_type, "P_PASSWORD")) {
		qsscanf(cp, "%'&s", &t_client_id);
		if (!passwd_correct(t_client_id, authent)) {
		    if ((!t_options && get_ppw_entry(t_client_id))
			|| (t_options && strequal(t_options, "MANDATORY")))
			return auth_fail_reply(req, 
					       "Invalid password");
		}
		else {
		    req->client_name = stcopyr(t_client_id, req->client_name);
		    patmp->principals = tkalloc(t_client_id);
		    patmp->ainfo_type = PFSA_P_PASSWORD;
		}
	    } else
#endif		
	    if (strequal(auth_type, "UNAUTHENTICATED")) {
		req->client_name = stcopyr(authent,req->client_name);
                patmp->principals = tkalloc(authent);
                patmp->ainfo_type = PFSA_UNAUTHENTICATED;
            }
            else {
		if (strequal(t_options, "MANDATORY"))
		    return auth_fail_reply(req, 
					   "Authentication type %s not supported",
				      auth_type,0);
            }
        }
            break;

#ifndef PSRV_READ_ONLY
    case CREATE_LINK: 
            crlnk_count++;
            if(create_link(req, &command, &next_word, in, client_dir,
                           dir_magic_no)) 
                return PFAILURE;
            break;

    case CREATE_OBJECT:
            crobj_count++;
            if(create_object(req, &command, &next_word, in, client_dir,
                             dir_magic_no))
                return PFAILURE;
            break;
            
        case DELETE_LINK: 
            dellnk_count++;
            if(delete_link(req, command, next_word, in,
                           client_dir, dir_magic_no))
                return PFAILURE;
            break;
#endif

    case DIRECTORY:
        {
            int tmp;
            char *cp;

            dir_version = 0;
            dir_magic_no = 0;
            tmp = qsscanf(next_word,"%!!'s %!!'s %d %r",
                          dir_type, sizeof dir_type, 
                           client_dir, sizeof client_dir,
                          &dir_version, &cp);
            if (tmp < 0)
                interr_buffer_full();
            if(tmp < 2 || tmp > 3)
                return error_reply(req, "Invalid arguments: %'s", command);
            if(!strequal(dir_type,"ASCII"))
                return error_reply(req, "Directory handle type %'s not supported",
                                   dir_type); 
            if(in_select(in, &dir_magic_no)) {
                return error_reply(req, "DIRECTORY: %'s", p_err_string);
            }
                
            if(check_handle(client_dir) == FALSE) {
               creply(req,"FAILURE NOT-AUTHORIZED\n");
               plog(L_AUTH_ERR,req,"Invalid directory name: %'s",client_dir);
               return PFAILURE;
            }
        }
            break;

#ifndef PSRV_READ_ONLY
    case EDIT_ACL: 
            eacl_count++;

            if(edit_acl(req, &command, &next_word, in, client_dir,
                           dir_magic_no)) 
                return PFAILURE;
            break;
        
    case EDIT_LINK_INFO: 
            eli_count++;
            if(edit_link_info(req, &command, &next_word, in, 
                              client_dir, dir_magic_no))
                return PFAILURE;
            break;

    case EDIT_OBJECT_INFO:
            eoi_count++;
            if(srv_edit_object_info(req, command, next_word, in))
                return PFAILURE;
            break;
        
#endif      /* PSRV_READ_ONLY */

        case GET_OBJECT_INFO:	
            goi_count++;
            if(get_object_info(req, command, next_word, in))
                return PFAILURE;
            break;

    case LIST: 
	list_count++;
#ifdef PSRV_ARCHIE
	if(max_list_commands-- <= 0) {
                creply(req,"FAILURE NOT-AUTHORIZED Too many list commands in a single request\n");
                plog(L_AUTH_ERR,req,"Too many list commands");
                return PFAILURE;
            }
#endif /* PSRV_ARCHIE */

	if(list(req, &command, &next_word, in, client_dir,
                    dir_magic_no))
                return PFAILURE;
            break;

        case LIST_ACL: 
            lacl_count++;
            if(retval = 
               list_acl(req, command, next_word, in,
                        client_dir, dir_magic_no)) 
                return retval;
            break;
        
        case PARAMETER:
            parameter_count++;
            if(retval = parameter(req, command, next_word)) return retval;
            break;
        
        case STATUS:
        {
            char 	*cp;           /* temporary */
	    int		i;

            status_count++;
            
            if (qsscanf(next_word, "%*s%r", cp) > 0)
                return error_reply(req, "STATUS command takes no arguments, \
but we received: %s", command);
            replyf(req,"Prospero server (%s) %s\n",PFS_RELEASE,hostwport);
            if(fault_count) 
                replyf(req,"Faults since startup %d\n",fault_count);
#ifdef SERVER_SUPPORT_V1
            replyf(req,"Requests since startup %d (%d V1) (%d+%d+%d %d+%d+%d \
%d %d+%d+%d %d %d %d)\n",
                   req_count, v1_req_count, list_count, goi_count, lacl_count, 
                   crlnk_count, crdir_count, crobj_count, dellnk_count, 
                   eli_count, eoi_count, eacl_count, upddir_count, 
                    parameter_count, status_count);
#else
            replyf(req,"Requests since startup %d (%d+%d+%d %d+%d %d \
%d+%d+%d %d %d %d)\n",
                   req_count, list_count, goi_count, lacl_count, 
                   crlnk_count, crobj_count, dellnk_count, 
                   eli_count, eoi_count, eacl_count, upddir_count, 
                    parameter_count, status_count);
#endif

            replyf(req,"Started: %s\n",st_time_str);
#ifdef PROSPERO_CONTACT
            replyf(req,"Contact: %s\n",PROSPERO_CONTACT);
#endif PROSPERO_CONTACT
            replyf(req," Memory: %d(%d)vl %d(%d)attrib %d(%d)acl %d(%d)fi \
%d(%d)rr %d(%d)pt\n",
                   vlink_count,vlink_max,pattrib_count,pattrib_max,
                   acl_count,acl_max,pfile_count,pfile_max,rreq_count,
                   rreq_max,ptext_count,ptext_max);
            replyf(req, 
                    " Memory: %d(%d)str %d(%d)tk %d(%d)pauth %d(%d)fil\n",
/* opt not implemented yet " Memory: %d(%d)str %d(%d)tk %d(%d)pa %d(%d)opt \
%d(%d)fil\n", */
                    string_count,string_max, token_count, token_max, 
                    pauth_count, pauth_max, /* opt_count, opt_max, */
                    filter_count, filter_max);
#ifdef PSRV_GOPHER_GW
            replyf(req, "Memory: %d(%d)glink\n", glink_count, glink_max);
#endif
#ifndef PSRV_READ_ONLY
            if(*pfsdat) replyf(req,"   Data: %s\n", pfsdat);
#endif PSRV_READ_ONLY
            if(*root) replyf(req,"   Root: %s\n", root);
            if(*aftpdir) replyf(req,"   AFTP: %s\n", aftpdir);
            if(*afsdir) replyf(req,"    AFS: %s\n", afsdir);
            if(db_num_ents > 0) {
		replyf(req,"     DB:");
		for(i=0;i<db_num_ents;i++) 
		    replyf(req," %s",db_prefixes[i].db_prefix);
		replyf(req,"\n");
	    }
            if(last_error) replyf(req,"  Error: %s\n",last_error);

            plog(L_DIR_PINFO, req, "STATUS Request");
            break;
        }

#ifndef PSRV_READ_ONLY
        case UPDATE: 
            upddir_count++;
            if(update(req, command, next_word, in,
                      client_dir, dir_magic_no))
                return PFAILURE;
            break;
#endif

        case VERSION:
            if((client_version = 
                version(req, command, next_word)) < 0) 
                return PFAILURE;
#ifdef SERVER_SUPPORT_V1
            if (client_version == 1) {
                ++v1_req_count;
                /* We must pass a character pointer for the start of the place
                   in the packet to grab the next token from; this is just the
                   old next_line pointer. */
                return dirsrv_v1(req,index(req->rcvd->text, '\n'));
            }
#endif
            /* Otherwise, we can continue to process this packet. */
            break;


        case UNIMPLEMENTED:
            plog(L_DIR_PERR,req,"Unimplemented message: %s", command);
            creplyf(req,"FAILURE UNIMPLEMENTED %'s\n", command);
            return PFAILURE;
            break;

        case UNKNOWN:
            return error_reply(req, "Unknown message: %s", command, 0);
            break;

        default: 
            plog(L_FAILURE,req,
                 "Somehow, we got to the default case in the giant switch \
in dirsrv (file %s, line %d).  This should never happen.", 
                 __FILE__, __LINE__); 
            return error_reply(req, "Unknown message: %s", command, 0);
            break;
        }                   /* End of switch(cmd_lookup(command)) */
    }               /* command processing loop end: while(in_nextline(in)) */
    creply(req,NULL);   /* Send it out! */  
    return(PSUCCESS);
}

/*
 * cmd_lookup - lookup the command name and return integer
 *
 *    CMD_LOOKUP takes a pointer to a string containing a command.
 *    It then looks up the first word found in the string and
 *    returns an int that can be used in a switch to dispatch
 *    to the correct routines.
 *
 *    This has been optimzed for the server side of the Prospero protocol.
 */

static 
cmd_lookup(cmd)
char	*cmd;
{

#ifdef PSRV_READ_ONLY
/* This command modifies the server data files. */
#define     modcmd(dispatch_code)   UNIMPLEMENTED
#else
#define     modcmd(dispatch_code)   (dispatch_code)
#endif

    switch(*cmd) {
    case 'A':
        if(strnequal(cmd,"AUTHENTICATE", 12))
            return AUTHENTICATOR;
        else if (strnequal(cmd, "ATOMIC", 6))
            return UNIMPLEMENTED;
        else
            return UNKNOWN;
    case 'C':
        if(strnequal(cmd,"CREATE-OBJECT",11))
            return modcmd(CREATE_OBJECT);
        else if(strnequal(cmd,"CREATE-LINK",11))
            return modcmd(CREATE_LINK);
        else return UNKNOWN;
    case 'D':
        if(strnequal(cmd,"DELETE-LINK",11))
            return modcmd(DELETE_LINK);
        else if(strnequal(cmd,"DIRECTORY",9))
            return DIRECTORY;
        else return UNKNOWN;
    case 'E':
        if (strnequal(cmd, "EDIT-LINK-INFO", 14))
            return modcmd(EDIT_LINK_INFO);
        else if(strnequal(cmd,"EDIT-OBJECT-INFO",16))
            return modcmd(EDIT_OBJECT_INFO);
        else if (strnequal(cmd, "EDIT-ACL", 8))
            return modcmd(EDIT_ACL);
        else 
            return UNKNOWN;
    case 'G':
        if(strnequal(cmd,"GET-OBJECT-INFO",13))
            return GET_OBJECT_INFO;
        else return UNKNOWN;
    case 'L':
        if(strnequal(cmd,"LIST-ACL",8))
            return LIST_ACL;
        else if(strnequal(cmd,"LIST",4))
            return LIST;
        else return UNKNOWN;
    case 'P':
        if(strnequal(cmd, "PARAMETER", 9))
            return PARAMETER;
        else return UNKNOWN;
    case 'S':
        if(strnequal(cmd,"STATUS",6))
            return STATUS;
        else return UNKNOWN;
    case 'U':
        if(strnequal(cmd,"UPDATE",6))
            return modcmd(UPDATE);
        else return UNKNOWN;
    case 'V':
        if(strnequal(cmd,"VERSION",7))
            return VERSION;
        else return UNKNOWN;
    default:
        return UNKNOWN;
    }
}


SIGNAL_RET_TYPE term_sig()
{
    char		qlstring[30];

    if(pQlen > 0) sprintf(qlstring," [%d pending]",pQlen);
    else *qlstring = '\0';

    plog(L_STATUS, NOREQ,
	 "Server killed (terminate signal received)%s",qlstring);
    log_server_stats();
    exit(0);
}

SIGNAL_RET_TYPE restart_sig()
{
    char		qlstring[30];

    if(pQlen > 0) sprintf(qlstring," [%d pending]",pQlen);
    else *qlstring = '\0';

    plog(L_STATUS, NOREQ,
	 "Attempting server restart (restart signal received)%s",qlstring);
    restart_server(fault_count,(char *) NULL);
}

SIGNAL_RET_TYPE trap_error(sig, code, scp)
    int			sig;
    int			code;
    struct  sigcontext	*scp;
{
    char		estring[400];

    if(pQlen > 0) qsprintf(estring, sizeof estring, " [%d pending]",pQlen);
    else *estring = '\0';

#ifdef SIGCONTEXT_LACKS_SC_PC
    plog(L_FAILURE,NOREQ,"Failure - Recovering from error (%d,%d)%s",sig,code,estring);
#else
    plog(L_FAILURE,NOREQ,"Failure - Recovering from error at address 0x%x (%d,%d)%s",scp->sc_pc,sig,code,estring);
#endif
#ifdef DIRSRV_EXPLAIN_LAST_RESTART
    plog(L_DIR_ERR,NOREQ,"Last request was: %s",last_request);
#ifdef SIGCONTEXT_LACKS_SC_PC
    qsprintf(estring,sizeof estring, "Signal(%d,%d)\n%s", sig, code,
	    last_request);
#else
    qsprintf(estring,sizeof estring, "Signal(%d,%d) at 0x%x\n%s", sig, code,
	    scp->sc_pc, last_request);
#endif
#else
#ifdef SIGCONTEXT_LACKS_SC_PC
    qsprintf(estring,sizeof estring, "Signal(%d,%d) at 0x%x", sig, code);
#else
    qsprintf(estring,sizeof estring, "Signal(%d,%d) at 0x%x", sig, code,
             scp->sc_pc);
#endif
#endif DIRSRV_EXPLAIN_LAST_RESTART

    restart_server(++fault_count,estring);
    abort();
}

/*
 * setup_disc 
 *
 *      disconnect all descriptors, remove ourself from the process
 *      group that spawned us and set signal handlers.
 */
setup_disc()
{

    int     s;

    for (s = 0; s < 3; s++) {
        (void) close(s);
    }

    (void) open("/dev/null", 0, 0);
    (void) dup2(0, 1);
    (void) dup2(0, 2);

#ifdef SETSID
    setsid();
#else
    s = open("/dev/tty", 2, 0);

    if (s >= 0) {
        ioctl(s, TIOCNOTTY, (struct sgttyb *) 0);
        (void) close(s);
    }
#endif

    signal(SIGHUP,term_sig);
    signal(SIGINT,term_sig);
    signal(SIGTERM,term_sig);
    signal(SIGQUIT,term_sig);

    signal(SIGILL,trap_error);
    signal(SIGIOT,trap_error);
    signal(SIGEMT,trap_error);
    signal(SIGFPE,trap_error);
    signal(SIGBUS,trap_error);
    signal(SIGSEGV,trap_error);
    signal(SIGSYS,trap_error);

    signal(SIGUSR1,restart_sig);
    return;
}


log_server_stats()
{
    plog(L_STATS,NOREQ,"Stats: %d List, %d GOI, %d LACL",
	 list_count,goi_count,lacl_count);
#ifdef SERVER_SUPPORT_V1
    plog(L_STATS,NOREQ,"       %d CL, %d CD, %d CO, %d DL",
	 crlnk_count,crdir_count,crobj_count,dellnk_count);
#else
    plog(L_STATS,NOREQ,"       %d CL, %d CO, %d DL",
	 crlnk_count,crobj_count,dellnk_count);
#endif
     plog(L_STATS,NOREQ,"       %d ELI, %d EOI, %d EACL, %d Upd", 
	 eli_count,eoi_count,eacl_count,upddir_count,0);
    if(v1_req_count) plog(L_STATS,NOREQ,"       %d Total, %d V1 format", 
			   req_count, v1_req_count);
    else plog(L_STATS,NOREQ,"       %d Total", req_count);

}

/* Check a handle (the filename portion of a system level name) and make sure
   that we are allowed to access it.  This uses the definitions from
   "psite.h". */

check_handle(handle)
    char	*handle;
{
    int		i;
#ifdef NODOTDOT
    static char 	*t_handle = NULL;
    int n;
#endif
    
    if(*handle != '/') {  /* Database or special prefix in use */
	for(i=0;i<db_num_ents;i++) {
	    if(strncmp(handle,db_prefixes[i].db_prefix,
		       strlen(db_prefixes[i].db_prefix)) == 0) 
		return(TRUE);
	}
    }

#ifdef NODOTDOT
 again:
    n = qsprintf(t_handle, stsize(t_handle), "/%s/", handle);
    if (n > stsize(t_handle)) {
        stfree(t_handle);
        if((t_handle = stalloc(n)) == NULL) out_of_memory();
    }
    if(sindex(t_handle, "/../")) return FALSE;
#endif
    if(strnequal(handle,pfsdat, strlen(pfsdat))) return TRUE;
    if(*root && strnequal(handle,root, strlen(root))) return TRUE;
    if(*aftpdir && strnequal(handle,aftpdir, strlen(aftpdir))) return TRUE;
    if(*aftpdir && strnequal(handle, "AFTP", 4)) return TRUE;
    if(*afsdir && strnequal(handle, afsdir, strlen(afsdir))) return TRUE;
    return FALSE;
}

/* 
 * dirsrv has an internal error handler.   This
 * is used by the internal_error macro. 
 */
static int
dirsrv_internal_error_handler(file, line, mesg)
    char file[];
    int line;
    char mesg[];
{
    /* if we get into a loop (if qsscanf or plog or restart_server have
       internal errors), we'll bail out eventually.  */ 
    static int been_here_before = 0; 
    char estring[400];

    if (been_here_before++ < 5) {
        plog(L_FAILURE, NOREQ,
             "Internal error in file %s, line %d: %s", file, line, mesg);
        if (mflag) 
            plog(L_FAILURE, NOREQ, "In manual mode; not restarting server.");
        else
            plog(L_FAILURE, NOREQ, "Trying to restart server.");
        qsprintf(estring, sizeof(estring), 
                 "Internal error in file %s, line %d: %s", file, line, mesg, 0);
    }
    if (been_here_before < 10) {
        if(!mflag) restart_server(++fault_count, estring);
        else abort();
    }
    write(2, "In dirsrv.c, dirsrv_internal_error_handler(): \
This should never happen.\n", 
          sizeof "In dirsrv.c, dirsrv_internal_error_handler(): \
This should never happen.\n");
    if (mflag) abort();                    /* and if THAT fails... */
    _exit(1);                   /* final desperation play. */
    write(2, "In dirsrv.c, dirsrv_internal_error_handler(): \
_exit(1) didn't abort execution!  This should REALLY never happen.\n", 
          sizeof "In dirsrv.c, dirsrv_internal_error_handler(): \
_exit(1) didn't abort execution!  This should REALLY never happen.\n");
}


/* This function will execute both a vplog() and an vsendmqf() in order to
   report on a failure.
   It returns PFAILURE, since it should only be used if an operation
   cannot be performed.
   It also automatically prefixes the words 
   "FAILURE AUTHENTICATION-DATA" to the reply packets.
   It appends the appropriate newlines, so you don't have to.
*/

static int auth_fail_reply(RREQ req, char *format, ...)
{
    va_list ap;
    char *bufp;
    
    va_start(ap, format);
    
    
    bufp = vplog(L_AUTH_ERR, req, format, ap); /* return formatted string */

    reply(req, "FAILURE AUTHENTICATION-DATA ");
    reply(req, bufp);
    creply(req, "\n");
    va_end(ap);
    return PFAILURE;
}
