/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <strings.h>

#include <ardp.h>
#include <pfs.h>
#include <pparse.h>
#include <plog.h>
#include <psrv.h>
#include <perrno.h>
#include <pmachine.h>

#include "dirsrv.h"

static void
srv_vl_delete(VDIR dir, VLINK link);

delete_link(RREQ req, char *command, char *next_word, INPUT in,
            char client_dir[], int dir_magic_no)
{
    char 	t_name[ARDP_PTXT_LEN_R];
    char 	t_options[ARDP_PTXT_LEN_R];
    long        t_magic_no = 0;  /* 0 means none specified.     */
    int         retval;
    ACL		wacl;		 /* Working access control list */
    int         tmp;             /* return value from qsscanf() */
    char        *cp;             /* dummy pointer               */
    VLINK       link = NULL;  /* target link         */
    VDIR_ST	dir_st;          /* Directory contents used ... */
    VDIR	dir = &dir_st;   /* by individual lines         */

    vdir_init(dir);

    tmp = qsscanf(next_word,"%'s %'s %r", t_options, t_name, &cp);

    /* Log and return a better message */
    if (tmp < 0)
        return error_reply(req, "Format error: %'s", command, 0);
    if(tmp < 2)
        return error_reply(req, "Too few arguments: %'s", command, 0);
    if (tmp > 2)
        return error_reply(req, "Too many arguments: %'s", command, 0);

    if(retval = in_select(in, &t_magic_no))
        return error_reply(req, "DELETE-LINK: %'s", p_err_string);

    if (!strequal(t_options, ""))
        return error_reply(req, "DELETE-LINK: options must be empty: %'s",
                           command);
    /* Do we need a better log message */
    plog(L_DIR_UPDATE,req,"RM %s %s ID REMOTE %ld",
         client_dir,t_name,t_magic_no,0);

    retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
    if(retval == DSRFINFO_FORWARDED) 
        return dforwarded(req, client_dir, dir_magic_no, dir);

    /* If not a directory, say so */
    if(retval == DSRDIR_NOT_A_DIRECTORY) {
        creply(req,"FAILURE NOT-A-DIRECTORY\n");
        plog(L_DIR_ERR, req,"Invalid directory name: %s", client_dir,0);
        return PFAILURE;
    }

    /* Need to find the link so we can check its ACL */
    for( link = dir->links; link; link = link->next) {
        if(strequal(link->name,t_name) && link->linktype != '-')
            if ((t_magic_no == 0) || (t_magic_no == link->f_magic_no))
                break;
    }
    if (!link) {
        for( link = dir->ulinks; link; link = link->next) {
            if(strequal(link->name,t_name))
                if ((t_magic_no == 0) || (t_magic_no == link->f_magic_no))
                    break;
        }
    }
    if (!link) {
        creplyf(req, "FAILURE NOT-FOUND LINK %'s\n", t_name);
        plog(L_DIR_ERR,req,"Link not found: %s %s", client_dir, t_name);
        vdir_freelinks(dir);
        return PFAILURE;
    }
    wacl = link->acl;
    /* If not authorized, say so */
    if(!srv_check_acl(wacl, dir->dacl, req,"d",SCA_LINK,NULL,NULL)) {
        creply(req,"FAILURE NOT-AUTHORIZED\n");
        plog(L_AUTH_ERR,req,"Unauthorized DELETE-LINK: %s %s",client_dir,
             t_name); 
        vdir_freelinks(dir);
        return PFAILURE;
    }
    if (link->flags & VLINK_NATIVE) {
        creplyf(req, "FAILURE SERVER-FAILED Deleting NATIVE links is not \
implemented.  You can try setting the link invisible instead: \
set_atr <linkname> LINK-TYPE -linkprec -replace -field I");
        plog(L_FAILURE, req, "Tried to DELETE-LINK on NATIVE link: %s %s",
             client_dir, t_name);
        vdir_freelinks(dir);
        return PFAILURE;
    }
    srv_vl_delete(dir, link);
        
    retval = dswdir(client_dir,dir);
    vdir_freelinks(dir);
    if(!retval) {
        reply(req,"SUCCESS\n");
    } else {
        creplyf(req, "FAILURE SERVER-FAILED Unable to write out modified directory %'s\n", client_dir);
    }
    return retval;
}

static void
srv_vl_delete(VDIR dir, VLINK link)
{
    if (link->linktype == 'U') {
        EXTRACT_ITEM(link, dir->ulinks);
        vlfree(link);
#if 0
    } else if (link->flags & VLINK_NATIVE) {
        link->linktype = '-';
        if (dir->inc_native == VDIN_ONLYREAL) dir->inc_native = VDIN_INCLREAL;
#endif
    } else {
        EXTRACT_ITEM(link, dir->links);
        vlfree(link);
    }
}
