/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file <usc-copyr.h>
 */

#include <usc-copyr.h>

/* Written, 9/18/92, swa@isi.edu */
/* Made use 'previous'  member 6/14/93, swa@isi.edu */

/* Break up a string into space-separated tokens and recognize Prospero
   quoting.   This strips off the quoting in the process.  This function could
   also be called p__tokenize_newstyle_mcomp(), and it serves that function.
   It assumes the input string is correctly quoted.
 */

#include <pfs.h>
#include <pprot.h>

TOKEN
qtokenize(const char *s)
{
    TOKEN retval;
    int tmp;
    /* We need a new interface to tkalloc() so we can avoid doing two stcopy()
       operations on the same data. */
    static char *buf = NULL;

    if (!s) return NULL;
    retval = NULL;
    for (;;) {
        tmp = qsscanf(s, "%'&s %r", &buf, &s);
        assert(tmp >= 0);            /* no possible error, I hope! */
        if (tmp == 0)
            return retval;
        retval = tkappend(buf, retval);
        if (tmp == 1) return retval; /* no more to tokenize. */
    }
}
