/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <stdio.h>
#include <strings.h>
#include <sys/param.h>
#include <sys/file.h>
#include <errno.h>

#include <pfs.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

extern int	errno;

pfs_open(vl,flags)
    VLINK	vl;
    int		flags;
{
    char		npath[MAXPATHLEN];
    int		tmp;
    int		mapflags;
    int		open_return;

    /* Test flags for validity. */
    if (flags & (O_EXCL | O_SYNC)) {
        qsprintf(p_err_string, P_ERR_STRING_SZ, 
                 "Bad flags specified to pfs_open().");
        return -1;
    }
    if((flags & (O_ACCMODE)) == O_RDONLY) mapflags = MAP_READONLY;
    else mapflags = MAP_READWRITE;

    tmp = mapname(vl, npath, sizeof npath, mapflags);

    if(tmp && (tmp != PMC_DELETE_ON_CLOSE)) {
        errno = ENOENT;
        return(-1);
    }

    DISABLE_PFS(open_return = open(npath, flags));
    if(tmp == PMC_DELETE_ON_CLOSE) unlink(npath);

    return(open_return);
}

