/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/param.h>
#include <syscall.h>
#include <errno.h>

#include <pfs.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

extern int	errno;

FILE *pfs_fopen(VLINK vl, const char *type)
{
    char		npath[MAXPATHLEN];
    int		tmp;
    int		mapflags;
    FILE		*fopen_return;

    if(strcmp(type,"r") == 0)  mapflags = MAP_READONLY;
    else mapflags = MAP_READWRITE;

    tmp = mapname(vl, npath, sizeof npath, mapflags);

    if(tmp && (tmp != PMC_DELETE_ON_CLOSE)) {
        errno = ENOENT;
        return(NULL);
    }

    DISABLE_PFS(fopen_return = fopen(npath,type));
    if(tmp == PMC_DELETE_ON_CLOSE) unlink(npath);

    return(fopen_return);
}

