/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 *
 * Written  by bcn 1989     modified 1989-1992
 * Modified by bcn 1/19/93  to leave eliminate server specific definitions
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

/*
 * psite.h - site selected parameters for Prospero
 *
 * This file contains local definitions for the Prospero utilities.
 * It is expected that it will be different on different systems.
 */

/*
 * Section 1: Installation specifc definitions for the Prospero Applications
 *
 * The definitions in the following section provide information about
 * the proper configuration of Prospero clients on your system. 
 * They may change from system to system.
 */

/*
 * If P_BINARIES is defined and not empty, it defines the directory
 * in which the Prospero clients will look for executables.  If set in 
 * the users environment, P_BINARIES will override the definition
 * here.  If neither are defined, or if the definition is the empty
 * string, then the clients will use the user's search path to find
 * the binaries.
 *
 * The only executable program that the prospero clients and compatability 
 * library call currently is VCACHE.  
 */
#define P_BINARIES            "/usr/pfs/bin"

/*
 * If P_PATH, if defined, is a directory that will be added to the
 * users search path by the Prospero initialization script
 * (vfsetup.source for CSH users, vfsetup.profil for SH users).  
 * It only needs to be defined if the Prospero binaries will not already be 
 * in the user's search path.  Multiple directories separated by spaces may 
 * be specified.
 */
#define P_PATH                P_BINARIES

/*
 * Distribution options.  By default, these options are not supported.
 *
 * Filters are not supported in the default distribution because they 
 * currently only work on the VAX.  We are working on resolving these 
 * problems. 
 * 
 * If you want to use the compatability library, remove the definition of
 * P_NO_PCOMPAT and follow the additional directions in the INSTALLATION file.
 *
 */
#define P_NO_FILTERS
#define P_NO_PCOMPAT

/*
 * This option exists for sites that have special applications.  If this option
 * is defined, the pcompat library's open() routines will prompt for an FTP
 * username and password to retrieve files, if necessary.  This may increase
 * the amount of information available through applications linked with the
 * compatability library, but at the cost of changing the user interface
 * to applications such as 'cat' which never normally prompt for a password.
 * Only #define this if you have a special application.
 * 
 * #define PCOMPAT_SUPPORT_FTP
 */


/*
 * P_AFS is the name of the directory under which AFS files are found.
 * If should be set only if your system supports the Andrew File System.  
 *
 * #define P_AFS "/afs"  
 */

/*
 * If NFS is supported P_NFS can defined.  If set, the clients will attempt 
 * to use NFS to retrieve files from remote systems.  
 *
 * *WARNING* *WARNING*
 * If you will be using this option, you need to modify the 
 * function pmap_nfs() in the file lib/psrv/pmap_nfs.c to do proper NFS 
 * retrievals from the server.  You also will need to modify the function
 * check_nfs() in the file lib/psrv/check_nfs.c to make sure that your 
 * server publishes NFS data only for exportable filesystems, and that it 
 * publishes the data with the correct NFS filesystem names.  The version of
 * lib/psrv/check_nfs.c we provide is only a stub, and does not perform 
 * this function appropriately for most environments.
 * *WARNING*  *WARNING* 
 * 
 * Until you customize lib/psrv/check_nfs.c and lib/psrv/pmap_nfs.c, do NOT
 * #define P_NFS.   If your clients run an NFS automounter, 
 * you can accomplish the same result by defining SHARED_PREFIXES in the
 * pserver.h file.
 * 
 * #define P_NFS
 */

/*
 * P_KERBEROS, if defined, means that the clients will transmit Kerberos
 * (version 5) authentication information and that the server will understand
 * such information.  This should be #defined if your site uses Kerberos
 * authentication; otherwise, you won't have a use for it.  If you #define
 * this, then you also need to use the Kerberos versions of the Makefiles
 * Note that most Kerberos sites out there are still using the older version 4,
 * which is not compatible with version 5.
 *
 * #define P_KERBEROS
 */


/*
 * P_P_PASSWORD, if defined, means that the clients will transmit password
 * authentication information.
 *
 * #define P_P_PASSWORD
 */
#define P_P_PASSWORD

/*
 * Section 2: Site Definitions for the Prospero Applications
 *
 * The definitions in the following section define the Prospero site.
 * They will not necessarily change from system to system.  These definitions
 * should only be changed if you are setting up your own prospero site.   
 * Setting up a site is different than installing the software on a new
 * system.  Unless your site supports storage of new virtual systems, 
 * do not change these definitions. 
 */

/*
 * P_SITE_HOST and DIRECTORY define the system level name of the
 * virtual directory under which site data and meta-data are stored. 
 * It will vary from site to site.
 */
#define P_SITE_HOST           "PROSPERO.ISI.EDU"
#define P_SITE_DIRECTORY      "/pfs/pfsdat/guest"

/*
 * P_SITE_MASTER_VSLIST is the name of the virtual directory (relative
 * to P_SITE) under which reference to local virtual systems can be
 * found.  When setting up a new site, choose a one component name
 * that seems appropriate.
 */
#define P_SITE_MASTER_VSLIST  "vs_root_isi-guest"

/*
 * P_MASTER_VS is the name (relative to MASTER_VSLIST) of the virtual
 * system to be used when creating new virtual systems with newvs.
 * There should be no need to change these definitions.
 */
#define P_MASTER_VS           "master"
#define P_PROTOTYPE_VS        "prototype"

/* 
 * P_SITE_STORAGE is the name (relative to master) of a directory
 * with references to the storage areas of the individual systems that 
 * compose a site. There should be no need to change this
 * definitions.
 */
#define P_SITE_STORAGE        "pfs_storage"

/*
 * P_VS_STORAGE is the name (relative to the directories named in
 * P_SITE_STORAGE) of the directory under which new virtual systems
 * may be stored.  There should be no need to change this definition.
 */
#define P_VS_STORAGE          "local_vsystems"

/*
 * P_GLOBAL_VS_ROOT* is a reference to the global root for the
 * underlying ugly-names of virtual systems.  These definitions must not
 * be changed.
 */
#define P_GLOBAL_VS_ROOT_HOST "PROSPERO.ISI.EDU"
#define P_GLOBAL_VS_ROOT_FILE "/pfs/pfsdat/vs_root_g"
