/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 *
 * Written  by swa 1992   To manipulate lists in prospero and ardp 
 * Modified by bcn 1/93   Added EXTRACT ITEM and fixed several bugs
 */

#include <usc-copyr.h>

#ifndef LIST_MACROS_H
#define LIST_MACROS_H


/* 
 * This macro appends an item to a doubly linked list.  The item goes
 * at the TAIL of the list. This macro modifies its second argument.
 * if head is non-null, head->previous will always be the TAIL of
 * the list. 
 */
#define APPEND_ITEM(new, head) do {         \
    if((head)) {                            \
        (new)->previous = (head)->previous; \
        (head)->previous = (new);           \
        (new)->next = NULL;                 \
        (new)->previous->next = (new);      \
    } else /* !(head) */ {                  \
        (head) = (new);                     \
        (new)->previous = (new);            \
        (new)->next = NULL;                 \
    }                                       \
} while(0) 

/* 
 * This macro removes an item from a doubly-linked list headed by HEAD.
 * If ITEM is not a member of the list, the results are not defined. 
 * The extracted item will NOT be freed.
 */

#define EXTRACT_ITEM(item, head) do {                   \
    if ((head) == (item)) {                             \
        (head) = (item)->next;                          \
        if (head) (head)->previous = (item)->previous;  \
        (item)->previous = NULL; (item)->next = NULL;   \
    } else {                                            \
        (item)->previous->next = (item)->next;          \
        if ((item)->next) (item)->next->previous = (item)->previous; \
	else (head)->previous = (item)->previous;       \
        (item)->previous = NULL; (item)->next = NULL;   \
    }                                                   \
} while(0)

#endif /* LIST_MACROS_H */
