#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

#include <sys/types.h>
#ifdef SYSV
# include <sys/fcntl.h>
#else /* !SYSV */
# include <sys/file.h>
#endif /* SYSV */
#include <signal.h>
#include <setjmp.h>
#ifdef FCNTL_FLOCK
#include "flock.h"
#endif

#define READ  0
#define WRITE	1

static int Lock = 0;
static int Type;
jmp_buf	WhereIWas;
SIG_TYPE (*OldAlarm) __P((int));
extern int ReadOnly;		/* mqi.c */
extern int LockTimeout;		/* qi.c */

/*
 * the following macros do all the junk required to make the lock
 * routines timeout.
 */
#define TIMEOUT_ENABLE()		\
    if (!setjmp(WhereIWas))		\
    {			      \
      OldAlarm = signal(SIGALRM,TimeOut);     \
      alarm(LockTimeout);	     \
    }			      \
    else		      \
    {			      \
      signal(SIGALRM,OldAlarm);		  \
      DoReply(LR_LOCK,"Lock timed out.");     \
      return(0);      /* timeout popped */  \
    }

#define TIMEOUT_DISABLE()		  \
    alarm(0);			  \
    signal(SIGALRM,TimeOut);

/*
 * initialize the lock mechanism
 */
void 
LockInit()
{
	if (!Lock)
	{
		char	lockfile[256];

		(void) sprintf(lockfile, "%s.lck", Database);
		Lock = open(lockfile, O_RDWR | O_CREAT);
		(void) chmod(lockfile, 0660);
		if (Lock < 0)
		{
			perror(lockfile);
			IssueMessage(LOG_INFO, "Couldn't open lockfile.");
			exit(1);
		}
	}
}

/*
 * Set an exclusive lock
 */
int 
GonnaWrite()
{
	LockInit();
	if (ReadOnly)
	{
		DoReply(LR_READONLY, "Database is currently read-only.");
		return (0);
	}
	TIMEOUT_ENABLE();
	if (flock(Lock, LOCK_EX) < 0)
	{
		DoReply(LR_LOCK, "Locking error: %s", strerror(errno));
		return (0);
	}
	TIMEOUT_DISABLE();
	Type = WRITE;
	bintree_init(Database); /* initialize the bintree code */
	read_index(Database);
	if (!dbi_init(Database) || !dbd_init(Database))
	{
		fprintf(Output, "%d:Couldn't open database.", LR_INTERNAL);
		exit(1);
	}
	get_dir_head();
	return (1);
}

/*
 * Set a shared lock
 */
int 
GonnaRead()
{
#ifndef NO_READ_LOCK
	LockInit();
	TIMEOUT_ENABLE();
	if (flock(Lock, LOCK_SH) < 0)
	{
		DoReply(LR_LOCK, "Locking error: %s", strerror(errno));
		return (0);
	}
	TIMEOUT_DISABLE();
#endif
	Type = READ;
	bintree_init(Database); /* initialize the bintree code */
	read_index(Database);
	if (!dbi_init(Database) || !dbd_init(Database))
	{
		fprintf(Output, "%d:Couldn't open database.", LR_INTERNAL);
		exit(1);
	}
	get_dir_head();
	return (1);
}

/*
 * Release a lock
 */
void 
Unlock()
{
	LockInit();
	if (Type == WRITE)
	{
		put_dir_head();
		put_tree_head();
	} else
		close_tree();
#ifdef NO_READ_LOCK
	if (Type == WRITE)
#endif
		if (flock(Lock, LOCK_UN) < 0)
			IssueMessage(LOG_INFO, "_UN_locking error: %s", strerror(errno));
}

/*
 * function that handles timeouts
 */
void 
TimeOut(sig)
	int sig;
{
	longjmp(WhereIWas, 1);
}
