.\"
.\" xarchie : X11 browser interface to archie
.\"
.\" This manpage is designed to be used either as a normal manpage
.\" processed by nroff, or processed specially for use in the Help
.\" browser. The large number of section headings (.SH) commands are
.\" to provide topics for the browser. The leading spaces in these
.\" headings are used to make a hierarchy of topics.
.\"
.\" If the XX number register is set > 0, then this text is formatted
.\" for use in the Help browser. By default it is formatted like a
.\" normal manpage.
.\"
.\" IMPORTANT: Change the version number both in the .TH line and in
.\"            the "Reporting Bugs" section.
.\"
.\" George Ferguson, ferguson@cs.rochester.edu, 12 Nov 1991.
.\" Version 2.0: 23 Apr 1993
.\"
.\" -----------------------------------------------------------------------
.\" If formatting for Help, kill the header and footer before .TH
.if \n(XX \{\
.de }H
..
.de }F
.. \}
.TH XARCHIE 1 "23 Apr 1993" "U of Rochester"
.\" If formatting for Help, set line length and tabs after .TH
.if \n(XX \{\
.nr LL 40n
.ll 40n
.ta 2,4,6,8,10,12,14,16,18,20 \}
.el .ta 4,8,12,16,20,24,28,32,36,40
.\" Real manpage begins here
.SH NAME
xarchie \- X11 browser interface to archie, version 2.0
.SH SYNOPSIS
.na
.in +8n
.ti -8n
xarchie
[X\ Toolkit\ options]
[\-host\ host]
[\-search\ type|\-e|\-c|\-s|\-r|\-ec|\-es|\-er]
[\-sort\ type|\-t|\-w]
[\-maxhits\ num]
[\-offset\ num]
[\-nice lev|\-N\ lev]
[\-noscroll]
[\-mono|\-gray|\-color]
[\-debug\ num|\-D\ num]
[\-help|-?]
.in -8n
.ad
.SH DESCRIPTION
.PP
Xarchie is an X11 browser interface to the Archie Internet information
system using the Prospero virtual filesystem protocol.  Archie
provides information about files available for ftp anywhere on the
Internet; Xarchie displays this information using an easy-to-use,
point-and-click interface.  Xarchie allows you to further explore ftp
sites by examining directories returned as query matches, and allows
you to retrieve files located this way.  Xarchie is designed (like
most X applications) to be highly customizable, allowing you to tailor
the look-and-feel of the tool to your own preferences.
.PP
This document is broken into two parts. First, the USER'S GUIDE
describes Archie and Xarchie, and covers both Basic and Advanced
Xarchie usage. Second, the REFERENCE MANUAL provides all the
information needed to customize Xarchie. You can also browse this
document using the Xarchie Help facility.
.PP
To report problems or bugs, please see the section "Reporting Bugs" in
the REFERENCE MANUAL section.
.\"===========================================================
.SH "USER'S GUIDE"
.PP
The User's Guide section of this manual describes the Archie service,
the Xarchie client, and how to use Xarchie to access resources
available for FTP on the Internet.
.SH " What is Archie?"
.PP
The Archie information system is a network-based information tool
offering proactive data retrieval and indexing for widely distributed
collections of data.
.PP
Perhaps the best known application of the Archie system is to maintain
the Internet Archives database. This database, already available from a
number of service providers across the Internet, currently contains the
names of over 2,100,000 files at over 1,000 anonymous FTP archive sites.
Using this database, users can rapidly locate needed files without the
need to log onto dozens or even hundreds of machines. Archie servers
offering this database currently receive over 50,000 queries per day.
It is this database that the Xarchie client accesses, as described in
the next section, using one of the many independently owned and
operated Archie servers around the world.
.PP
The Archie system is much more than the Internet Archives database.
For more information contact Bunyip Information Systems at (514)
398-3709 or (514) 398-811 or email "info@bunyip.com".
.\"-----------------------------------------------------------
.SH " What is Xarchie?"
.PP
Xarchie is an X11 browser interface to the Archie Internet Archives
database using the Prospero virtual filesystem protocol.  Archie
provides information about files available for ftp anywhere on the
Internet; Xarchie displays this information using an easy-to-use,
point-and-click interface.  Xarchie allows you to further explore ftp
sites by examining directories returned as query matches, and allows
you to retrieve files located this way.
.PP
Xarchie is designed (like most X applications) to be highly
customizable, allowing you to tailor the look-and-feel of the tool to
your own preferences. See the REFERENCE MANUAL for details.
.PP
Users should be aware that the Xarchie client accesses a server that
is shared with users on other hosts.  As such, submitting long or
large numbers of queries during peak periods not only increases the
time that you have to wait for a response, but it increases the time
that others have to wait too. Please read about the
.I -nice
option, the
.B niceLevel
resource, and the "Nice Level" setting before making large queries.
Also, you should use the closest possible host to save long-distance
network traffic. Abusers of the service may find their access revoked
without notice.
.\"-----------------------------------------------------------
.SH " The Xarchie Display"
.PP
Xarchie uses several conventions regarding menus and button names:
.IP \-
Clicking on a button whose name ends with a ">" will pop up a menu
from which you should select the desired action.
.IP \-
Clicking on or selecting an item whose name ends in "..." will pop up
a panel that will let you perform the desired operation.
.PP
A label with neither of these suffixes indicates that the action will
be taken without subsequent interaction.
.PP
Xarchie's
display is divided into three horizontal areas. The top pane is a
control panel providing the following buttons:
.IP File:
Clicking on this button presents the File Menu, from which you can
select a variety of file-related operations to be described later. The
File Menu operations can also be invoked by holding down the Meta key
and typing the first letter of the operation's name (e.g., Meta-Q to
quit).
.IP Settings:
Clicking on this button presents the Settings Menu, whose operations
will be described in the "Advanced Usage" section.
.IP Query:
This button presents the Query Menu, used to send queries to Archie.
Its operation will be described shortly.
.IP Abort:
When active during a query or retrieval, this button allows you to
abort the operation.
.IP Help:
Clicking on this button pops up the Help Panel, which allows you to
browse this document on-line.
.LP
Finally, the area labelled "Status" is used to provide information
about the progress of a query or other informative messages.
.PP
The middle pane of the Xarchie display functions as a
host-location-file browser. That is, the leftmost pane displays
hostnames, the middle pane locations (directories), and the rightmost
pane files or directories returned by a query. The browser's use is
described in the section "Browsing", below. You can adjust the
relative size of the browser panes using the Grips on their borders.
.PP
Finally, the bottom pane of the Xarchie display provides a set of Text
items where you can enter information and where information is
displayed as query results are browsed. Not all Text items can be
typed in; some are used for display only. These text items provide
Emacs-like editing controls (see
.IR xedit (1)
for a complete description). Typing Return in some Text items invokes
an action as a shortcut for selecting it from a menu or button.
.\"-----------------------------------------------------------
.SH " Basic Xarchie Usage"
.PP
This section provides information on basic querying, browsing, and
file operations. The "Advanced Xarchie Usage" section describes how to
use the Settings Panel and how to perform other, more complicated,
queries.
.\"	-	-	-	-	-	-	-	-
.SH "  Querying"
.PP
The primary function provided by Xarchie is that of querying the
Archie server for a "search term" (the string or expression for which
you want to search). By default, your query uses
.I exact
search mode. That is, the search term must literally match an entry in
the database for the entry to be returned. Other search modes are
available, and are described in the "Advanced Usage" section.
.PP
You enter your search term in the appropriately
labelled Text item in the bottom pane of the Xarchie display.  Hitting
Return in the text item or selecting "Query Item" from the Query Menu
will send your request to Archie.
.PP
The Status area will be updated as the query progresses. First the
Archie server's Internet address is looked up, then the server is
contacted, the search term is sent over, and, after reaching the front
of the server's request queue, matches are returned to Xarchie. The
matches, if any, are displayed in the browser and the Status area
indicates how many matches were returned.
.PP
If your window manager and version of X support it, you can iconify
the Xarchie application and the icon will change to reflect the
progress of your query. That is, it will change when a query is in
progress and when it finishes.
.\"	-	-	-	-	-	-	-	-
.SH "  Aborting"
.PP
If you find that your query is taking too long, you can abort it by
clicking on the "Abort" button when it is active. Your query will
be aborted as soon as possible. You should note that while aborting a
query will allow you to enter a new query, it does not remove the
query from the server's queue (this may be changed in the future).
Thus aborting queries does not reduce the load on the server -- just
the opposite probably. Use it with discretion, like the rest of the
service.
.\"	-	-	-	-	-	-	-	-
.SH "  Browsing"
.PP
As described in the section "The Xarchie Display", the middle pane of
the Xarchie display functions as a host-location-file browser.  The
leftmost pane of the browser contains the names of hosts that have a
file matching your search term. Clicking the Left mouse button on a
hostname will highlight it and cause the middle browser pane to be
filled with a list of locations on that host where files matching your
search term can be found. The selected hostname will also be displayed
in the Text item labelled "Host" in the bottom pane of the Xarchie
display.
.PP
Similarly, selecting a location from the middle browser pane will
cause the right browser pane to be filled with a list of the files
available from the selected host in the selected location, and the
location will be displayed in the bottom pane item labelled
"Location".
.PP
Finally, selecting a file from the right browser pane causes its name,
size, permission modes and last-modification date to be displayed in
the correspondingly-labelled bottom pane items.
.PP
Note that if a browser pane has only one item, then that item will be
automatically selected and its "lesser" panes and information items filled
in. This saves time and effort in the common case where there is only one
host, location, or file that matches your query. Also, note that, by
default, Xarchie scrolls the browser pane when you select an item.
This makes it easy to click through a long list of matches, but can be
annoying. If you don't like it, it can be changed on the Settings
Panel (described below), and see the description of the
.B \-noscroll
command-line option in the REFERENCE MANUAL.
.PP
The browser allows you to select multiple items simultaneously,
although of course only the last-selected item will have it's
information displayed in the bottom pane. You add to a selection by
clicking the Left button with Shift depressed. If the clicked-on item
is already selected, it will be unselected. Currently, only the bottom
level of the browser can have multiple selections, since a selection
at a higher level clears the selections for all lower levels (this may
be changed in the future). Thus you can select multiple files from a
single host, but not multiple files from separate hosts.
.\"	-	-	-	-	-	-	-	-
.SH "  Expanding the Browser"
.PP
The browser can be expanded, allowing you to investigate, say, a
directory that matched your query. To select and expand an directory,
double-click on it (double-click with Shift to avoid unselecting any
other items). You can also select "Open" from the File Menu to expand
directories (although this will also open selected files, as described
later). All selected directories will be expanded by querying an
appropriate Archie server, and the Status area will keep you informed.
Expansion requests can be aborted just like queries using the "Abort"
button.
.PP
If only a single item was expanded, and if the expansion was
successful, then the browser will scroll to display the results. The
arrow buttons across the top of the browser can be used to scroll the
browser left or right when they are active. The Middle and Right mouse
buttons or the Left and Right arrow keys will do the same thing, when
the pointer is in the browser panes.
.\"	-	-	-	-	-	-	-	-
.SH "  Viewing Files"
.PP
You can view a file that is selected in the browser by selecting
"Open" from the File Menu (or by typing Meta\-O).  Xarchie retrieves
all selected files in ASCII mode into a temporary directory.  The
Status area, like usual, will keep you posted on the progress of the
operation and, once the FTP connection is established, the Abort
button can be used to abort the Open operation.  If you abort and
there are files remaining to retrieve, you will be prompted as to
whether to continue with the next file. Note that partially-retrieved
files are not removed.  There is currently no way to abort the
transfer until the connection is established. The connection will
eventually timeout and control will return to Xarchie if connection is
impossible.
.PP
Each file is displayed in a popup Text window after being retrieved.
Use the "Down" and "Up" buttons or the scrollbars to view the text.
Click on the "Dismiss" button to destroy the window and delete the
file. To save the file before dismissing, use the "Save" button. This
pops up a panel with which you can choose the name of the file to
which to save.
.PP
Note that because the Archie database is only updated periodically,
some files returned by Archie may not exist when you attempt to
retrieve them. This and any other FTP errors are signalled with alert
boxes.
.\"	-	-	-	-	-	-	-	-
.SH "  Retrieving Files"
.PP
The "Open" action should be used to view short files, such as "README"
files, that you don't need to save. For more permanent files, and for
non-ASCII files like tar or compressed files, Xarchie allows you to
retrieve the selected browser items using the "Get" item of the File
Menu (or typing Meta\-G). The selected files are retrieved via FTP and
stored in the current directory (see the section "FTP Parameters" in
the "Advanced Usage" section for how to change this).  The "Status"
area is updated to reflect the progress of the transfer. As for
"Open", you can abort the retrieval using the "Abort" button once the
FTP connection is established.
.PP
It is currently not possible to retrieve a directory, although of
course the directory can be opened and the entire contents selected
for transfer.
.PP
Note that because the Archie database is only updated periodically,
some files returned by Archie may not exist when you attempt to
retrieve them. This and any other FTP errors are signalled with alert
boxes.
.PP
As with querying, if your window manager and version of X support it,
Xarchie's icon will be changed to reflect the progress of a transfer.
.\"	-	-	-	-	-	-	-	-
.SH "  Saving, Loading, and Writing"
.PP
Xarchie allows you to save and reload the contents of the browser, or
write it in human-readable format using the items on the File menu.
Selecting either of "Save", "Load", or "Write" (or typing Meta\-S,
Meta\-L, or Meta\-W, respectively) will pop up the File Panel with
which you can specify the appropriate filename.  Clicking on the "Ok"
button will invoke the appropriate action; clicking "Cancel" will
abort the operation and pop down the panel.
.PP
Saving the database creates a file containing sufficient information
for the browser to be reloaded using "Load". The output is not
intended for human consumption. The current Settings are also written
to the file by "Save" and are restored by "Load".
.PP
Users should note that a reloaded database will be "flattened", that
is, directories will be added to the middle pane as needed to fit
everything in three browser panes.  (This may be changed in the future
to preserve the original hierarchy.)
.PP
Writing the database is intended to create files that are more or less
human-readable (compared to "Save", anyway). There are two possible
formats, selectable from the "Write Format" menu on the panel. If "One
entry per line" is selected, then the output will have one line per
entry, in the format

.ce
mode size date host:location/file

If "Pretty-printed" is selected, then the file format has hostnames
starting at the beginning of the line, location names indented one
tab, and file entries indented two tabs, all on separate lines.
Hostnames and locations are only printed once, as in:

.na
.nf
        host
                location
                        mode size date file
                        mode size date file
.fi
.ad

The latter is more readable, the former may be more useful if the
output is to be used by a program.
.\"	-	-	-	-	-	-	-	-
.SH "  Quitting Xarchie"
.PP
You can exit Xarchie by selecting "Quit" from the File Menu (or typing
Meta\-Q).
.\"-----------------------------------------------------------
.SH " Advanced Xarchie Usage"
.PP
This section describes how various aspects of Xarchie's functionality
can be modified to perform different queries and other operations.
Further customization information is found in the REFERENCE MANUAL
section.
.\"	-	-	-	-	-	-	-	-
.SH "  The Settings Panel"
.PP
The panel popped up by selecting "Other" on the Settings Menu in the
top Xarchie pane allows you to change the parameters of your queries
Archie. Each of the parameters is described in the following sections.
.PP
After you're done with the Settings Panel, clicking on the "Apply"
button will make Xarchie use the settings as set on the panel.
Clicking on "Default" will reset the settings to the values they had
when Xarchie started (but note that you will still have to apply them
to have them take effect). Clicking on "Done" closes the Settings
panel. A popup confirmer will appear if you did not apply your
changes, allowing you to discard the changes or go back and apply
them. Note that the "Apply" button is inactive until a change is made.
.PP
The menus available from the "Search\ Type", "Sort\ Type", "Nice\ 
Level" and "Archie\ Host" submenus of the Settings Menu on the
Xarchie top pane have effects corresponding to those of the buttons on
the Settings Panel. However, they do not require that the "Apply"
button be clicked on to take effect, and do not affect the behaviour
of the "Done" button confirmer.
.\"	-	-	-	-	-	-	-	-
.SH "  Archie host"
.PP
The item labelled "Host" provides a menu of known Archie hosts. You
should choose one appropriate to your site (i.e., one that minimizes
long-distance transmission).  In addition however, you can enter an
arbitrary hostname in the Text item next to the "Host" button.  Note
that the Archie host is only used for queries; expansion requests use
information stored with the items to determine which host to contact.
That is, changing the Archie host does not "take effect" until the
next query is issued.
.PP
If you have the
.IR ping (1)
program, you can try to use it with the its "\-s" option to locate a
"nearby" host.
.PP
You can specify hostnames using either the symbolic name or by giving
its numeric IP address (four octets separated by periods). In either
case, you can specify the port at which the Prospero server should be
contacted by giving it in parentheses immediately following the
hostname (no spaces).
.\"	-	-	-	-	-	-	-	-
.SH "  Search mode"
.PP
The "Search Mode" item allow you to change how Archie interprets your
search term.  Holding a mouse button down while the mouse cursor is on
the button displays a menu from which you can choose the desired
search type.  The label to the right of the item is updated to reflect
the choice.
.PP
The
.I exact
mode is fastest and returns files exactly matching your search term.
The
.I substr
and
.I subcase
modes return substring and case-sensitive substring matches
respectively (i.e.,
.I substr
means case-insensitive). The
.I regexp
mode allows you to specify a regular expression to select files (see
.IR ed (1)
for a description of regular expression syntax).
The
.I exact*
forms of these last three try an exact match first and then fall back
on the more costly search type if the exact match fails.
.PP
.\"	-	-	-	-	-	-	-	-
.SH "  Sort mode"
.PP
The "Sort Mode" item allows you to specify how Xarchie displays the
results from Archie.  Holding a mouse button down while the mouse
cursor is in this item displays a menu from which you can choose the
desired sort type.  The label to the right of the item is updated to
reflect the choice.  Applying the settings (see above) will cause the
data to be resorted according to the new sort mode.
.PP
The type can be one of
.IR name ,
.IR date ,
or
.IR weight .
Sorting by
.I name
is simple lexicographic ordering.
.PP
If sorting by
.I date
is selected, then hosts are ordered according to the most recent file
among those returned for them, and similarly for locations. Files
themselves are ordered by last-modification date, naturally.
.PP
If sorting by
.I weight
is selected, then hosts are ordered by a user-definable set of
"weights". In this way, hosts that are "close" (in some sense) are
displayed first. The weights can be set using the Text item that
appears on the Settings Panel when this sort mode is selected.
.PP
Hopefully, an appropriate weight list for the geographic location of
your site will have been installed as the default. In any case, the
the weight list is a set of lines, where each line specifies a weight
and the set of domains for that weight. A
host's weight is determined by finding the first line for which the
end of the host's name matches one of the suffixes. A host that
belongs in none of the classes is assigned the weight 99. For example,
the default for the USA is:

.nf
.na
	  1 edu com net gov mil us\en\e
	  2 ca\en\e
	  3 uk de nl fi fr eu.net\en\e
	100 au nz jp
.ad
.fi

This means that all the US domains are ordered first, then Canada,
then several European countries. Hosts in Australia, New Zealand, and
Japan are ordered
.I after
any unknown (i.e. non-matching) hosts.
.PP
For more details, see the description of the
.B hostWeights
non-widget resource in the REFERENCE MANUAL section.
.\"	-	-	-	-	-	-	-	-
.SH "  Nice level"
.PP
The "Nice Level" item deserves special mention. As mentioned in the
"About Archie" section, Archie servers run on machines that must be
shared between other
Archie
users and even other "real" users. This item allows you to voluntarily
lower the priority of your request, just like the
.IR nice (1)
command does for Unix. The menu provides some recommended values and
you can enter arbitrary values in the text item. If you are searching
with a large number of matches requested, please increase your nice
level.
.PP
Note that, like
.IR nice (1),
nicing a job does not mean your job won't affect others.  In
particular, once your job begins it is not pre-empted, thus you should
still avoid long jobs during peak periods. You should especially avoid
queries for items of only personal interest (you know what we mean)
during these periods. As stated above, abusers of the service may find
their access revoked without notice.
.\"	-	-	-	-	-	-	-	-
.SH "  Other Query Settings"
.PP
The following items set parameters of your query to the Archie server.
.IP "Max Hits:"
the limit on the number of successful matches that will be
returned.
.IP "Initial Timeout:"
the length of the first timeout interval in seconds.
.IP "Retries:"
the number of times to retry a query if it times out, doubling the
timeout each retry.
.PP
These items are Text items that allow you to edit their values.
.PP
The item labelled "Auto-Scroll Browser" controls whether the browser
scrolls after an item is selected. Setting this to "yes" is useful
when browsing a long list of matches. It can be annoying if you're
doing more selective browsing, so set it to "no" in those cases.
.\"	-	-	-	-	-	-	-	-
.SH "  FTP settings"
.PP
The following items allow you to set parameters of file retrieval. You
should be sure they are appropriately set before retrieving files
using either "Open" or "Get".
.IP "FTP Email Address:"
Specifies the password used for anonymous FTP login. By convention,
users logging in as "anonymous" send their email address as the
password. Some servers enforce this by checking the address. The
default may not be appropriate depending on what information Xarchie
could glean from your system about its address. You can set the
environment variables
.B USER
and
.B HOSTNAME
to override the system's
information, or see the description of the
.B ftpMailAddress
non-widget resource in the REFERENCE MANUAL.
.IP "FTP Local Directory:"
Specifies the directory into which files will be retrieved using
"Get".
.IP "FTP Transfer Type:"
Provides a menu from which you can select "ascii" or "binary" mode
transfer for files retrieved with "Get". Files retrieved with "Open"
are always retrieved in ascii mode.
.IP "FTP Prompt:"
Provides a menu allowing you to enable or disable prompting during
multi-file transfers.
.IP "Trace FTP Transfers:"
Since FTP transfers are susceptible to timeouts and other confusions,
this item allows you to monitor any FTP interactions. If tracing is
enabled, then invoking "Open" or "Get" on a file will popup a trace
window that displays a running log of the FTP session as it happens.
Using this successfully requires that you understand something about
how FTP works, which is beyond the scope of this document.
.IP "Strip CR"
If this option is enabled, then carriage returns are removed from
ASCII-mode files. This is usually desirable when transferring to a
Unix machine.
.\"	-	-	-	-	-	-	-	-
.SH "  Querying Hosts and Locations"
.PP
The Query Menu provides two other types of queries besides the "Query
Item" described in the "Basic Usage" section for querying the Archie
database.
.PP
Selecting "Query Host" will use the hostname in the "Host" Text item
on the bottom pane and will fill the browser with the contents of the
root of its FTP directory. From then on, interaction is as previously
described. The host to query can be in the "Host" item as a result of
selecting a host in the browser, or you can type directly into the
item the name of the host that you wish to open. Typing Return in the
"Host" item is equivalent to selecting "Query Host" from the Query
Menu.
.PP
Querying locations by selecting "Query Location" is similar: the
Archie server is queried for the contents of the directory given by
the "Location" item on the host given by the "Host" item. The browser
is filled in with the results of the query (i.e., the contents of the
directory). As before, you can type the name of the location into the
"Location" item if you wish, and typing Return there is the same as
invoking "Query Location".
.PP
Note that because the Archie database is only updated periodically,
some files returned by Archie may not exist when you attempt to
retrieve them. Similarly, recently added files may exist on the host
but not in the Archie database.
.\"===========================================================
.SH "REFERENCE MANUAL"
.PP
This section provides all the information you should need to customize
Xarchie. Command-line options, non-widget resources, widget
hierarchies, translations actions, and other information are all
provided. It is assumed that you understand enough about X
applications to understand this.
.\"----------------------------------------------------------
.SH " Command-line Options"
.PP
The following non-widget resources can be set from the command-line or
in a resource file. As usual, when given on the command line they can
be abbreviated to their shortest unique prefix, often the first
letter.  Furthermore Xarchie accepts all the standard X Toolkit
options (see
.IR X (1)).
.\"	-	-	-	-	-	-	-	-
.IP "\fB-host\fP host"
Sets the host to which Archie queries will be sent. Please be careful
to use the nearest possible host. The default is "archie.sura.net".
This option corresponds to the
.B archieHost
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-search\fP type"
Sets the search mode for Archie queries. The type can be one of
.IR exact ,
.IR substr ,
.IR subcase ,
.IR regexp ,
.IR exactSubstr ,
.IR exactSubcase ,
or
.IR exactRegexp .
See the section describing the Settings Panel in the USER'S GUIDE for
a description of the various search types.  The default search mode is
.IR exact .
This option corresponds to the
.B searchType
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-e\fP"
Equivalent to "\fB-search\ exact\fP".
.IP "\fB-s\fP"
Equivalent to "\fB-search\ substr\fP".
.IP "\fB-c\fP"
Equivalent to "\fB-search\ subcase\fP".
.IP "\fB-r\fP"
Equivalent to "\fB-search\ regexp\fP".
.IP "\fB-es\fP"
Equivalent to "\fB-search\ exactSubstr\fP".
.IP "\fB-ec\fP"
Equivalent to "\fB-search\ exactSsubcase\fP".
.IP "\fB-er\fP"
Equivalent to "\fB-search\ exactRegexp\fP".
.\"	-	-	-	-	-	-	-	-
.IP "\fB-sort\fP type"
Sets the sort mode for displaying Archie responses. The type can be
one of
.IR name ,
.IR date ,
or
.IR weight .
See the section describing the Settings Panel in the USER'S GUIDE for a
description of the various sort types.  This option corresponds to the
.B sortType
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-t\fP"
Equivalent to "\fB-sort\ date\fP".
.IP "\fB-w\fP"
Equivalent to "\fB-sort\ weight\fP".
.\"	-	-	-	-	-	-	-	-
.IP "\fB-maxHits\fP num"
Sets the maximum number of matches allowed per query. This option
corresponds to the
.B maxHits
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-offset\fP num"
Sets the offset of the Prospero query. This option corresponds to the
.B offset
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-nice\fP level or \fB-N\fP level"
Sets the query niceness level. Higher numbers are nicer, up to a
maximum niceness of 32765. The default niceness is 0. This option
corresponds to the
.B niceLevel
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-noscroll\fP"
By default, Xarchie scrolls the browser lists automatically when you
select items. This usually makes it easier to scan through the results
of queries but can be annoying. This option turns off the automatic
scrolling. It corresponds to the
.B autoScroll
resource.
.IP "\fB\-mono\fP or \fB\-gray\fP or \fB\-color\fP"
By default, Xarchie will determine the visual type of your display and
use the proper color resources. If it gets it wrong, you can override
the default by specifying one of these options. They correspond to the
.B visualType
resource.
.\"	-	-	-	-	-	-	-	-
.IP "\fB-debug\fP level or \fB-D\fP level"
Sets the Prospero debugging level. Higher numbers mean more verbose
messages.
This option corresponds to the
.B debugLevel
resource.
.I Xarchie
must be specially compiled for this option to have any effect (see the
Imakefile or your local installer).
.\"	-	-	-	-	-	-	-	-
.IP "\fB-help\fP or \fB-?\fP"
Prints the usage message summarizing Xarchie options.
.\"----------------------------------------------------------
.SH " Non-widget Resources"
.PP
.I Xarchie
has a default set of resources built in. If you wish to customize the
tool, take a copy of the default application defaults file (see the
section "Files", below) and modify it. Then, before invoking Xarchie,
set the environment variable
.B XAPPLRESDIR
to the directory containing your private copy. Alternatively, you can place
entries in your .Xdefaults file or provide them with the
.B -xrm
toolkit option (see
.IR X (1)).
Most of the following resources can also be set using the command-line
options described in the previous section.
.\"	-	-	-	-	-	-	-	-
.SH "  Query Resources"
.IP "\fBarchieHost\fP"
Sets the host to which Archie queries will be sent. Please be careful
to use the nearest possible host. The default is "archie.sura.net".
This resource can be set with the
.B \-host
option or on the Settings Panel.
.IP
You can specify hostnames using either the symbolic name or by giving
its numeric IP address (four octets separated by periods). In either
case, you can specify the port at which the Prospero server should be
contacted by giving it in parentheses immediately following the
hostname (no spaces).
.\"	-	-	-	-	-	-	-	-
.IP "\fBsearchType\fP"
Sets the search mode for Archie queries. This can be one of
.IR exact ,
.IR substr ,
.IR subcase ,
.IR regexp ,
.IR exactSubstr ,
.IR exactSubcase ,
or
.IR exactRegexp .
See the section describing the Settings Panel in the USER'S GUIDE for
a description of the various search types.  The default search mode is
.IR exact .
This resource can be set with the
.B \-search
option, or its abbreviations
.BR \-e ,
.BR \-s ,
.BR \-c ,
.BR \-r ,
.BR \-es ,
.BR \-ec ,
or
.BR \-er ,
or on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBsortType\fP"
Sets the sort mode for displaying Archie responses. This can be one of
.IR name ,
.IR date ,
or
.IR weight .
See the section of the Settings Panel, above, for a description of the
various search types.  This resource can be set with the
.B \-sort
option, or its abbreviations
.B \-t
or
.BR \-w ,
or on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBhostWeights\fP"
Specifies the weights used to order hosts when sorting by
.I weight
is selected. The format of this resource is a series of entries of the
form:

.ce
weight host [hosts...] {,|\en}

where parts of an entry are separated by spaces or tabs and entries
are separated by a comma or newline.  Each entry specifies a weight
and a series of possible suffixes (one or more trailing components). A
host's weight is determined by finding the first class for which the
end of the host's name matches one of the suffixes. A host that
belongs in none of the classes is assigned the weight 99. For example,
the default for the USA is:

.nf
.na
	  1 edu com net gov mil us\en\e
	  2 ca\en\e
	  3 uk de nl fi fr eu.net\en\e
	100 au nz jp
.ad
.fi

This means that all the US domains are ordered first, then Canada,
then several European countries. Hosts in Australia, New Zealand, and
Japan are ordered
.I after
any unknown (i.e. non-matching) hosts. This resource can be set on the
Settings Panel.
.IP
If this resource is not defined, Xarchie will attempt to make an
intelligent choice by comparing the system's idea of its hostname with
a set of pre-compiled defaults. This may not work, but is usually
better than nothing, and it can always be edited on the Settings Panel
anyway.
.\"	-	-	-	-	-	-	-	-
.IP "\fBniceLevel\fP"
Sets the query niceness level. Higher numbers are nicer, up to a
maximum niceness of 32765. The default is 0. This resource can be set
with the
.B \-nice
option or on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBmaxHits\fP"
Sets the maximum number of matches allowed per query. The default is 99.
This resource can be set with the
.B \-maxHits
option or on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBoffset\fP"
Sets the Prospero offset. The default is 0.  This resource can be set
with the
.B \-offset
option or on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBtimeout\fP"
Sets the initial timeout value, in seconds. The default is 4. This
resource can be set on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBretries\fP"
Sets the number of retries, where the timeout doubles every retry.
This resource can be set on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBdebugLevel\fP"
Sets the Prospero debugging level. Higher numbers mean more verbose
messages.  Xarchie must have been compiled specially for this option
to have any effect (see the Imakefile or your local installer). This
resource can be set with the
.B \-debug
or
.B \-D
options.
.\"	-	-	-	-	-	-	-	-
.SH "  Browser Resources"
.IP "\fBautoScroll\fP"
By default, Xarchie scrolls the browser lists automatically when you
select items. This usually makes it easier to scan through the results
of queries but can be annoying. This resource enables or disables
automatic scrolling.  The default is True.  It can be set to False
with the
.B \-noscroll
option and can be changed on the Settings Panel.
.IP "\fBpasteBuffer\fP"
If this resource is True (the default), browser selections are stored
in the CUT_BUFFER_0 property of the root window of the Xarchie
display in the format:

.ce
\fIhost\fP:\fIlocation\fP/\fIfile\fP

This allows them to be used by other applications using
XFetchBytes(3X).  The Xarchie distribution includes a sample program
(xcutbuf.c) that retrieves the contents of a cutbuffer property.
.\"	-	-	-	-	-	-	-	-
.SH "  FTP Resources"
.IP "\fBftpMailAddress\fP"
By convention, FTP users are expected to send their email address as
the password during anonymous login.  The string specified by this
resource is passed to sprintf(3) along with two parameters: the
username and the hostname (as indicated by the system or by the
.B USER
and
.B HOSTNAME
environment variables), and the result is used as the password for
anonymous FTP logins. The default is "%s@%s". You should change this
resource if your system returns strange or incorrect values for either
parameter. The password (after sprintf) can be edited on the Settings
Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBftpLocalDir\fP"
Sets the local destination directory for ftp transfers. This will be
used as the initial value of the "FTP Local Dir" item on the Settings
Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBftpType\fP"
Sets the transfer type for ftp transfers. This will be used as the
initial value of the "Ftp transfer type" item on the Settings Panel.
It should be one of "ascii" or "binary".
.\"	-	-	-	-	-	-	-	-
.IP "\fBftpPrompt\fP"
Specifies whether to prompt for verification during transfers
involving multiple files. This will be used as the initial value of
the "Prompt during transfers" item on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBftpTrace\fP"
Specifies whether to pop up a window in which FTP transactions are
monitored. This will be used as the initial value of the "Trace
FTP transfers" item on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.IP "\fBftpStrip\fP"
Specifies whether to strip carriage returns from files transferred in
ASCII mode.  This will be used as the initial value of the "Strip CR"
item on the Settings Panel.
.\"	-	-	-	-	-	-	-	-
.SH "  Database Writing Resources"
.IP "\fBfileWriteOnePerLine\fP"
Specifies the format of files written by "Write".  This will be used
as the initial value of the "Write format" item on the File Panel.
The meaning of this setting is described in the USER'S GUIDE section
on "Saving, Loading, and Writing".
.\"	-	-	-	-	-	-	-	-
.SH "  Special Font Resources"
Xarchie uses two fonts by default: one "normal" and one "bold".
However, because of widget naming and resource lookup conventions,
these fonts must be specified in many places in the resource file. To
make it easier to find and change these fonts, the following two
resources are defined:
.IP "\fBxarchieFont\fP"
The name of the default font used by Xarchie widgets. If any widget
specifies a font resource as "xarchieFont", this font will be used.
.IP "\fBxarchieBoldFont\fP"
Like the above, but specifies the font used by any widget that
specifies a font resource of "xarchieBoldFont".
.PP
The resource converter that looks up fontnames is modified so that the
the two special strings "xarchieFont" and "xarchieBoldFont" result in
the corresponding font being returned; other strings are looked up as
normal fontnames.
.\"	-	-	-	-	-	-	-	-
.SH "  Other Resources"
.IP "\fBvisualType\fP"
This resource allows you to override Xarchie's builtin determination
of the type of display, which it uses to specify appropriate color
resources. You can specify "mon", "gray", or "color" as the value of
this resource. It can also be set with the corresponding command-line
options.
.IP "\fBdefaultIcon\fP"
If given, this resource specifies the name of an X bitmap file that
will be used as Xarchie's icon when not querying (assuming you are
using a window manager that supports icon pixmaps). The X resource
conversion routines will look for the file in a variety of places,
including directories given by the global resource
.BR bitmapFilePath .
.IP "\fBbusyIcon\fP"
If given, this resource specifies the name of an X bitmap file that
will be used as Xarchie's icon when querying (see the description of
the
.B defaultIcon
resource, above). The icon is changed back to the default when the
query completes, so you can watch for a change while Xarchie is
iconified.
.\"----------------------------------------------------------
.SH " Widget Hierarchies"
.PP
Xarchie uses primarily Athena widgets, with some extra sub-classes as
described below.
.\"	-	-	-	-	-	-	-	-
.SH "  Main Xarchie Widgets"
The widget hierarchy for the main Xarchie display is as follows:

.na
.nf
Xarchie xarchie
  [Form color|gray] <-- Color or gray-scale displays only
	Paned outerPaned
		Form buttonForm
			MenuButton fileButton
			MenuButton settingsButton
			MenuButton queryButton
			Command abortButton
			Command helpButton
			Label,Text status{Label,Text}
		Form browserForm
			Command browserUpButton
			Command browserDownButton
			Paned browserPaned
				Viewport browserViewport0
					XfwfMultiList browserList0
				Viewport browserViewport1
					XfwfMultiList browserList1
				Viewport browserViewport2
					XfwfMultiList browserList2
		Form stringForm
			Label,Text search{Label,Text}
			Label,Text host{Label,Text}
			Label,Text location{Label,Text}
			Label,Text file{Label,Text}
			Label,Text size{Label,Text}
			Label,Text modes{Label,Text}
			Label,Text date{Label,Text}
.fi
.ad

On color displays, there is an extra Form widget named "color" created
as the only child of the toplevel shell, and all other widgets are
children of it. This allows resources that are only applicable for
color displays to use the prefix "Xarchie.color" while generally
applicable resources should use the "Xarchie*" prefix. On gray-scale
displays, the extra widget is named "gray". On monochrome displays, no
extra widget is created.
.PP
The XfwfMultiList widget is a modification of the standard Athena List
widget that allows multiple items to be selected. It was written by
Brian Totty (totty@flute.cs.uiuc.edu) and is distributed by the Free
Widget Foundation (contact free-widgets-request@kazoo.cs.uiuc.edu).
.I Xarchie
can be compiled to use standard Athena List widgets instead. See the
Imakefile or your local installer.
.PP
To describe this widget hierarchy briefly,
.I outerPaned
controls the relative sizes of the three horizontal display areas while
.I browserPaned
allows the browser panels to be resized independently. Each browser
panel consists of a Viewport to allow it to scroll and an
XfwfMultiList (or List) to display the entries.
.PP
The command buttons and status widgets are pretty straightforward. The
.I fileButton
pops up the
.IR fileMenu ,
whose items invoke the obvious actions (see below) when selected. The
.I settingsButton
pops up the
.IR settingsMenu ,
which uses some special translations and the
.B settings\-submenu()
action to permit the use of pullright submenus. The
.I queryButton
pops up the
.IR queryMenu ,
the
.I abortButton
(when active) invokes the
.B abort()
action,
and the
.I helpButton
invokes the
.B help()
action to pop up the Help panel.
.PP
In the bottom pane, the
.I searchText
widget is used to enter the search term, and by default it binds Return
to the
.B query()
action (see below) to send the query to Archie.  The
.I hostText
binds Return to
.B query\-host()
and the
.I locationText
binds Return to
.BR query\-location() .
All the other Text items in the
.I stringForm
cannot be edited and are used to display information about the current
browser selection.
.\"	-	-	-	-	-	-	-	-
.SH "  Settings Panel Widgets"
.PP
The "Panel" item on the Settings menu
pops up the Settings Panel, which has the following widget hierarchy:

.na
.nf
	TopLevelShell settingsShell
		Form settingsForm
			Command setDoneButton
			Command setApplyButton
			Command setDefaultButton
			MenuButton,AsciiText setHost{Button,Text}
			MenuButton,Label setSearch{Button,Label}
			MenuButton,Label setSort{Button,Label}
			Label,AsciiText setHostWeights{Label,Text}
			MenuButton,AsciiText setNice{Button,Text}
			Label,AsciiText setMaxHits{Label,Text}
			Label,AsciiText setTimeout{Label,Text}
			Label,AsciiText setRetries{Label,Text}
			Label,AsciiText setAutoScroll{Button,Label}
			Label,AsciiText ftpMailAddress{Label,Text}
			Label,AsciiText ftpLocalDir{Label,Text}
			MenuButton,Label ftpType{Button,Label}
			MenuButton,Label ftpPrompt{Button,Label}
			MenuButton,Label ftpTrace{Button,Label}
			MenuButton,Label ftpStrip{Button,Label}
.fi
.ad

The
.I setDoneButton
invokes the
.B settings\-done()
action, the
.I setApplyButton
invokes
.BR settings\-apply() ,
and the
.I setDefaultButton
invokes
.BR settings\-default() .
The actions are described below.  The MenuButton widgets pop up menus
described below under "Menus".  The AsciiText widgets are used to
display and edit the corresponding parameters.
.\"	-	-	-	-	-	-	-	-
.SH "  File Panel Widgets"
.PP
The "Save", "Load", and "Write" items on the File menu pop up the
File panel, which has the following widget hierarchy:

.na
.nf
TopLevelShell fileShell
	Form fileForm
		Label fileLabel
		XfwfFileChooser fileChooser
		Label,AsciiText filename{Label,Text}
		MenuButton,Label fileWriteMode{Button,Label}
		Command fileOkButton, fileCancelButton
.fi
.ad

.PP
The XfwfFileChooser widget provides a browser for selecting files.
.I Xarchie
can be compiled without the FileChooser, if necessary.  See the
Imakefile or your local installer.
.PP
In any event, the
.I fileLabel
indicates what operation is being performed, the fileChooser,
fileText, and buttons are used to select a file, and the
.I fileWriteModeButton
pops up the
.I fileWriteModeMenu
(only enabled for Write). Typing Return in the
.I filenameText
is the same as clicking the
.IR fileOkButton ,
and sending the WM_DELETE_WINDOW message (typically from the window
manager) is the same as clicking on the
.IR fileCancelButton .
.\"	-	-	-	-	-	-	-	-
.SH "  View Window Widgets"
Whenever a file is retrieved by "Open", it is displayed in a window
with the following widget hierarchy:

.nf
.na
TopLevelShell viewShell
	Form viewForm
		Command viewDoneButton
		Command viewDownButton
		Command viewUpButton
		Command viewSaveButton
		Text viewText
.ad
.fi

The title of the TopLevel shell is set to the basename of the file
being viewed in the
.IR viewText .
The operation of the buttons is all hard-coded.
Clicking on the
.I viewSaveButton
results in the following panel being displayed to select the file to
save to:

.na
.nf
TopLevelShell viewSaveShell
	Form viewSaveForm
		Label viewSaveLabel
		AsciiText viewSaveLabelText
		XfwfFileChooser fileChooser
		Label viewSaveTextLabel
		AsciiText viewSaveText
		Command viewSaveOkButton, viewSaveCancelButton
.fi
.ad

The
.I viewSaveLabelText
indicates the name of the temporary file from which the save should be
made and connot be changed. The
.I fileChooser
and
.I fileText
allow you to select the file to save to.
.\"	-	-	-	-	-	-	-	-
.SH "  Help Panel Widgets"
The "Help" button in Xarchie's top pane pops up the Help panel, which
has the following widget hierarchy:

.na
.nf
TopLevelShell  helpShell
	Form  helpForm
		Label  helpLabel
		Viewport  helpViewport
		List  helpList
		Text  helpText
		Command  helpDoneButton
		Command  helpPrevButton
		Command  helpNextButton
		Command  helpDownButton
		Command  helpUpButton
.fi
.ad

The
.I helpLabel
identifies the version of Xarchie.  The
.I helpList
displays the help topics, and the corresponding text is displayed in
the
.IR helpText .
The
.I helpDoneButton
invokes the
.B help\-done()
action, the
.I helpPrevButton
invokes the
.B help\-prev()
action, and the
.I helpNextButton
invokes the
.B help\-next()
action. The
.I helpDownButton
and
.I helpUpButton
invoke the
.B help\-down()
and
.B help\-up()
actions respectively.
.\"	-	-	-	-	-	-	-	-
.SH "  About Panel Widgets"
.PP
Selecting the "About" item on the File menu
pops up the About panel, which has the following widget
hierarchy:

.na
.nf
TopLevelShell aboutShell
	Form aboutForm
		Label aboutLabel{0,1,2,3,4,5}
		Command aboutDoneButton
.fi
.ad

The labels are set to display the version of Xarchie and other contact
information. There is little you can or should do with these widgets.
.SH "  Popup Widgets"
.PP
Finally, two types of popup windows can appear. An Alert box signals
an error and blocks until clicked in; a Confirm box allows the user to
make a Yes/No decision. These have the following widget hierarchies:

.na
.nf
TransientShell alertShell
	Dialog alertDialog
		Command okButton

TransientShell confirmShell
	Dialog confirmDialog
		Command yesButton,noButton
.fi
.ad

respectively. Several actions are defined (see below) for use in these
popups.
.\"	-	-	-	-	-	-	-	-
.SH "  Menus"
The MenuButton widgets on both the main Xarchie display and on the
various panels use standard Athena SimpleMenu widgets. The following
naming conventions are used to allow resources to be specified: if the
parent SimpleMenu widget is named "\fIfoo\fPMenu", then the
SmeBSBObjects making up the entries are named
"\fIfoo\fPMenuItem\fIn\fP", where \fIn\fP starts at 0 for the first
item in the menu. The menus are all children of the main Xarchie
shell,
.IR toplevel .
For example, the File menu has widget hierarchy

.nf
.na
SimpleMenu  fileMenu
	SmeBSB  menuLabel
		SmeBSB  fileMenuItem{0,1,2,3,4,5,6}
.ad
.fi

.PP
There are three things worth mentioning. First, as noted above, the
.I settingsMenu
uses special translations and the
.B settings\-submenu()
action to allow pullright submenus. Secondly, the submenus available
from the Settings menu (\c
.IR searchMenu ,
.IR sortMenu ,
.IR niceMenu ,
and
.IR hostMenu )
and those available on the Settings Panel (\c
.IR setSearchMenu ,
.IR setSortMenu ,
.IR setNiceMenu ,
and
.IR setHostMenu )
have the same labels but are different widgets with different effects.
The Settings Panel menus (the second group) only update the Settings
panel, requiring the Done button to be clicked to take effect. The
Settings menu submenus (the first group) take effect immediately, and
also indicate the current item in the left margin of the menu.
.PP
Finally, the number, order, and effect of all menus are hardcoded,
although the labels can, of course, be changed in the resource file.
However, changing the labels will NOT change the effect of selecting
the item, with the exception of the
.I hostMenu
and
.IR setHostMenu .
These menus use the
.I numHosts
non-widget resource to indicate how many items are on the menu. Thus
you can add hosts to the menu by adding
.I label
resources for the new
.IR hostMenuItem 's
and increasing the value of
.IR Xarchie.numHosts .
.\"----------------------------------------------------------
.SH " Translation Actions"
.PP
The following action procedures are registered for Xarchie and can be
bound to widget events using the
.B translations
resource (see the Xt manual, Appendix C). The actions of the browser
widgets are hard-coded since they are so essential to correct behaviour.
They can however be bound to different events using the
.B notify()
action (that is, you could notify on some other event than mouse
clicks, if you know what you're doing).
.\"	-	-	-	-	-	-	-	-
.SH "  Main panel actions"
.IP \fBquit()\fP
Exit Xarchie.  By default this is invoked by selecting "Quit" from the
File menu or by typing "Meta-Q" in any non-Text widget.
.IP \fBquery()\fP
Send the current contents of the "Search Term" text widget
(\fIsearchText\fP) to
.IR Archie .
By default this is performed by hitting Return in \fIsearchText\fP or
by selecting "Query Item" from the Query menu.
.IP \fBquery-host()\fP
Fills the browser with the contents of the root directory of the host
given by the contents of the "Host" text widget (\fIhostText\fP).  By
default this is performed by hitting Return in \fIhostText\fP or by
by selecting "Query Host" from the Query menu.
.IP \fBquery-location()\fP
Fills the browser with the contents of the directory given by the
"Location" text widget (\fIlocationText\fP) and the host
given by the contents of the "Host" text widget (\fIhostText\fP).  By
default this is performed by hitting Return in \fIlocationText\fP or
by selecting "Query Location" from the Query menu.
.IP \fBabort()\fP
Aborts the current query at the soonest possible time. Has no effect
is a query is not currently being processed. By default, this invoked
by clicking on the Abort button when it is active.
.IP \fBquery-or-abort()\fP
Invokes either
.B query()
or
.BR abort() ,
depending on whether a query is in progress.
.IP \fBabout()\fP
Pops up the About panel.
.IP \fBftp-get()\fP
Begin retrieval of the currently-selected files. By default this is
invoked by selecting "Get" from the "File" menu, or by typing "Meta-G"
in any non-Text widget.
.\"	-	-	-	-	-	-	-	-
.SH "  Browser actions"
.PP
Items are selected in the browser using the Left mouse button, as
usual.  Clicking with Shift does not clear other selections, allowing
multiple selections. This is implemented using the XfwfMultiList
translation actions
.BR Notify() ,
.BR Set() ,
.BR Toggle() ,
and
.BR OpenMany() ,
unless your version of Xarchie was compiled to not use the
XfwfMultiList widget (see the Imakefile or your local installer).
Modify at your own risk!
.PP
The following actions are used for other browser operations.
.IP \fBbrowser-up()\fP
Shifts the browser left (i.e., up the file hierarchy) if possible.
By default this is invoked by clicking on the "<<<" button
(\fIbrowserUpButton\fP), or by clicking the Middle mouse button in the
browser, or by hitting the "Left" key (often the left arrow on the
cursor keypad).
.IP \fBbrowser-down()\fP
Shifts the browser right (ie., down the file hierarchy) if possible.
By default this is invoked by clicking on the ">>>" button
(\fIbrowserDownButton\fP), or by clicking the Right mouse button in
the browser, or by hitting the "Right" key (often the right arrow
on the cursor keypad).
.IP \fBbrowser-top()\fP
Shifts the browser to its leftmost position (i.e., the top of the file
hierarchy).  By default this is invoked by clicking with Shift on the
"<<<" button (\fIbrowserUpButton\fP) or by hitting the "Home" key.
.IP \fBbrowser-open-directories()\fP
Expands selected directories. If the browser was expanded uniquely and
successfully, it will be shifted right to display the new information.
By default, this is invoked by double-clicking in the browser.
.IP \fBbrowser-open-files()\fP
Retrieves selected files by FTP into a temporary file and displays
them using View windows.
.IP \fBbrowser-open-all()\fP
Opens the selected items by expanding selected directories and
retrieving selected files for viewing.  By default, this is invoked by
selecting "Open" from the File menu, or by typing "Meta-O" in any
non-text widget.
.\"	-	-	-	-	-	-	-	-
.SH "  Settings actions"
The following actions control the Settings Panel and can be used to
change some settings without using the panel.
.IP \fBpopup-settings()\fP
Pops up the Settings Panel, and resets its values to those currently
in effect. Raises the Settings Panel if it is already popped up. By
default this is performed by selecting "Other" on the Settings menu.
.IP \fBsettings-apply()\fP
Sets the current settings from the values on the Settings Panel.  By
default this is performed by clicking the "Apply" button on the
Settings Panel.
.IP \fBsettings-default()\fP
Resets the values on the Settings Panel to the default settings,
but does not affect the current settings until the
.B settings\-apply()
action is invoked. By default, this is invoked by clicking on the
"Default" button on the Settings Panel.
.IP \fBsettings-done()\fP
Pops down the Settings Panel. If there are changes that have not be
applied, then a popup confirm box allows the user to discard the
settings or go back and apply them.  By default, this is invoked by
clicking on the "Done" button on the Settings Panel.
.IP \fBset-host(\fRhostname\fB)\fR
This action sets the
.I Archie
host as indicated on the Settings Panel, but does not affect the
current settings until the
.B settings\-apply()
action is invoked.
.IP \fBset-host-now(\fRhostname\fB)\fR
Sets the
.I Archie
host immediately without waiting for
.BR settings\-apply() .
.IP \fBset-search-type(\fRtype\fB)\fR
This action sets the searchType as indicated on the Settings Panel,
but does not affect the current settings until the
.B settings\-apply()
action is invoked.
.IP \fBset-search-type-now(\fRtype\fB)\fR
Sets the searchType immediately without waiting for
.BR settings\-apply() .
.IP \fBset-sort-type(\fRtype\fB)\fR
This action sets the sortType as indicated on the Settings Panel,
but does not affect the current settings until the
.B settings\-apply()
action is invoked.
.IP \fBset-sort-type-now(\fRtype\fB)\fR
Sets the sortType immediately without waiting for
.BR settings\-apply() .
.IP \fBset-nice-level(\fRlevel\fB)\fR
This action sets the niceLevel as indicated on the Settings Panel,
but does not affect the current settings until the
.B settings\-apply()
action is invoked.
.IP \fBset-nice-level-now(\fRlevel\fB)\fR
Sets the niceLevel immediately without waiting for
.BR settings\-apply() .
.IP \fBsettings-submenu()\fP
This action procedure is documented here only for completeness. It
should only be used for BtnMotion events in the
.I settingsMenu
widget. It invokes the appropriate pullright menu for the Settings
menu. Believe me, you don't want to deal with this.
.\"	-	-	-	-	-	-	-	-
.SH "  File actions"
The operation of the File panel is hard-coded. The following actions
are used to pop it up however:
.IP \fBfile-save()\fP
Pops up the File panel, and resets its values in preparation for
saving the database. By default this is invoked by selecting "Save"
from the "File" menu or by typing "Meta-S" in any non-Text widget.
.IP \fBfile-load()\fP
Pops up the File panel, and resets its values in preparation for
reloading the database. By default this is invoked by selecting "Load"
from the "File" menu or by typing "Meta-L" in any non-Text widget.
.IP \fBfile-write()\fP
Pops up the File panel, and resets its values in preparation for
writing the database in a human-readable form. By default this is
invoked by selecting "Write" from the "File" menu or by typing
"Meta-W" in any non-Text widget.
.\"	-	-	-	-	-	-	-	-
.SH "  Help actions"
.IP \fBhelp()\fP
Pops up the Help panel.
.IP \fBhelp-done()\fP
Dismisses the Help panel.
.sp
.in -\n(INu
\fBhelp-prev()\fP
.br
\fBhelp-next()\fP
.in +\n(INu
Selects the previous or next help topic, respectively.
.in
.sp
\fBhelp-up()\fP
.br
\fBhelp-down()\fP
.in +\n(INu
Scrolls the text of the current help topic up or down one page,
respectively.  This is an alternative to using the Text widget's
scrollbar.
.in
.\"	-	-	-	-	-	-	-	-
.SH "  Miscellaneous actions"
.IP \fBftp-trace-done()\fP
Dismisses the FTP Trace window. By default, this is invoked by
clicking on the "Dismiss" button in the FTP Trace window.
.\"----------------------------------------------------------
.SH " Environment Variables"
.PP
The following environment variables are used by Xarchie if they are
defined:
.PP
TMPDIR		- Directory for "Open"-ed files
.br
XAPPLRESDIR	- Directory containing Xarchie resource file
.br
USER			- Username for FTP mail address
.br
HOSTNAME		- Hostname for FTP mail address
.\"----------------------------------------------------------
.SH " Files"
.PP
Xarchie		- default Xarchie resource file
.\"----------------------------------------------------------
.SH " Diagnostics"
.PP
Xarchie indicates X errors using the ever-popular default X error
handler that prints a message and dies, possibly leaving a large core
dump somewhere.
.PP
Errors due to incorrect resource specifications cause an error message
on stderr, but do not kill Xarchie (usually).
.PP
Errors due to incorrect user commands or problems with the connection
to Archie result in a popup alert box being displayed. Clicking on the
indicated button in the alert box will make it go away and allow you
to continue.
.PP
An incorrect value for the FTP mail address (as determined from the
system information or from the USER and HOSTNAME variables) can result
in access being denied by some anonymous FTP servers. See the
description of the
.B ftpMailAddress
non-widget resource if your system has problems with this.
.PP
If you continually get "Can't resolve hostname" errors when you try to
query, then Xarchie was not built properly. Contact your local
maintainer and suggest that they read the PROBLEMS file concerning the
"resolv" library.
.PP
If your queries always time out, then there are two possibilities.
First, and by far the most likely, is that the server is simply busy.
Try again later. The other possibility is that UDP traffic is disabled
on your system. You should contact your local maintainer and ask them
to read the PROBLEMS files concerning UDP traffic.
.\"----------------------------------------------------------
.SH " Known Bugs"
.PP
Crashes have been observed when the Help text is scrolled. There is no
fix, but see the PROBLEMS file for some discussion.
.PP
The list of files in the FileChooser widgets don't seem to get
displayed properly all the time. That is, sometimes items seem to be
drawn on top of each other. Refreshing the window (eg.,
iconify/deiconify or scrolling up/down) clears it up. This seems like
an Xaw bug, but is difficult to repeat in isolation.
.PP
Your mileage may vary regarding the Xarchie icon changing to reflect
search and transfer status. Your window manager may not support
application-specified icons, or may not support them changing
dynamically. See the PROBLEMS file for some discussion.
.PP
It is not currently possible to abort during nameserver lookup.
Perhaps some day I'll get motivated to add asynchronous DNS code.
.PP
The browser has a hard-coded maximum depth, beyond which you cannot
expand directories. I don't think it will be a major problem however.
.\"----------------------------------------------------------
.SH " Reporting Bugs"
.PP
If you have any questions about Archie itself, write to
archie-l@cs.mcgill.ca. If you have questions about Prospero, write to
info-prospero@isi.edu.
.PP
If you have a problem, please read the "Known Bugs" section first,
then contact your local maintainer and/or refer to the PROBLEMS and
INSTALL files in the Xarchie distribution.
.PP
When reporting bugs, problems, suggestions or contributions, please be
sure to send them to the right place. Issues dealing with the X
interface should be sent to George Ferguson
(ferguson@cs.rochester.edu). Please be sure to include sufficient
details, including hardware, OS, compiler, version of X, and the like.
No amount of detail is too much.
.PP
Brendan Kehoe (brendan@cygnus.com) is in charge of the archie clients
and most of the network stuff underlying Xarchie, Cliff Neuman
(bcn@isi.edu) is in charge of Prospero, and Alan Emtage and Peter
Deutsch ({bajan,peterd}@bunyip.com) are in charge of the Archie
project itself.  Individual archie servers, however, are maintained
locally at each server site.
.\"===========================================================
.SH AUTHOR
.PP
George Ferguson, University of Rochester,
.br
(ferguson@cs.rochester.edu)
.PP
Original standalone
.I archie
program by Brendan Kehoe,
.br
(brendan@cs.widener.edu).
.PP
Original Prospero
.I archie
program by Clifford Neuman,
.br
(bcn@isi.edu).
.PP
.na
The
.I archie
service was conceived of and implemented by Alan Emtage
(bajan@bunyip.com), Peter Deutsch (peterd@bunyip.com)
and Bill Heelan (wheelan@bunyip.com).
