/*
 * tilde.c : Tilde expansion for filenames
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>
#include "config.h"
#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif
#include "alert.h"
extern uid_t getuid();		/* not in stdlib.h, but is in unistd.h */
extern char *getenv();

char *
tildeExpand(file)
char *file;
{
    static char filename[MAXPATHLEN];
    struct passwd *pwe;
    char *name,*home;

    /* Must start with tilde */
    if (*file != '~')
	return(file);
    /* Set default return value in case tilde expansion fails */
    strcpy(filename,file);
    /* Skip tilde */
    name = ++file;
    /* Gather name following tilde (if any) */
    while (*file != '\0' && *file != '/')
	file += 1;
    if (*file != '\0')
	*file++ = '\0';
    if (*name == '\0') {				/* ~/... */
	if ((pwe=getpwuid(getuid())) != NULL) {
	    home = pwe->pw_dir;
	} else if ((home=getenv("HOME")) == NULL) {
	    alert1("Couldn't find homedir, you should set $HOME");
	    return(filename);
	}
    } else {						/* ~user/... */
	if ((pwe=getpwnam(name)) != NULL) {
	    home = pwe->pw_dir;
	} else {
	    alert1("Couldn't find homedir for \"%s\"",name);
	    return(filename);
	}
    }
    sprintf(filename,"%s/%s",home,file);
    return(filename);
}
