/*
 * about.c : The "About xarchie" panel, with goofy display
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 *
 * If either HAVE_RANDOM or HAVE_RAND are defined (config.h), the display
 * is animated randomly, otherwise it just sits there.
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include "xarchie.h"
#include "patchlevel.h"
#include "about.xbm"
#include "config.h"

#define TIMER_LENGTH 250	/* msec */

/*
 * Functions defined here
 */
void initAboutActions();
void popupAboutPanel();
void setAboutShellState();

static void initAboutWidgets();
static void aboutAction(),aboutDoneAction();
static void timeoutProc();

/*
 * Data defined here:
 */
static Widget aboutShell;
static Widget picture;
static Window window;
static XtIntervalId timer;
static Boolean isPoppedUp;

static XtActionsRec actionTable[] = {
    { "about",		aboutAction },
    { "about-done",	aboutDoneAction },
};

static XPoint lines[3][4] = {
    { {14,36}, {14,24}, {17,27}, {17,18} },
    { {23,36}, {33,28}, {33,32}, {40,26} },
    { {25,43}, {36,43}, {33,46}, {44,46} }};
static GC gcs[2];

/*	-	-	-	-	-	-	-	-	*/

void
initAboutActions()
{
    XtAppAddActions(appContext,actionTable,XtNumber(actionTable));
}

/*ARGSUSED*/
static void
aboutAction(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    popupAboutPanel();
}

/*ARGSUSED*/
static void
aboutDoneAction(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    XtRemoveTimeOut(timer);
    isPoppedUp = False;
    XtPopdown(aboutShell);
}

/*	-	-	-	-	-	-	-	-	*/

void
popupAboutPanel()
{
    XGCValues values;
    Arg args[1];
    Pixel fg,bg;

    if (isPoppedUp) {
	XRaiseWindow(display,XtWindow(aboutShell));
	return;
    }
    if (aboutShell == NULL) {
	initAboutWidgets();
	window = XtWindow(picture);
	XtSetArg(args[0],XtNforeground,&fg);
	XtSetArg(args[1],XtNbackground,&bg);
	XtGetValues(picture,args,2);
	values.function = GXcopy;
	values.foreground = fg;
	gcs[0] = XCreateGC(display,root,GCFunction|GCForeground,&values);
	values.foreground = bg;
	gcs[1] = XCreateGC(display,root,GCFunction|GCForeground,&values);
    }
    isPoppedUp = True;
    XtPopup(aboutShell,XtGrabNone);
#if defined(HAVE_RANDOM) || defined(HAVE_RAND)
    timer = XtAppAddTimeOut(appContext,(unsigned long)TIMER_LENGTH,
			    timeoutProc,NULL);
#else
    XDrawLines(display,window,gcs[0],lines[0],4,CoordModeOrigin);
    XDrawLines(display,window,gcs[0],lines[1],4,CoordModeOrigin);
    XDrawLines(display,window,gcs[0],lines[2],4,CoordModeOrigin);
#endif
}

static void
initAboutWidgets()
{
    Pixmap bitmap;
    Widget form;
    Arg args[1];
    char buf[64];

    bitmap = XCreateBitmapFromData(display,root,(char *)about_bits,
				   about_width,about_height);
    aboutShell = XtCreatePopupShell("aboutShell",topLevelShellWidgetClass,
				    toplevel,NULL,0);
    form = XtCreateManagedWidget("aboutForm",formWidgetClass,
				 aboutShell,NULL,0);
#ifdef BETA
    sprintf(buf,"Xarchie %.2fb%d",VERSION,PATCHLEVEL);
#else
    sprintf(buf,"Xarchie %.2f.%d",VERSION,PATCHLEVEL);
#endif
    XtSetArg(args[0],XtNlabel,buf);
    (void)XtCreateManagedWidget("aboutLabel0",labelWidgetClass,form,args,1);
    (void)XtCreateManagedWidget("aboutLabel1",labelWidgetClass,form,NULL,0);
    (void)XtCreateManagedWidget("aboutLabel2",labelWidgetClass,form,NULL,0);
    XtSetArg(args[0],XtNbitmap,bitmap);
    picture = XtCreateManagedWidget("aboutLabel3",labelWidgetClass,
				    form,args,1);
    (void)XtCreateManagedWidget("aboutLabel4",labelWidgetClass,form,NULL,0);
    (void)XtCreateManagedWidget("aboutLabel5",labelWidgetClass,form,NULL,0);
    (void)XtCreateManagedWidget("aboutDoneButton",commandWidgetClass,
				form,NULL,0);
    XtRealizeWidget(aboutShell);
    (void)XSetWMProtocols(XtDisplay(aboutShell),XtWindow(aboutShell),
			  &WM_DELETE_WINDOW,1);
}

/* This will never get called unless HAVE_RANDOM or HAVE_RAND is defined. */
/*ARGSUSED*/
static void
timeoutProc(client_data,id)
XtPointer client_data;
XtIntervalId *id;
{
    int line,state;

#ifdef HAVE_RANDOM
    line = random() % 3;
    state = random() % 2;
#else
# ifdef HAVE_RAND
    line = rand() % 3;
    state = rand() % 2;
# endif
#endif
    XDrawLines(display,window,gcs[state],lines[line],4,CoordModeOrigin);
    timer = XtAppAddTimeOut(appContext,(unsigned long)TIMER_LENGTH,
			    timeoutProc,NULL);
}

void
setAboutShellState(state)
int state;
{
    if (!isPoppedUp)
	return;
    switch (state) {
	case NormalState:
	    XtMapWidget(aboutShell);
	    timer = XtAppAddTimeOut(appContext,(unsigned long)TIMER_LENGTH,
				    timeoutProc,NULL);
	    break;
	case IconicState:
	    XtRemoveTimeOut(timer);
	    XtUnmapWidget(aboutShell);
	    break;
    }
}
