/*
 * types.h : Definitions of SearchType and SortType and external defs
 *	of their resource converters and the improved Widget converter.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 21 Aug 1991.
 *
 */

#ifndef CONVERT_H
#define CONVERT_H

/* These codes correspond to Propsero key letters */
#define GfExact		'='
#define GfSubstr	'S'
#define GfSubcase	'C'
#define GfRegexp	'R'
#define GfExactSubstr	's'
#define GfExactSubcase	'c'
#define GfExactRegexp	'r'

typedef char SearchType;

#define GfRSearchType	"SearchType"
#define GfNExact	"exact"
#define GfNSubstr	"substr"
#define GfNSubcase	"subcase"
#define GfNRegexp	"regexp"
#define GfNExactSubstr	"exactSubstr"
#define GfNExactSubcase	"exactSubcase"
#define GfNExactRegexp	"exactRegexp"

/* This puke is so the bloody converters work. Argh! */
#define GfDefault	'\000'
#define GfInvdate	'\001'
typedef char SortType;

#define GfRSortType	"SortType"
#define GfNDefault	"default"
#define GfNInvdate	"invdate"

extern void initConverters();
extern Boolean cvtStringToSearchType(),cvtStringToSortType();
extern void cvtStringToWidget();

#endif /* CONVERT_H */
