/*
 * types.c : Converters for SearchType and SortType, and an improved
 *	converter for Widget that allows "NULL" to be specified.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 21 Aug 1991.
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Cardinals.h>
#include "types.h"
extern void XmuConvertStringToWidget();		/* original converter */

/*
 * Functions defined here:
 */
void initConverters();

Boolean cvtStringToSearchType(),cvtStringToSortType();
void cvtStringToWidget();

/* Straight from the Xt manual... */
#define done(VALUE,TYPE)\
{							\
    if (toVal->addr != NULL) {				\
	if (toVal->size < sizeof(TYPE)) {		\
	    toVal->size = sizeof(TYPE);			\
	    return(False);				\
	}						\
	*(TYPE *)(toVal->addr) = (VALUE);		\
    } else {						\
	static TYPE static_val;				\
	static_val = (VALUE);				\
	toVal->addr = (XtPointer)&static_val;		\
    }							\
    toVal->size = sizeof(TYPE);				\
    return(True);					\
}
							
void
initConverters(appContext)
XtAppContext appContext;
{
    static XtConvertArgRec parentCvtArgs[] = {
        {XtBaseOffset, (caddr_t)XtOffset(Widget, core.parent), sizeof(Widget)}
    };

    XtSetTypeConverter(XtRString,GfRSearchType,cvtStringToSearchType,
		       NULL,ZERO,XtCacheNone,NULL);
    XtSetTypeConverter(XtRString,GfRSortType,cvtStringToSortType,
		       NULL,ZERO,XtCacheNone,NULL);
    /* Have to initialize Form class first or our converter will be	*/
    /* overidden by the class initialization function.			*/
    /* Use the old style here on purpose since that what the default is.*/
    XtInitializeWidgetClass(formWidgetClass);
    XtAppAddConverter(appContext,XtRString,XtRWidget,cvtStringToWidget,
					parentCvtArgs,XtNumber(parentCvtArgs));
}

/* ARGSUSED */
Boolean
cvtStringToSearchType(display,args,num_args,fromVal,toVal,data)
    Display *display;
    XrmValuePtr args;		/* unused */
    Cardinal    *num_args;      /* unused */
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *data;		/* unused */
{
    char message[1000];

    LowerCase((char*)(fromVal->addr),message);
    if (strcmp(message,"exact") == 0)
	done(GfExact,SearchType);
    if (strcmp(message,"substr") == 0)
	done(GfSubstr,SearchType);
    if (strcmp(message,"subcase") == 0)
	done(GfSubcase,SearchType);
    if (strcmp(message,"regexp") == 0)
	done(GfRegexp,SearchType);
    if (strcmp(message,"exactsubstr") == 0)
	done(GfExactSubstr,SearchType);
    if (strcmp(message,"exactsubcase") == 0)
	done(GfExactSubcase,SearchType);
    if (strcmp(message,"exactregexp") == 0)
	done(GfExactRegexp,SearchType);
    XtDisplayStringConversionWarning(display,fromVal->addr,GfRSearchType);
    toVal->addr = NULL;
    toVal->size = 0;
}

/* ARGSUSED */
Boolean
cvtStringToSortType(display,args,num_args,fromVal,toVal,data)
    Display *display;
    XrmValuePtr args;		/* unused */
    Cardinal    *num_args;      /* unused */
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer *data;		/* unused */
{
    char message[1000];

    LowerCase((char*)(fromVal->addr),message);
    if (strcmp(message,"default") == 0)
	done(GfDefault,SortType);
    if (strcmp(message,"invdate") == 0)
	done(GfInvdate,SortType);
    XtDisplayStringConversionWarning(display,fromVal->addr,GfRSortType);
    toVal->addr = NULL;
    toVal->size = 0;
}

/*	-	-	-	-	-	-	-	-	*/
/*
 * cvtStringToWidget() : Allows us to specify "NULL" as a widget name in
 *	a resource file to override compiled-in defaults for composite
 *	widget layouts. Simply calls the regular converter if the string
 *	is not "NULL". Note that this must be registered *after* the
 *	Form class is initialized.
 */
void
cvtStringToWidget(args,num_args,fromVal,toVal)
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
{
    if (strcasecmp(fromVal->addr,"NULL") == 0) {
	toVal->addr = NULL;
	toVal->size = 0;
    } else {
	XmuCvtStringToWidget(args,num_args,fromVal,toVal);
    }
}
