/*
 * db.h : Definitions of the database record types, and external defs of
 *	the database functions and of the functions for displaying database
 *	entries in the browser.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 21 Aug 1991.
 *
 */

#ifndef DB_H
#define DB_H

typedef struct _FileEntry {
	char *name;
	int size;
	char modes[16];		/* drwxrwxrwx + \0 */
	char date[16];		/* "mmm dd yyyy\0" or "mmm dd hh:mm\0" */
	struct _FileEntry *next,*prev;
} FileEntry;

typedef struct _LocEntry {
	char *linkpath;
	FileEntry *fileEntries;
	struct _LocEntry *next,*prev;
} LocEntry;

typedef struct _HostEntry {
	char *hostname;
	LocEntry *locEntries;
	struct _HostEntry *next,*prev;
} HostEntry;

typedef struct _Database {
    HostEntry *hostEntries;
} Database;

extern Database *newDb();
extern void clearDb();
extern HostEntry *addHostEntry(),*lastHostEntry(),*findHostEntryFromString();
extern HostEntry *findHostEntryFromIndex();
extern LocEntry *addLocEntry(),*lastLocEntry(),*findLocEntryFromString();
extern LocEntry *findLocEntryFromIndex();
extern FileEntry *addFileEntry(),*lastFileEntry(),*findFileEntryFromString();
extern FileEntry *findFileEntryFromIndex();
extern int findHostIndexFromEntry();
extern int findLocIndexFromEntry();
extern int findFileIndexFromEntry();
extern void displayHosts(), displayLocs(), displayFiles();
extern void setHostString(), setLocString(), setFileString();
extern void setHostListFromStrings();
extern void setLocListFromStrings();
extern void setFileListFromStrings();
extern void clearList();

extern HostEntry *selectedHostEntry;
extern LocEntry *selectedLocEntry;
extern FileEntry *selectedFileEntry;

#define DB_NULL		(Database *)NULL
#define HOST_NULL	(HostEntry *)NULL
#define LOC_NULL	(LocEntry *)NULL
#define FILE_NULL	(FileEntry *)NULL

#endif /* DB_H */
