/*
 * actions.c : Widget action procedures
 *
 * This file defines the global actionTable used in XtAppAddActions() and
 * defines the action procedures, except those used on the settingsPanel
 * which are imported. Eventually there may be more actions, and they'll
 * be put here.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 21 Aug 1991.
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Cardinals.h>
#include "procquery.h"
#include "xarchie.h"
#include "types.h"
#include "appres.h"
#include "db.h"
#include "settings.h"		/* for settings actions */
#include "ftp.h"
#include "alert.h"

/*
 * Functions defined here
 */
static void quitAction(),queryAction(),ftpAction();

/*
 * Data defined here:
 */
XtActionsRec actionTable[15] = {	/* check size in actions.h! */
    { "quit",			quitAction },
    { "query",			queryAction },
    { "ftp",			ftpAction },
    { "settings",		settingsAction },
    { "apply-settings",		applySettingsAction },
    { "default-settings",	defaultSettingsAction },
    { "done-settings",		doneSettingsAction },
    { "set-search-type",	setSearchTypeAction },
    { "set-search-type-now",	setSearchTypeNowAction },
    { "set-sort-type",		setSortTypeAction },
    { "set-sort-type-now",	setSortTypeNowAction },
    { "set-host",		setHostAction },
    { "set-host-now",		setHostNowAction },
    { "set-nice-level",		setNiceLevelAction },
    { "set-nice-level-now",	setNiceLevelNowAction },
};

/*	-	-	-	-	-	-	-	-	*/

/*ARGSUSED*/
static void
quitAction(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    XtDestroyApplicationContext(appContext);
    exit(0);
}

/*ARGSUSED*/
static void
queryAction(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    Arg args[1];
    char *s;
    int len;
    Boolean gif;

    XtSetArg(args[0],XtNstring,&s);
    XtGetValues(searchText,args,ONE);
    if (*s == '\0') {
	alert0("No search term specified.");
	return;
    }
#ifndef DONT_CATCH_GIFS
    len = strlen(s);
    gif = False;
    switch (appResources.searchType) {
	case GfExact:
	    gif = ((len > 4 &&
		    (!strcmp(s+len-4,".gif") || !strcmp(s+len-4,".GIF"))) ||
		   (len > 6 &&
		    (!strcmp(s+len-6,".gif.Z") || !strcmp(s+len-6,".GIF.Z"))));
	    break;
	case GfSubstr:
	case GfExactSubstr:
	case GfSubcase:
	case GfExactSubcase:
	    gif = (sindex(s,"gif") || sindex(s,"GIF"));
	    break;
	case GfRegexp:
	case GfExactRegexp:
	    gif = (re_comp(s) == NULL &&
		   (re_exec("@PrObAbLyNoTaFiLe@.gif") ||
		    re_exec("@PrObAbLyNoTaFiLe@.gif.Z")));
	    break;
    }
    if (gif) {
	if (!confirm0("Your search term will match GIFs. Do it anyway?"))
	    return;
	else if (appResources.niceLevel <= 0 &&
		 !confirm0("Really do it without increasing niceness?"))
	    return;
    }
#endif /* DONT_CATCH_GIFS */
    if (appResources.sortType == GfInvdate)
	procquery(appResources.archieHost,s,appResources.maxHits,
		  appResources.offset,appResources.searchType,True,0);
    else
	procquery(appResources.archieHost,s,appResources.maxHits,
		  appResources.offset,appResources.searchType,False,0);
}

/*ARGSUSED*/
static void
ftpAction(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    if (selectedHostEntry == HOST_NULL || selectedLocEntry == LOC_NULL ||
	selectedFileEntry == FILE_NULL) {
	alert0("You must specify a host, location and file before invoking ftp()");
	return;
    }
    if (selectedFileEntry->modes[0] == 'd') {
	alert0("Sorry, can't fetch whole directories yet.");
	return;
    }
    ftp(selectedHostEntry->hostname,selectedLocEntry->linkpath,
	selectedFileEntry->name);
}
