#ifndef FTPObject_H
#define FTPObject_H
/* An Object subclass which provides access to remote ftpd servers. In
	its  interactive mode it manages a panel that gives a browser interface
	to the remote ftp file heirarchy similar to the Workspace browser. */

#import <objc/Object.h>
#import <appkit/Application.h>	// NXModalSession declaration
#import <ObjectList.h>		// Sorted List object declaration
#import "InspectorInfo.h"	// Defines InspectorInfo class and InspectorInfoUpdate protocol
#import "FileInspectorInfo.h"	// Defines the InspectorInfo attributes we handle
#import "ftplib.h"		// FTPInfoPtr declaration
#import <mach/cthreads.h>

@class FtpFile, MenuCell;

@interface FTPObject : Object
{
	/* Outlets to the FTP Status panel */
	id statusPanelID;	// The progress Panel
	id hostnameID;		// A TextField for the ftp hostname
	id bytesTransferredID;	// A TextField for the bytes transferred
	id percentID;		// The PercentView for the transfer status
	id msgID;			// A TextField for a status message
	id filenameID;		// A TextField for the filename
	id clockViewID;	// The ClockView for the time

	/* Outlets to the FTP log console panel */
	id logPanelID;		// The Panel object
	id ftpLogID;		// A TextConsole object

	/* General FTP session variables */
	id ftpLoginPanelID;	// A panel for the ftp login info
	id loginHostnameID;	// The hostname TextField
	id loginUsernameID;	// The username TextField
	id loginPasswdID;		// The password TextField
	id visiblePasswdID;	// The visible password Button
	id netrcStringID;		// A string displayed if fields were filled from a .netrc file

	/* Outlets used with the interactive window  */
	id ftpWindowID;	// The interactive ftp Window
	id fileBrowserID;	// The NXBrowser used to display the remote files
	id fileInfoID;		// The file info Form
	id calViewID;		// The CalendarView for the date
	id fileWellID;		// The FileWellView for diplaying the selection
	id statusMsgID;	// The status msg TextField

	/* General instance variables */
	FtpFile *rootDir;			// FtpFile object for the ftpHost's top directory
	ObjectList *orphanDirs;	// FtpFile directories that have been loaded
								//	during link resolution but don't have their
								//	parent in the rootDir heirarchy yet
	List *activePathNodes;		// The List of Files for the currently selected branch
	List *selectionList;		// The List of selected cells in the file browser
	id preferences;			// A reference to the app Prefences object
	const char *ftpHost;		// The current ftp host
	const char *loginDirectory;	// The directory at login
	const char *currentDirectory;	// The current ftp directory
	FTPInfoPtr ftpInfo;		// The info required by the ftplib.c routines
	char *localTransferDir;	// The location for depositing files
	char *currentSubDir;	// The location relative to localTransferDir for
							// 	the current sub directory retrieval
	BOOL isInteractive;	// A flag indicating if this is an interactive session
	NXModalSession *ftpSession;
	struct FileTransferInfo
	{	// File transfer information used by transfer thread
		cthread_t transferThread;	// File transfer thread
		FTPObject *ftpd;			// FTPObject sed by cthread function
		NXStream *fileStream;		// Memory stream the file is transfered to
		long bytesTransferred;		// Transfer byte count
		BOOL abort;		// Has an abort: message been sent to main thread
		BOOL done;		// Is the transfer complete
	} transferInfo;
	/*  Instance variables required by the FTPObject(Inspector) category.
		I need to create a new superclass to implement this properly. */
	id fileInspector;
	id inspectedFile;
	FileInfo *fileInfo;
	int inspectorGroup;
	DirectorySortKey *sortKey;
		// Inspector panel outlets
	id sourceNameID;
	id sourcePathID;
	id fileIconID;
	id sourceHostID;
	id localPathID;
	id sortMatrixID;

}

/*\ ------------- Initialization Methods ------------- \*/
- init;
- initForHost:(const char *) host interactive:(BOOL) interactive;
- initForGeneralLogin;
- initForGeneralLogin:(const char *) hostname;
- free;

/*\ ------------- FTP Session Methods ------------- \*/
- abort: sender;
- doLogin: sender;
- login:(const char *) hostname interactive:(BOOL) interactive;
- login:(const char *) hostname user:(const char *) username
	passwd:(const char *) passwd interactive:(BOOL) interactive;
- logout : sender;
- (NXStream *) retrieveFiles: fileList;
- setTransferDir: sender;
- setLocalTransferDir:(const char *) transferDir;
- (NXStream *) streamForCmd:(const char *) command :(const char *) arg;
- fileFromPath:(const char *) path;
- addOrphanDir:(FtpFile *) ftpDir;
- removeOrphanDir:(const char *) path;

/*\ ------------- FTP Action Methods ------------- \*/
- openInWorkspace: sender;
- retrieve: sender;
- showFTPLog: sender;
- showFTPStatus: sender;

/*\ ------------- File Delegate Methods ------------- \*/
- incSubDirPath:(const char *) newDir;
- decSubDirPath;
- (const char *) createLocalFile: theFile;

/*\ ------------- Browser Delegate Methods ------------- \*/
- (int) browser: sender getNumRowsInColumn:(int) column;
- browser: sender loadCell: cell atRow:(int) row inColumn:(int) column;
- displaySelection: sender;

/*\ ------------- Window Delegate Methods ------------- \*/
- windowWillClose: sender;

/*\ ------------- Menu Update Methods ------------- \*/
- (BOOL) validateCommand:(MenuCell *) menuCell;

@end

/*\ ------ InspectorInfo Protocol & Related Methods ------ \*/
@interface FTPObject(Inspector) <InspectorInfoUpdate>
- (BOOL) updateWithInspectorInfo:(InspectorInfo *) theInfo;
- (BOOL) getInspectorInfo: theInfo;
- inspectorIsActive: inspector;
- inspectObject: theObject msg:(const char *) theMsg;
	// InspectorManager delegate methods & panel object action methods
- groupChanged: sender to: (int) newGroup;
- inspectRevert: sender;
- inspectOK: sender;
- setSortKey: sender;
@end

/*\ ------------- FTPD Category Methods ------------- \*/
@interface Object(FTPDaemon)
- (FTPInfoPtr) ftpOpen:(const char *) hostname textConsole: ftpConsole;
- (FTPInfoPtr) ftpOpenAddress:(struct in_addr *) address
	port:(unsigned short) port textConsole: ftpConsole;
- ftpLogin:(FTPInfoPtr) info user:(char *) user passwd:(char *) passwd;
- (int) ftpSendCmd:(FTPInfoPtr) info cmd:(char *) command arg:(char *) arg;
- (int) ftpPort:(FTPInfoPtr) info;
- (int) ftpOpenDataConn:(FTPInfoPtr) info cmd:(char *) command
	arg:(char *) arg;
- (int) ftpCloseDataConn:(FTPInfoPtr) info;
- (int) ftpReadDataConn:(FTPInfoPtr) info buffer:(char *) buffer
	length:(int) length;
- ftpQuit:(FTPInfoPtr) info;
- ftpClose:(FTPInfoPtr) info;
- (int) ftpAbort:(FTPInfoPtr) info;
- (int) ftpCwd:(FTPInfoPtr) info newDir:(char *) directory;
- (const char *) ftpPwd:(FTPInfoPtr) info;
- (int) ftpType:(FTPInfoPtr) info type:(char *) type;
- (int) ftpReplyCode:(FTPInfoPtr) info;
- ftpError:(FTPInfoPtr) info;
@end

/*\ ------------- Exceptions ------------- \*/
#import "ObjectArchival.h"
enum {eRtnMemoryErr = END_ObjectArchival_EXCEPTIONS, eNoFtpHost, eCWDFailure,
	eOpenFailure, eNoListing, eNoFileEntry, eRetreiveErr, eFileMemoryErr,
	eSaveFileErr, eFTPAbort, END_FTPObject_EXCEPTIONS};

/*\ ------------ Error & Debugging Categories ------------ \*/
#import "Object_AllocNDebug.h"

/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:26 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/FTPObject.h,v $;
	$Revision: 1.1 $;
	$Log:	FTPObject.h,v $
 * Revision 1.1  94/01/08  14:40:26  me
 * Check point of 2.09a version.
 * 
 * Revision 1.3  93/03/29  01:58:44  me
 * Fixed problem that would not allow ftp transfers when we were launched as a service.  Updated to act as the file inspector delegate for the new inspector panel.
 * 
 * Revision 1.2  93/03/02  15:54:32  me
 * Added outlet for visible password button.
 * 
 * Revision 1.1  93/02/23  02:10:37  me
 * Version 2.01a of the project.
 * ;
*/

#endif	// FTPObject_H
