/*
 * xtypes.h : A few types for files that don't include X11/Intrinsic.h
 *
 * George Ferguson, ferguson@cs.rochester.edu, 29 Nov 1992.
 */

#ifndef XTYPES_H
#define XTYPES_H

#ifdef CRAY
typedef long Boolean;
#else
typedef char Boolean;
#endif

#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif
#ifndef NULL
#define NULL 0
#endif

typedef char *String;
typedef char *XtPointer;
typedef char *XtInputId;
typedef char *XtIntervalId;
typedef char XFontStruct;

#include "memory.h"

#define XtMalloc(SIZE)		malloc(SIZE)
#define XtCalloc(NUM,SIZE)	calloc(NUM,SIZE)
#define XtFree(PTR)		if (PTR) free(PTR)
#define XtNew(TYPE)		((TYPE *)malloc(sizeof(TYPE)))
#define XtNewString(STR)	(STR ? strcpy(malloc(strlen(STR)+1),STR) \
				     : NULL)
#endif
