/*
 * query.h
 *
 * George Ferguson, ferguson@cs.rochester.edu, 29 Nov 1992.
 */

extern void queryAndParse();
extern int parseArchieQueryResults(), parseStringQueryResults();
extern int handleProsperoErrors();

#define DIRECTORY_t 1
#define FILE_t 2

#define DEBUG_LEVEL 0;
#define NICE_LEVEL 10;
#define TIMEOUT 4;
#define RETRIES 3;

#include <mach/mach.h>
/*\ ---------------------------- Mach Messages ---------------------------- \*/
/* The types of queries the threads perform */
typedef enum {ArchieQuery=1, DirListingQuery} Task;
/* A simple message used to notify the appkit thread of the status of query threads */
typedef struct _StatusMsg
{
	msg_header_t h; 	// Standard Mach message header info
	msg_type_t t; 	// Standard Mach message type info
	int queryIndex;	// The index into the activeQueries list of the thread sending
					// 	the message
/* Variables used to store status() arguments */
	char format[64];
	int status1Arg;
	char status2Args[2][32];
} StatusMsg, *StatusMsgPtr;
/* The message categories => h.msg_id.  The first three indicate which of the 3
	types of status() macros sent  the message.  The last indcates that the has
	received a response to its query and can be joined. */
#define STATUS0	1
#define STATUS1	2
#define STATUS2	3
#define QUERY_DONE 4

#define status0(fmt)	msg->h.msg_id = STATUS0;\
	strncpy(msg->format, fmt, 64);\
        msg_send((msg_header_t *) msg, MSG_OPTION_NONE, 0); 

#define status1(fmt, arg)	msg->h.msg_id = STATUS1;\
	strncpy(msg->format, fmt, 64);\
	msg->status1Arg = arg;\
        msg_send((msg_header_t *) msg, MSG_OPTION_NONE, 0); 

#define status2(fmt, arg0, arg1)	msg->h.msg_id = STATUS2;\
	strncpy(msg->format, fmt, 64);\
	strncpy(msg->status2Args[0], arg0, 32);\
	strncpy(msg->status2Args[1], arg1, 32);\
        msg_send((msg_header_t *) msg, MSG_OPTION_NONE, 0)

#define done(fmt)	msg->h.msg_id = QUERY_DONE;\
	strncpy(msg->format, fmt, 64);\
        msg_send((msg_header_t *) msg, MSG_OPTION_NONE, 0); 
