/* System dependent thread state stuff */
#ifndef THREAD_STATE_H
#include <mach/thread_status.h>

#ifdef mc68000
#	define REGS_STATE M68K_THREAD_STATE_REGS
#	define REGS_STRUCT struct m68k_thread_state_regs
#	define REGS_STATE_SIZE  M68K_THREAD_STATE_REGS_COUNT
#	define PC_FIELD(state) ((state).pc)
#	define FP_FIELD(state)((state).areg[6])
#	define SP_FIELD(state)((state).areg[7])
#elif i386
#	define REGS_STATE i386_THREAD_STATE
#	define REGS_STRUCT i386_thread_state_t
#	define REGS_STATE_SIZE  i386_THREAD_STATE_COUNT
#	define PC_FIELD(state) ((state).eip)
#	define FP_FIELD(state)((state).ebp)
#	define SP_FIELD(state)((state).esp)
#elif hppa
#	define REGS_STATE HPPA_INTEGER_THREAD_STATE
#	define REGS_STRUCT hp_pa_integer_thread_state_t
#	define REGS_STATE_SIZE  HPPA_INTEGER_THREAD_STATE_COUNT
#	define PC_FIELD(state) ((state).ts_sr0)
#	define FP_FIELD(state)((state).ts_sr1)
#	define SP_FIELD(state)((state).ts_sr2)
#endif

#endif	/* THREAD_STATE_H */
