/*
 * ftplib.h : Low-level routines for opening and using ftp connections.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 29 Nov 1992.
 *
 * Based on ftplib by Amos Shapira (amoss@cs.huji.ac.il) and code
 * from Alan Emtage (bajan@bunyip.com) and RFC 959.
 *
	Modified for use with the Object(FTPDaemon) category.
	Scott Stark, stark@superc.che.udel.edu, Sat Jan 30 22:58:50 EST 1993
 */

#ifndef FTPLIB_H
#define FTPLIB_H

#include <sys/types.h>
#include <netinet/in.h>

typedef struct ftps
{
	int	socket_fd;	/* socket descriptor of control connection */
	FILE *ftpOut;		/* output FILE pointer (of CTRL connection) */
	int code;			/* code of last reply */
	struct sockaddr_in addr;  /* address of the control connection */
	int port_socket;	/* the socket created for the PORT command */
	int data_fd;		/* a data connection established */
	int transferType;	/* current transfer mode */
	int removeCR;		/* 1 if want to remove CR from ASCII files */
	id ftpConsole;		// A Text(Console) for the control connection
	BOOL connectTimedOut;	// A flag indicating if connect() should timeout
	char *replyBuffer;	// A pointer to the reply message text
} FTPInfo, *FTPInfoPtr;

# include <arpa/ftp.h>
# include <arpa/telnet.h>

/*
 * FTP reply codes, per RFC 959
 */

/* First digit */
#define FTP_REPLY_TYPE(X)	(X/100)
#define FTP_REPLY_PRELIM(X)	(FTP_REPLY_TYPE(X) == 1) /* +ve preliminary  */
#define FTP_REPLY_COMPLETE(X)	(FTP_REPLY_TYPE(X) == 2) /* +ve complete     */
#define FTP_REPLY_CONTINUE(X)	(FTP_REPLY_TYPE(X) == 3) /* +ve intermediate */
#define FTP_REPLY_TRANSIENT(X)	(FTP_REPLY_TYPE(X) == 4) /* -ve transient    */
#define FTP_REPLY_ERROR(X)	(FTP_REPLY_TYPE(X) == 5) /* -ve permanent    */
#define FTP_REPLY_OK(X)		(X < 400)
#define FTP_REPLY_ERR(X)	(X >= 400)

/* Second digit */
#define FTP_REPLY_FUNCTION(X)	((X%100)/10)
#define FTP_REPLY_SYNTAX(X)	(FTP_REPLY_FUNCTION(X) == 0) /* syntax       */
#define FTP_REPLY_INFO(X)	(FTP_REPLY_FUNCTION(X) == 1) /* information  */
#define FTP_REPLY_CONN(X)	(FTP_REPLY_FUNCTION(X) == 2) /* connections  */
#define FTP_REPLY_AUTH(X)	(FTP_REPLY_FUNCTION(X) == 3) /*authentication*/
#define FTP_REPLY_UNSPEC(X)	(FTP_REPLY_FUNCTION(X) == 4) /* unspecified  */
#define FTP_REPLY_FILE(X)	(FTP_REPLY_FUNCTION(X) == 5) /* file system  */

/* Third digit */
#define FTP_REPLY_SPECIFIC(X)	(X%10)

/* Reply Codes by Function Groups (comment text from RFC959) */
#define FTP_COMMAND_OK		200 /* Command okay. */
#define FTP_SYNTAX_ERROR	500 /* Syntax error, command unrecognized.
				       This may include errors such as
				       command line too long. */
#define FTP_PARM_SYNTAX_ERROR	501 /* Syntax error in parameters or
				       arguments. */
#define FTP_CMD_NOT_NEEDED	202 /* Command not implemented, superfluous
				       at this site. */
#define FTP_CMD_NOT_IMPL	502 /* Command not implemented. */
#define FTP_BAD_CMD_SEQ		503 /* Bad sequence of commands. */
#define FTP_CMD_PARM_NOT_IMPL	504 /* Command not implemented for that
				       parameter. */

#define FTP_RESTART_MARKER	110 /* Restart marker reply.
				       In this case, the text is exact and not
				       left to the particular implementation;
				       it must read:
				           MARK yyyy = mmmm
				       Where yyyy is User-process data stream
				       marker, and mmmm server's equivalent
				       marker (note the spaces between markers
				       and "="). */
#define FTP_SYS_STATUS		211 /* System status, or system help reply. */
#define FTP_DIR_STATUS		212 /* Directory status. */
#define FTP_FILE_STATUS		213 /* File status. */
#define FTP_HELP_MSG		214 /* Help message.
				       On how to use the server or the meaning
				       of a particular non-standard command.
				       This reply is useful only to the human
				       user. */
#define FTP_SYS_NAME		215 /* NAME system type.
				       Where NAME is an official system name
				       from the list in the Assigned Numbers
				       document. */
#define FTP_SERVICE_RDY_TIME	120 /* Service ready in nnn minutes. */
#define FTP_SERVICE_RDY_USER	220 /* Service ready for new user. */
#define FTP_SERVICE_CLOSING     221 /* Service closing control connection.
				       Logged out if appropriate. */
#define FTP_SERVICE_UNAVAILABLE	421 /* Service not available, closing control
				       connection. This may be a reply to any
				       command if the service knows it must
				       shut down. */
#define FTP_TRANSFER_STARTING	125 /* Data connection already open; transfer
				       starting. */
#define FTP_DATA_OPEN		225 /* Data connection open; no transfer in
				       progress. */
#define FTP_DATA_FAILED		425 /* Can't open data connection. */
#define FTP_DATA_CLOSE_OK	226 /* Closing data connection.
				       Requested file action successful (for
				       example, file transfer or file abort).*/
#define FTP_DATA_CLOSE_ABORT	426 /* Connection closed; transfer aborted. */
#define FTP_ENTERING_PASSIVE	227 /* Entering Passive Mode
				       (h1,h2,h3,h4,p1,p2). */

#define FTP_LOGIN_OK		230 /* User logged in, proceed. */
#define FTP_LOGIN_ERR		530 /* Not logged in. */
#define FTP_LOGIN_NEED_PASSWD	331 /* User name okay, need password. */
#define FTP_LOGIN_NEED_ACCT	332 /* Need account for login. */
#define FTP_FILE_NEED_ACCT	532 /* Need account for storing files. */

#define FTP_DATACONN_OPEN	150 /* File status okay; about to open data
				       connection. */
#define FTP_FILE_ACTION_OK	250 /* Requested file action okay, completed.*/
#define FTP_PATHNAME_CREATED	257 /* "PATHNAME" created. */
#define FTP_FILE_ACTION_PENDING	350 /* Requested file action pending further
				       information. */
#define FTP_FILE_UNAVAILABLE	450 /* Requested file action not taken.
				       File unavailable (e.g., file busy). */
#define FTP_ACTION_NOT_TAKEN	550 /* Requested action not taken.
				       File unavailable (e.g., file not found,
				       no access). */
#define FTP_ABORTED_LOCAL_ERR	451 /* Requested action aborted. Local error
				       in processing. */
#define FTP_ABORTED_PAGE_TYPE	551 /* Requested action aborted. Page type
				       unknown. */
#define FTP_INSUFFICIENT_SPACE	452 /* Requested action not taken.
				       Insufficient storage space in system.*/
#define FTP_EXCEEDED_ALLOCATION	552 /* Requested file action aborted.
				       Exceeded storage allocation (for
				       current directory or dataset). */
#define FTP_BAD_FILENAME	553 /* Requested action not taken.
				       File name not allowed. */

#endif FTPLIB_H
