{\rtf0\ansi{\fonttbl\f0\fswiss Helvetica;\f1\fmodern Courier;}
\paperw11440
\paperh9000
\margl120
\margr120
{\colortbl;\red0\green0\blue0;}
\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\f0\b0\i\ulnone\fs24\fc1\cf1 /* This is a category that implements the method necessary to interact with\
	the InspectorManager panel used to view and set the attributes of File\
	objects.  Currently this functionality is duplicated by both the FTPObject(Inspector)\
	and Query(Inspector) categories.  The categories require that the instance\
	variables accessed by the methods defined here be defined by the FTPObject\
	and Query classes.  The correct thing to due is to create a new Inspector class\
	that defines the instance variables and methods here and to make FTPObject\
	and Query sublasses of Inspector -- A future task. */
\b\i0 \

\fc0\cf0 #import <appkit/appkit.h>\

\fc1\cf1 #import "Query.h"
\b0\i\fs28 \

\b\i0\fs24\fc0\cf0 #import "FileWellView.h"\
#import "InspectorManager.h"\
#import "MyBrowserCell.h"\
#import "ObjectList.h"\

\pard\tx480\tx960\tx1440\tx1920\tx2400\tx2880\tx3360\tx3840\tx4320\tx4800\fc0\cf0 #import "
\fc1\cf1 PVlink
\fc0\cf0 .h"\

\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\b0\i\fs28\fc1\cf1 \
/*\\ ---------------------- InspectorInfo Protocol & Related Methods ---------------------- \\*/
\b\i0\fs24\fc0\cf0 \
@implementation Query(Inspector)\
\
- (BOOL) updateWithInspectorInfo:(InspectorInfo *) theInfo\
\{\

\pard\tx480\tx960\tx1440\tx1920\tx2400\tx2880\tx3360\tx3840\tx4320\tx4800\fc0\cf0 const char *infoName;\
\
	
\b0\i /* Verify the information type and make sure we have this info */
\b\i0 \
	infoName = [theInfo infoName];\
	if( strcmp(infoName, [fileInfo infoName]) != 0 && \
		strcmp(infoName, [sortKey infoName]) != 0 )\
		return NO;\
	\
	switch( [theInfo infoCode] )\
	\{\
		case eDirectorySortKey:\
			[sortKey takeValueFrom: theInfo];\

\fc1\cf1 			bre
\fc0\cf0 ak;\
		case eFileInfo:\
			[fileInfo takeValueFrom: theInfo];\
			break;\
		default:\
			return NO;\
			break;\
	\}\

\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\b0\i\fc0\cf0 	/* Update the inspector */
\b\i0 \

\fc1\cf1 	[self inspectObject: inspectedFile msg: NULL];\

\pard\tx480\tx960\tx1440\tx1920\tx2400\tx2880\tx3360\tx3840\tx4320\tx4800\fc0\cf0 \
	return YES;\

\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\fc0\cf0 \} 
\b0\i // End updateWithInspectorInfo:
\b\i0 \
\

\pard\tx480\tx960\tx1440\tx1920\tx2400\tx2880\tx3360\tx3840\tx4320\tx4800\fc0\cf0 - (BOOL) getInspectorInfo: theInfo\
\{\
const char *infoName;\
\
	
\b0\i /* Verify the information type and make sure we have this info */
\b\i0 \
	infoName = [theInfo infoName];\
	if( strcmp(infoName, [fileInfo infoName]) != 0 && \
		strcmp(infoName, [sortKey infoName]) != 0 )\
		return NO;\
	switch( [theInfo infoCode] )\
	\{\
		case eDirectorySortKey:\
			[theInfo takeValueFrom: sortKey];\
			break;\
		case eFileInfo:\
			[theInfo takeValueFrom: fileInfo];\
			break;\
		default:\
			return NO;\
			break;\
	\}\
\
	return YES;\
\} 
\b0\i // End getInspectorInfo:\

\b\i0 \

\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\fc0\cf0 - inspectorIsActive: inspector\
\{\

\pard\tx180\tx360\tx540\tx720\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\f1\b0\i\fc1\cf1 /* --- MethodDescription\
	
\i0\ul ReturnValue:
\i\ulnone  self;\
	
\i0\ul Description:
\i\ulnone  This method updates our fileInspector instance variable\
		to that given by the inspector argument.  A nil inspector indicates\
		that the inspector is either closed or we are no longer the inspector\
		panel delegate. If inspector is not nil, this method sets the inspector\
		panel outlet variables using the object names defined in FileInspectorInfo.h\
		and the NXGetNamedObject() function.;\
	
\i0\ul Args:
\i\ulnone \
		inspector: The InspectorManager object to use as the fileInspector;\
*/\

\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\f0\b\i0\fc0\cf0 PVlink *theFile;\
id attributesWindow, contentsWindow, inspectorPanel;\
id attributesBoxID, contentsBoxID;\
\
	fileInspector = inspector;\
	if( fileInspector != nil )\
	\{	
\b0\i /* Set the inspector panel outlets and targets */
\b\i0 \
		attributesWindow = NXGetNamedObject(ATTRIBUTES_WINDOW, NXApp);\
		contentsWindow = NXGetNamedObject(CONTENTS_WINDOW, NXApp);\
		attributesBoxID = NXGetNamedObject(FILE_INFO_BOXVIEW, attributesWindow);\
		contentsBoxID = NXGetNamedObject(DIR_SORT_BOXVIEW, contentsWindow);\
		inspectorPanel = [fileInspector panel];\
		sourceNameID = NXGetNamedObject(SOURCE_FILENAME_FIELD, inspectorPanel);\
		sourcePathID = NXGetNamedObject(SOURCE_PATH_FIELD, inspectorPanel);\
		fileIconID = NXGetNamedObject(FILE_ICON_VIEW, inspectorPanel);\
		sourceHostID = NXGetNamedObject(SOURCE_HOST_FIELD, attributesBoxID);\
		localPathID = NXGetNamedObject(LOCAL_FILENAME_FIELD, attributesBoxID);\
		sortMatrixID = NXGetNamedObject(DIR_SORT_MATRIX, contentsBoxID);\
\
		inspectorGroup = [fileInspector group];\
		if( inspectorGroup < eAttributesGroup )\
			inspectorGroup = eAttributesGroup;\
		[inspector switchToInspector: (inspectorGroup + FIRSTADDEDINSPECTOR)];\
		
\b0\i /* Update the inspector */
\b\i0 \
		
\fc1\cf1 if( [selectionList count] > 1 )	
\b0\i // Multiple selction display
\b\i0 \
			[self inspectObject: nil msg: "Multiple Selection"];\
		else if( [selectionList count] == 1 )\
		\{\
			theFile = [(MyBrowserCell *)[selectionList objectAt: 0] tag];\
			[self inspectObject: theFile msg: "File Object"];\
		\}
\fc0\cf0 \
	\}\
\
	return self;\
\} 
\b0\i // End inspectorIsActive:
\b\i0 \
\
- inspectObject: theObject msg:(const char *) theMsg\
\{\
static BOOL lastFileWasDir;\
\
	if( fileInspector == nil )\
		return nil;\
	else if( theObject == nil )\
	\{\
		[sourceNameID setStringValue: NULL];\
		[sourcePathID setStringValue: NULL];\
		[fileInspector showMessage: theMsg];\
		if( strcmp(theMsg, "Multiple Selection") == 0 )\
			[fileIconID showImage: eMultipleSelection];\
		else\
			[fileIconID clear];\
		return nil;\
	\}\
\
	[theObject getInspectorInfo: fileInfo];\
	[theObject getInspectorInfo: sortKey];\
	/* All inspector goups display the following three items */\
	[sourceNameID setStringValue: [theObject sourceName]];\
	[sourcePathID setStringValue: [fileInfo sourcePath]];\
	switch( [fileInfo type] )\
	\{\
		case eRegularFile:\
		case eLinkFile:\
			[fileIconID showImage: eDocumentSelection];\
			break;\
		case eDirectoryFile:\
			[fileIconID showImage: eFolderSelection];\
			break;\
	\}\
\
	if( inspectorGroup == eAttributesGroup )\
	\{\
	const char *localPath;\
		[sourceHostID setStringValue: [fileInfo sourceHost]];\
		localPath = [fileInfo localPath];\
		if( localPath == NULL )\
			[localPathID setStringValue: "No local path"];\
		else\
			[localPathID setStringValue: localPath];\
	\}\
	else if( inspectorGroup == eContentsGroup )\
	\{\
		if( [theObject isDirectory] == YES )\
		\{\
			if( lastFileWasDir == NO )\
				[fileInspector switchToInspector:\
					(eContentsGroup + FIRSTADDEDINSPECTOR)];\
			[sortMatrixID selectCellAt: [sortKey sortKey] : 0];\
			lastFileWasDir = YES;\
		\}\
		else\
		\{\
			[fileInspector showMessage: "Damned if I know"];\
			lastFileWasDir = NO;\
		\}\
	\}\
	inspectedFile = theObject;\
\
	return self;\
\} 
\b0\i // End inspectObject:
\b\i0 \
\
/*\\ ---------------- InspectorManager Delegate Methods ---------------- \\*/\
- groupChanged: sender to: (int) newGroup\
\{\
/* --- MethodDescription\
	ReturnValue: self;\
	Description: This method is invoked by our inspectorMgr object when the\
		user selects a new preferences group via the popup menu in the\
		InspectorManager panel(Inspector.nib).\
\
		If our resetPrefPanel variable is nonzero, it indicates that\
		preferences view for which it has bits set should be reset to\
		reflect the current prefs vales.;\
	Args: \
		sender: The save button in the InspectorPanel(Inspector.nib);\
*/\
	if( newGroup != inspectorGroup )\
	\{\
		inspectorGroup = newGroup;\
		[sender switchToInspector: (newGroup + FIRSTADDEDINSPECTOR)];\
		[self inspectObject: inspectedFile msg: NULL];\
	\}\
\
	return self;\
\} // End groupChangedTo\
\
- inspectRevert: sender\
\{\
/* --- MethodDescription\
	ReturnValue: self;\
	Description: This method is invoked by our instpectorMgr object when the\
		user selects the restore button in the preferences panel.  We hand off\
		the job of updating the default values to -restoreDefaults:;\
	Args: \
		sender: The restore button in the InspectorPanel(Inspector.nib);\
*/\
\
	return self;\
\} // End inspectRevert\
\
- inspectOK: sender \
\{\
/* --- MethodDescription\
	ReturnValue: self;\
	Description: This method is invoked by our instpectorMgr object when the\
		user selects the save button in the preferences panel.  We hand off\
		the job of updating the default values to -saveDefaults:;\
	Args: \
		sender: The save button in the InspectorPanel(Inspector.nib);\
*/\
	if( inspectorGroup == eContentsGroup )\
		[inspectedFile updateWithInspectorInfo: sortKey];\
\
	return self;\
\}\
\
- setSortKey: sender\
\{\
/* --- MethodDescription\
	ReturnValue: self;\
	Description: This method is the action method of the sort matrix of the contents\
		inspector panel.;\
	Args: ArgList_Description;\
*/\
SortKeyEnum key;\
\
	key = [sender selectedRow];\
	[sortKey setValue: key];\
	if( [inspectedFile updateWithInspectorInfo: sortKey] == YES )\
	\{	/* The directory changed its sort key, reload browser column\
			representing the directory contents */\
		[fileBrow
\fc1\cf1 serID reloadColumn: [fileBrowserID lastColumn]];\

\fc0\cf0 	\}\
\
	return self;\
\}
\b0\i  // End setSortKey:\

\b\i0 \
@end\
/* RCS Information:\
	$Author: me $;\
	$Date: 94/01/08 14:41:14 $;\
	$Source: /usr1/me/NeXTSrc/Archie/RCS/Query_Inspector.m,v $;\
	$Revision: 1.1 $;\
	$Log:	Query_Inspector.m,v $
Revision 1.1  94/01/08  14:41:14  me
Check point of 2.09a version.
Revision 1.1  93/03/29  02:04:43  meUpdated to act as the file inspector delegate.;\
*/\

}
