/* A subclass of Responder which initiates an archie query and provides access to
	objects and files that result from the query.  */
#ifndef QUERY_H
#define QUERY_H
#import <appkit/Responder.h>
#import <objc/HashTable.h>
#import <pfs.h>		// Defines the VLINK type
#import <mach/cthreads.h>
#import <dpsclient/dpsclient.h>
#import <ObjectArchival.h>
#import "InspectorInfo.h"		// Defines InspectorInfo class and InspectorInfoUpdate protocol
#import "FileInspectorInfo.h"		// Defines the InspectorInfo attributes we handle

@class PVlink, NXBrowser;

/*\ ---------------------------- Mach Messages ---------------------------- \*/
/* The types of queries the threads perform */
typedef enum {ArchieQuery=1, DirListingQuery} Task;
/* A simple message used to notify the appkit thread of the status of query threads */
typedef struct _StatusMsg
{
	msg_header_t h;	//  Standard Mach message header info
	msg_type_t t;	//  Standard Mach message type info
	int queryIndex;	// The index into the activeQueries list of the thread sending
					// the message
/* Variables used to store status() arguments */
	char format[64];
	int status1Arg;
	char status2Args[2][32];
} StatusMsg, *StatusMsgPtr;
/* The message categories => h.msg_id.  The first three indicate which of the 3
	types of status() macros sent  the message.  The last indcates that the
	query thread has received a response and can be joined. */
#define STATUS0	1
#define STATUS1	2
#define STATUS2	3
#define QUERY_DONE 4

/*\ ------------------------------- Thread Related Defs ------------------------------- \*/
typedef struct _ArchieInfo
{	/* The info required by ArchieQuery thread tasks */
	int maxReplies;
	char type;
} ArchieInfo;

typedef struct _DListInfo
{	/* The info required by DirListingQuery thread tasks */
	id dirVLINK;
	id browser;
	int column;
	char *selection;
} DListInfo;
typedef	union _Info
{	/* A union of the info required by the two types of queries */
	ArchieInfo archie;
	DListInfo dlist;
} Info, *InfoPtr;

/* The argument passed to the query thread procs */
typedef struct _QueryArgs
{
/* Items common to both ArchieQuery & DirListingQuery tasks */
	cthread_t cthread;	// The thread that performs the archie query
	Task type;			// The type of task thread, ArchieQuery or DirListingQuery
	int status;			// Status of query thread
	port_t port;			// The port the thread sends status messages to
	VLINK links;		// The VLINK resulting from the query
	const char *hostname;	// The host arg to archieQuery() & stringQuery()
	const char *string;		// The string to match
	int (*cmp)(VLINK, VLINK);	// The comparison func for sorting of links
	int flags;
	StatusMsg msg;	// The Mach message struct for this thread
	int menuTag;		// The tag for the "Queries" menu item for the query
	int abortPipe[2];	// A pipe used to abort a query thread inside select()
	id self;			// A reference to the Query object that started the thread
/* Task specific info, ArchieQuery or DirListingQuery */
	Info info;
} QueryArgs, *QueryArgsPtr;


@interface Query : Responder <ObjectArchival>
{
	/* Instance variables that allow access to the relevant
		objects in the ArchieSession window */
	id  mainWindowID;	// The main window
	id fileBrowserID;	// The Browser which display the server responses
	id queryFieldID;		// The query TextField
	id fileInfoID;		// File info Form
	id readMatrixID;		// Permission matrices
	id writeMatrixID;
	id execMatrixID;
	id calendarID;		// The Views which display date & time info
	id clockID;
	id selectionViewID;	// The FileWellView object
	id msgFieldID;		// The msg TextField in the interface

	/* Archie query panel outlets & variables */
	id queryPanelID;	// The Panel diplayed during server queries
	id hostnameID;		// Hostname TextFieldCell
	id statusID;			// Status TextFieldCell
	id queryTimerID;	// A ClockView object to display query status
	id abortID;			// The abort button
	BOOL abortEnabled;	// A flag indicating if the ``Abort'' button is
							// enabled during an ArchieQuery task

	/* Query thread instance variables */
	id activeQueries;		// A Storage object of QueryArgs, one for each active query
	BOOL activeArchieQuery;	// Are we already querying the server?
	BOOL activeDirQueries;	// Are dir listings being requested?
	port_t statusPort;		// The port we receive status messages on

	/* File browser related instance variables */
	id hostHashTable;	// A HashTable that uses hostnames as entry keys
	id hostnames;		// A Storage list which maintains the query results hostnames
	id selectedFile;		// The PVlink object of the file selected in the browser
	id selectionList;		// A List of the PVlinks selected in the browser
	id delegate;			// The ArchieSession responsible for the query window
	char *queryString;	// The string in the query field when this instance was created 
	int matchCount;		// The number of matches returned by the server
	char *localTransferDir;

	/* References to application objects */
	id errStringTable;	// The application NXStringTable for error messages
	id preferences;		// The application Preferences object
	id ftpServer;		// The application FTPObject

	/*  Instance variables required by the Query(Inspector) category.
		I need to create a new superclass to implement this properly. */
	id fileInspector;
	id inspectedFile;
	FileInfo *fileInfo;
	int inspectorGroup;
	DirectorySortKey *sortKey;
		// Inspector panel outlets
	id sourceNameID;
	id sourcePathID;
	id fileIconID;
	id sourceHostID;
	id localPathID;
	id sortMatrixID;
}

/*\ -------------------------------- Initialization Methods -------------------------------- \*/
+ queriesMenu;
+ (int) newMenuTag;
- init;
- setDelegate: session;

/*\ ---------------------------------- Query Methods ---------------------------------- \*/
- performRequest:(const char *) host query:(const char *) string maxRep:(int) limit
	queryType:(char) type sortProc:(int (*)(VLINK,VLINK)) cmp
	queryFlags:(int) flags;
- newQueryThread:(Task) type host:(const char *) host
	string:(const char *) string cmp:(int (*)(VLINK, VLINK)) cmp
	flags:(int) flags info:(InfoPtr) info tag:(int) menuTag;
- newStatusPort;
- interruptRequest: sender;
- (BOOL) queriesAreActive;

/*\ -------------- Parsing & Displaying Archie Server Responses -------------- \*/
- parseResponse:(VLINK) links;
- fileAttributes: sender;
- loadEntries:(PVlink *) link for:(NXBrowser *) browser
	inColumn:(int) column;
- selectionList;
- selectedFile;
- (int) matchCount;
- (const char *) queryString;

/*\ ---------------------- Delegate Methods ---------------------- \*/
- (int)browser: sender  fillMatrix: matrix inColumn:(int) column;
- (NXStream *) provideSrcData:(NXAtom) type;

/*\ ---------------------- FTP Action Methods ---------------------- \*/
- connect: sender;
- retrieve: sender;
- openInWorkspace: sender;
- setTransferDir: sender;
- showFTPLog: sender;

/*\ ---------------------------- ObjectArchival Methods ---------------------------- \*/
/* The current version for new documents */
#define QUERY_VERS		1	// Object release version
#define QUERY_SUBVERS	0	// Object subrelease version
#define QUERY_TYPE		0	// Object version type
/* Object versions we know about */
#define QUERY_VERSION_0 1000

- initFromTStream:(NXTypedStream *) stream;
- readFromTStream:(NXTypedStream *) stream;
- writeToTStream:(NXTypedStream *) stream;

/*\ ---------------------- Pasteboard Methods ---------------------- \*/
#import <objc/hashtable.h>
- copyTo: (NXStream *) pbData type:(const NXAtom) type;

@end

/*\ ---------------------- InspectorInfo Protocol & Related Methods ---------------------- \*/
@interface Query(Inspector) <InspectorInfoUpdate>
- (BOOL) updateWithInspectorInfo:(InspectorInfo *) theInfo;
- (BOOL) getInspectorInfo: theInfo;
- inspectorIsActive: inspector;
- inspectObject: theObject msg:(const char *) theMsg;
	// InspectorManager delegate methods & panel object action methods
- groupChanged: sender to: (int) newGroup;
- inspectRevert: sender;
- inspectOK: sender;
- setSortKey: sender;
@end

/*\ ---------------------------- Error & Debugging Methods ---------------------------- \*/
#import "errMessages.keys"
#import "Object_AllocNDebug.h"

/*\ ---------------------------------- Constants ---------------------------------- \*/
#define QUERY_MENU_CELL_TAG 4

#endif // QUERY_H
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:41:08 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/Query.h,v $;
	$Revision: 1.1 $;
	$Log:	Query.h,v $
 * Revision 1.1  94/01/08  14:41:08  me
 * Check point of 2.09a version.
 * 
 * Revision 1.2  93/03/29  02:04:23  me
 * Updated to act as the file inspector delegate.
 * 
 * Revision 1.1  93/02/23  02:11:47  me
 * Version 2.01a of the project.
 * ;
*/
