/* Preferences is a subclass Object which maintains the app preference
	info and displays the various preference interface through the
	use of an InspectorManager object. */
#ifndef PREFERENCES_H
#define PREFERENCES_H
#import <objc/Object.h>
#import <sys/param.h>

@class Sound;

@interface Preferences : Object
{
	/* The InspectorManager object */
	id inspectorMgr;

	/* The inspector groups numbers */
	unsigned int generalPrefsGrp;
	unsigned int archiePrefsGrp;
	unsigned int queryPrefsGrp;
	unsigned int ftpPrefsGrp;

	/* General preferences outlets */
	id showQueryID;	// Show new queries object
	id useAudioID;		// Use audio notification object
	id newWindowID;	// Display untitled first window object
	id debugEnableID;	// Should debug:method:... messages be logged object
	id generalBoxID;	// Box view containing above objects
	id audioFormID;	// Form of sound names

	/* Archie preferences outlets */
	id hostBrowserID;	// Hostname object
	id customHostID;	// TextField for the custom hostname
	id customTitleID;	// TextField title for the custom host field
	id sortMatrixID;	// Sort method object
	id patternMatrixID;	// Pattern matching object
	id exactBtnID;		// Exact match flag object
	id hitsFormID;		// Max hits object
	id niceMatrixID;	// Niceness object
	id archieBoxID;		// Box view containing above objects
	/* Archie prefs related variables */
	int (*cmpProc)();	// The query reply sort routine

	/* Query preferences outlets */
	id modalArchieQueryID;	// Run modal status flag
	id modalDirQueryID;	// Run modal status flag
	id serverTimeoutID;	// Server timeout (secs) field
	id serverRetriesID;	// Server retry count field
	id maxThreadsID;	// Max # of concurrent dir query threads allowed
	id queryBoxID;		// Box view containing above objects

	/* FTP preferences outlets */
	id retrieveSubDirsID;	// Recursive subdir retrieval flag
	id collisionWarnID;	// File name collision warning flag
	id transferPriorityID;	// File transfer priority slider
	id fileBrowserID;		// Browser of files that can be opened in Workspace
	id fileExtID;		// TextField for adding file types
	id removeID;		// File type remove Button
	id addID;			// File type add Button
	id maxFileSizeID;	// Maximum file size(K) to open without warning
	id prefixCaseID;	// Case sensitive file prefixes flag
	id suffixCaseID;	// Case sensitive file suffixes flag
	id anonPasswdID;	// The anonymous login password TextField
	id transferDirID;	// The local transfer directory TextField
	id ftpBoxID;		// Box view containing above objects
	// FTP file types variables
	char **fileTypeArray;	// An array of file type patterns
	int arraySize;			// The allocated size of the array
	int arrayCount;			// The number of array element used

	struct _PrefValues
	{
		// General
		BOOL showNewQueries;
		BOOL audioNotification;
		BOOL untitledFirstWindow;
		BOOL debuggingEnabled;
		Sound *sounds[3];
		int appDebugLevel;
		// Archie
		const char *serverHost;
		char customHost[MAXHOSTNAMELEN];
		BOOL isCustomHost;
		char queryType;
		int maxReplies;
		int sortFlag;
		BOOL exactMode;
		int niceLevel;
		// Query
		BOOL modalArchieQueries;
		BOOL modalDirQueries;
		int serverTimeout;
		int serverRetries;
		int maxThreadCount;
		int debugLevel;
		// FTP
		int maxFileSize;
		BOOL prefixCaseSensitive;
		BOOL suffixCaseSensitive;
		BOOL retrieveSubDirs;
		BOOL collisionWarnings;
		int transferPriority;
		const char *anonPasswd;	// The anonymous login password
		const char *transferDir;
		const char *fileTypeList;
	} prefs, oldPrefs;

	int resetPrefPanel;	// Is the panel display out of sync with values?
}


/*\ ---------------------- Class Methods ---------------------- \*/
+ (const char *) notificationDefault:(int) type;

/*\ ---------------------- Initialization Methods ---------------------- \*/
- init;

/*\ ---------------------- Display Methods ---------------------- \*/
- display;

/*\ ---------------------- Preference Access Methods ---------------------- \*/
/* Archie prefs values */
- (const char *) serverHost;
- (char) queryType;
- (int) maxReplies;
- (int) sortFlag;
- (int) niceLevel;
- (BOOL) exactMode;
- (int (*)()) cmpProc;

/* Query prefs values */
- (BOOL) modalArchieQueries;
- (BOOL) modalDirQueries;
- (int) serverTimeout; 
- (int) serverRetries;
- (int) maxThreadCount;

/* FTP prefs values */
- (BOOL) retrieveSubDirs;
- (BOOL) collisionWarnings;
- (BOOL) prefixCaseSensitive;
- (BOOL) suffixCaseSensitive;
- (int) maxFileSize;
- (int) transferPriority;
- (const char *) anonPasswd;
- (const char *) transferDir;
- (BOOL) canOpenFileType:(const char *) ext;

/* General prefs values */
- (BOOL) showNewQueries;
- (BOOL) audioNotification;
- (BOOL) untitledFirstWindow;
- (BOOL) debuggingEnabled;
- (const char *) sndName:(int) type;
- notificationSnd:(int) type;

/*\ ------------------- Preference Interface Actions ------------------- \*/
/* General prefs methods */
- setShowNewQueries: sender;
- setAudioNotification: sender;
- setUntitledFirstWindow: sender;
- setDebuggingEnabled: sender;
- setNotificationSnd: sender;
- setNotificationDefaults: sender;

/* Archie prefs methods */
- setQueryType: sender;
- setExactMode: sender;
- setMaxReplies: sender;
- setSortType: sender;
- setNiceLevel: sender;
- setHostname: sender;
- setCustomHost: sender;
- setDebugLevel: sender;

/* Query prefs methods */
- setModalAQueries: sender;
- setModalDQueries: sender;
- setServerTimeout: sender;
- setServerRetries: sender;
- setMaxThreadCount: sender;

/* FTP prefs methods */
- setRetrieveSubDirs: sender;
- setPrefixCaseSensitive: sender;
- setSuffixCaseSensitive: sender;
- setTransferPriority: sender;
- setMaxFileSize: sender;
- setCollisionWarnings: sender;
- addFileType: sender;
- removeFileType: sender;
- setAnonLogin: sender;
- setTransferDir: sender;

/*\ -------------------- Browser Delegate Methods -------------------- \*/
- (int) browser: sender fillMatrix: matrix inColumn:(int) column;
- (int) loadFileTypes: sender fillMatrix: matrix inColumn:(int) column;
- (int) loadArchieServers: sender fillMatrix: matrix inColumn:(int) column;

/*\ ---------------- InspectorManager Delegate Methods ---------------- \*/
- groupChanged: sender to:(int) newGroup;
- inspectRevert: sender;
- inspectOK: sender;

@end

/*\ ---------------------- Defaults Category ---------------------- \*/
@interface Preferences(Defaults)
+ initialize;
- loadDefaults;
- saveDefaults: sender;
- restoreDefaults: sender;
@end

/*\ -------------------- Error & Debugging Categories -------------------- \*/
#import "errMessages.keys"
#import "appMessages.keys"
#import "Object_AllocNDebug.h"

/*\ ---------------------- Constants ---------------------- \*/
#define GENERAL_PREFS_BIT	1
#define ARCHIE_PREFS_BIT	2
#define QUERY_PREFS_BIT		4
#define FTP_PREFS_BIT		8
#define ALL_PREFS_BITS		15

/* Sound notificaton type eunds */
enum {DirLoaded, QueryReceived, FTPTransfer};

#endif
