/* A subclass of the File class which holds the Prospero VLINK
	info returned by the archie_query() procedure */
#import "File.h"
#import <pfs.h>	// Prospero defines, structs

@class ObjectList;

@interface PVlink : File
{
	/* The Archie pseudo-directory info of the original VLINK */
	char *vlinkHostname;
	char *vlinkFilename;
}

/*\ ---------------- Initialization Methods ---------------- \*/
- initVLINK:(VLINK) v;
- setListing:(VLINK) entries;

/*\ -------------------- Info Methods -------------------- \*/
- (const char *) vlinkHostname;
- (const char *) vlinkFilename;
- writeInfo:(NXStream *) stream;


/*\ ---------------------- ObjectArchival Methods ---------------------- \*/
#define VLINK_VERS		1	// Object release version
#define VLINK_SUBVERS	1	// Object subrelease version
#define VLINK_TYPE		0	// Object version type
/* Object versions we know about */
#define VLINK_VERSION_0 1000
#define VLINK_VERSION_1 1010

- readFromTStream:(NXTypedStream *) stream;	// Override
- writeToTStream:(NXTypedStream *) stream;	// Override

@end

/*\ ---------------------- Constants ---------------------- \*/
/* struct pattrib name attributes. I could not find these in
	the prospero includes so they are subject to becoming
	invalid. */
#define SIZE	"SIZE"
#define MODES	"UNIX-MODES"
#define DATE	"LAST-MODIFIED"

/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:41:02 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/PVlink.h,v $;
	$Revision: 1.1 $;
*/
