// ObjectError.h
// 
// Original class by:
// Bill Bumgarner, Andrew Stone, Mike Morton, and Julie Zalenski
//
// A class that poses as object and does crash-reporting.
// Catches terminating signals (ie seg faults, bus errors)
// and fatal Objective-C runtime errors and writes a backtrace 
// out to the console using some shady hacks.  This could be modified
// to write backtrace to a file, mail message, etc... if desired.
//
// Modified by Ivo Rothschild (ivo@hasc.ca) to try to continue
//			when muddling on.
//
// Use at own Risk (so sayeth the authors).
//
// NO WARRANTY:
// ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE 
// IS HEREBY DISCLAIMED.  IN NO EVENT WILL THE AFOREMENTIONED PARTIES BE LIABLE 
// FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OF OR INABILITY TO USE THIS CODE.
//

#import <objc/Object.h>

@interface ObjectError:Object
{
	// No Ivars
}

+ setup;
+ setMuddleOn:(BOOL)flag;
+ setSignalHandler:(void (*)())handler;
+ resumeHandlingCrashes;
+ stopHandlingCrashes;
+ printFunctionFromFP:(void *)framePointer;
+ printMethodFromFP:(void *)framePointer;
+ printBacktrace;
+ dumpBacktrace:(const char *)message;

- error:(const char *)aString, ...;
+ error:(const char *)aString, ...;

+ tryToContinue;

@end
