#ifndef NetrcEntry_H
#define NetrcEntry_H
#import <objc/Object.h>
#import "ObjectList.h"

/* An object used to hold the information from the fields
	of a .netrc file */

@interface NetrcEntry : Object
{
	char *hostname;	// machine entry
	char *username;	// login entry
	char *passwd;		// password entry
	BOOL isDotEntry;	// Was this constructed from user's ~/.netrc?
}

/*\ ------ Class Methods ------ \*/
+ initialize;
+ parseNetrcFile:(FILE *) netrcFile fromDotFile:(BOOL) flag;
+ saveNetrcEntries;
+ (BOOL) needToSaveEntries;
+ setNeedToSaveEntries:(BOOL) flag;
+ (ObjectList *) userNetrcEntries;
+ (NetrcEntry *) findNetrcInfo:(const char *) hostname;
+ (BOOL) addEntry:(NetrcEntry *) entry;
+ (BOOL) removeEntry:(NetrcEntry *) entry;

/*\ ------ Initialization Methods ------ \*/
- init:(const char *) machine login:(const char *) login
	passwd:(const char *) password setDotEntry:(BOOL) flag;
- update:(const char *) machine login:(const char *) login
	passwd:(const char *) password;
- setHostname:(const char *) machine;
- setLogin:(const char *) login;
- setPasswd:(const char *) password;
- free;

/*\ ------ Information Methods ------ \*/
- (const char *) hostname;
- (const char *) username;
- (const char *) passwd;
- (const char *) displayName;
- (BOOL) isDotEntry;

// Override SortableObject category compare:typeID:size:keyMethod
- (int) compare: anObject typeID:(int) typeID
	size:(int) size keyMethod:(SEL) keyMethod;

@end

#endif	// NetrcEntry_H
