#import "Text_Console.h"
#import "Object_AllocNDebug.h"
#import <stdarg.h>

@implementation Text(Text_Console)

- (void) printf:(const char *) format, ...
{
int length;
char *buffer;
va_list argList;
  
	va_start(argList, format);
	buffer = [self buildMsg: format argList: argList];
	va_end(argList);

	// this is how one puts text into a Text object and goes to that selection.
	// put the cursor in the very last location and push the buffer in
	length = [self textLength];
	[[self setSel: length : length] replaceSel: buffer];
	[self free: buffer];

	// scroll so that it is visible and redisplay
	[[self scrollSelToVisible] display];
}

- bufferText:(char) c
{
#define BSIZE 256
static char buffer[BSIZE], *bufPtr = buffer;
int length;

	if( c == '\n' || c == '\0'  || (bufPtr - buffer) >= BSIZE-2 )
	{	/* Flush the buffer to the console */
		*bufPtr ++ = c; *bufPtr = '\0';
		length = [self textLength];
		[[self setSel: length : length] replaceSel: buffer];
		[[self scrollSelToVisible] display];
		bufPtr = buffer;
	}

	/* Accumulate the text to the buffer */
	*bufPtr ++ = c;

	return self;
}

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:02:13 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/Text_Console.m,v $;
	$Revision: 1.1 $;
	$Log:	Text_Console.m,v $
Revision 1.1  93/02/23  02:02:13  me
Begin RCS logging.
;
*/
