#import "SortableObject.h"
#import <libc.h>

#ifdef DEBUG
#	define LOCAL static
#else
#	define LOCAL volatile
#endif

@implementation Object(SortableObject)
- (int) compare: anObject typeID:(int) typeID
	size:(int) size keyMethod:(SEL) keyMethod
{
LOCAL void *void1, *void2, *(*keyValue1)(id, SEL), *(*keyValue2)(id, SEL);
LOCAL int i1, i2;
LOCAL char *s1, *s2;
LOCAL int compareValue;

	keyValue1 = (void *(*)(id, SEL))[self methodFor: keyMethod];
	keyValue2 = (void *(*)(id, SEL))[anObject methodFor: keyMethod];
	switch( typeID )
	{
		case eIntType:
			i1 = (int) keyValue1(self, keyMethod);
			i2 = (int) keyValue2(anObject, keyMethod);
			compareValue = i1 - i2;
			break;
		case eStringType:
			s1 = (char *) keyValue1(self, keyMethod);
			s2 = (char *) keyValue2(anObject, keyMethod);
			compareValue = strcmp(s1, s2);
			break;
		case eVoidType:
			void1 = keyValue1(self, keyMethod);
			void2 = keyValue2(anObject, keyMethod);
			compareValue = bcmp(&void1, &void2, size);
			break;
		default:
			[self error:"Invalid typeID[%d] in %s", typeID, sel_getName(_cmd)];
			break;
	}

	return compareValue;
}

- (int) compareTo:(void *) data typeID:(int) typeID
	size:(int) size keyMethod:(SEL) keyMethod
{
void *void1, *void2, *(*keyValue)(id, SEL);
int i1, i2;
char *s1, *s2;
int compareValue;

	keyValue = (void *(*)(id, SEL))[self methodFor: keyMethod];
	switch( typeID )
	{
		case eIntType:
			i1 = (int) keyValue(self, keyMethod);
			i2 = (int) data;
			compareValue = i1 - i2;
			break;
		case eStringType:
			s1 = (char *) keyValue(self, keyMethod);
			s2 = (char *) data;
			compareValue = strcmp(s1, s2);
			break;
		case eVoidType:
			void1 = keyValue(self, keyMethod);
			void2 = data;
			compareValue = bcmp(&void1, &void2, size);
			break;
		default:
			[self error:"Invalid typeID[%d] in %s", typeID, sel_getName(_cmd)];
			break;
	}

	return compareValue;
}
@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:02:06 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/SortableObject.m,v $;
	$Revision: 1.1 $;
	$Log:	SortableObject.m,v $
Revision 1.1  93/02/23  02:02:06  me
Begin RCS logging.
;
*/
