#ifndef SortableObject_H
#define SortableObject_H
/* Objects must provide a compare: method that takes an object as its
	argument and returns an integer:
		1. greater than 0 if the receiving object's key value is greater
			than that from the data
		2. equal to 0 if the receiving object's key value is equal than that
			from the data
		3. less than 0 if the receiving object's key value is less than that
			from the data.
*/
#import <objc/Object.h>

@interface Object(SortableObject)
- (SEL) keyMethod;
- keyMethods;
- (BOOL) canCompareToType:(const char *) type;
- (int) cacheType:(const char *) type;
- (int) compare: anObject typeID:(int) typeID
	size:(int) size keyMethod:(SEL) keyMethod;
- (int) compareTo:(void *) data typeID:(int) typeID
	size:(int) size keyMethod:(SEL) keyMethod;
@end

/*\ ---------------------- Constants ---------------------- \*/
/* enumerations for basic types */
enum {eIntType, eStringType, eVoidType} DataTypeID;

/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:02:03 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/SortableObject.h,v $;
	$Revision: 1.1 $;
	$Log:	SortableObject.h,v $
 * Revision 1.1  93/02/23  02:02:03  me
 * Begin RCS logging.
 * ;
*/
#endif	// SortableObject_H
