#import "PercentView.h"
#import <appkit/appkit.h>

@implementation PercentView

- initFrame:(const NXRect *) theFrame viewType:(PercentViewType) type
{
	[super initFrame: theFrame];
	viewType = type;

	return self;
}

- newSession:(float) endSize
{
	sizeToPercent = 1.0 / endSize;
	minChange = asin(1.0 / bounds.size.width) / 360.0;
	size = 0;
	return self;
}

- updateSession:(int) currentSize
{
	if( currentSize <= size + minChange )
		return nil;
	percent = sizeToPercent * currentSize;
	return [self displayPercent: percent];
}

- displayPercent: (float) p
{
	if( p < 0.0 )
		p = 0.0;
	else if(p > 1.0 )
		p = 1.0;
	percent = p;
	[self display];

	return self;
}

- takeFloatValueFrom: sender
{
	[self displayPercent: [sender floatValue]];

	return self;
}

- drawSelf: (const NXRect *) rects :(int) rectCount
{
	if(rectCount == 0)
		return self;

	/* Erase my bounds */
	PSsetgray(NX_LTGRAY);
	NXRectFill(&bounds);
	switch( viewType )
	{
		case eBarView:
			[self drawBar];
			break;
		case ePieView:
			[self drawPie];
			break;
		default:
			break;
	}
	[super drawSelf: rects : rectCount];

	return self;
}

- drawPie
{
float x,y,dx,dy;
float r,endAngle;

	/* Calculate my center, radius, and end angle */
	dx = bounds.size.width / 2.0;
	x =  dx + bounds.origin.x;
	dy = bounds.size.height / 2.0;
	y = dy + bounds.origin.y;
	r = MIN(dx,dy);
	r -= 2;
	endAngle = 90.0 - 360.0 * percent;

	/* Draw black circle for the dial */
	PSsetgray(NX_BLACK);
	PSarc(x, y, r, 0.0, 360.0);
	PSstroke();
	/* Draw the pie slice */
	PSmoveto(x, y);
	PSarcn(x,y,r,90.0, endAngle);
	PSclosepath();
	PSgsave();
		PSsetgray(NX_DKGRAY);
		PSfill();
	PSgrestore();
	PSstroke();

	return self;
}

- drawBar
{
float width, height;

	/* Calculate the bar with & height */
	height = bounds.size.height;
	width = bounds.size.width * percent;

	/* Fill the bar with dark gray */
	PSsetgray(NX_DKGRAY);
	PSrectfill(bounds.origin.x, bounds.origin.y, width, height);
	/* Draw our frame in black */
	PSsetgray(NX_BLACK);
	PSrectstroke(bounds.origin.x, bounds.origin.y+1, bounds.size.width-1, height-1);
	PSmoveto(width, 0.0);
	PSrlineto(0.0, height);
	PSstroke();
	
	return self;
}
@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:55 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/PercentView.m,v $;
	$Revision: 1.1 $;
*/
