/* Simple subclass of View that display a fraction of a circle
	 to represent the percent set by its displayPercent: method */
#import <appkit/View.h>

/*\ ---------------------------------- Constants ---------------------------------- \*/
typedef enum {ePieView, eBarView} PercentViewType;

@interface PercentView : View
{
	float percent;
	float sizeToPercent;
	float size;
	float minChange;
	PercentViewType viewType;
}

- initFrame:(const NXRect *) theFrame viewType:(PercentViewType) type;
- newSession:(float) endSize;
- updateSession:(int) currentSize;
- displayPercent: (float) p;
- drawPie;
- drawBar;

/*\ ---------------------------------- Debugging ---------------------------------- \*/
- takeFloatValueFrom: sender;
@end

/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:50 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/PercentView.h,v $;
	$Revision: 1.1 $;
*/
