#import "PasswordField.h"
#import "PasswordFieldCell.h"
#import <appkit/appkit.h>

@implementation PasswordField

+ initialize
{
	[super setCellClass: [PasswordFieldCell class]];
	return self;
}

- (const char *) hiddenString
{
	return [(PasswordFieldCell *)cell hiddenString];
}

- initFrame:(const NXRect *) frameRect
{
Font *simpleFont;
const char *fontSize;
float size;

	[super initFrame: frameRect];
	fontSize = NXGetDefaultValue("GLOBAL", "NXFontSize");
	size = 12.0;
	if( fontSize != 0 )
		size = atof(fontSize);
	simpleFont = [Font newFont: "Courier" size: size];
	[super setFont: simpleFont];
	[(PasswordFieldCell *)cell setIsVisible: NO];

	return self;
}

- setHiddenChar:(unsigned short) value
{
	[(PasswordFieldCell *)cell setHiddenChar: value];
	return self;
}

- setStringValue:(const char *) aString visible:(BOOL) flag
{
	[(PasswordFieldCell *)cell setIsVisible: flag];
	return [self setStringValue: aString];
}

- setStringValue:(const char *) aString
{
	[(PasswordFieldCell *)cell setStringValue: aString];
	[self display];
	return self;
}

- setIsVisible: sender
{
Text *fieldEditor;
BOOL state = [sender state];

	fieldEditor = [cell editor];
	if( [(PasswordFieldCell *)cell isVisible] != state )
	{
		[(PasswordFieldCell *)cell setIsVisible: state];
		if( fieldEditor != nil )
			[fieldEditor display];
		else
			[self display];
	}
	return self;
}

- (BOOL) isVisible
{
	return [(PasswordFieldCell *)cell isVisible];
}

- (unsigned short) hiddenChar
{
	return [(PasswordFieldCell *)cell hiddenChar];
}

- (BOOL) acceptsFirstResponder
{
	return [super acceptsFirstResponder];
}

- selectText: sender
{
	return [super selectText: sender];
}
- textDidEnd: textObject endChar:(unsigned short) whyEnd
{
char password[128];

	[textObject getSubstring: password start: 0 length: 127];
	password[127] = 0;
	[cell setStringValue: password];

	return [super textDidEnd: textObject endChar: whyEnd];
}

@end
