#import "Object_Hashing.h"
#import <math.h>
#import <strings.h>

@implementation Object(Hashing)

- (unsigned int) hashFromString:(const char *) string
{
unsigned int h = 0;
unsigned int g;

	while ( *string != '\0' )
	{
		h = (h << 4) + *string++;
		if ( (g = h & 0xf0000000) != 0 )
			h = (h ^ (g >> 24)) ^ g;
	}
	return h;

} // End hashFromString:(const char *) string

/* Create a hash value from the string argument that maintains the
	lexigraphic value of the string */
- (unsigned int) lexHashFromString:(const char *) string
{
unsigned int value = 0;
int n;

	/* Simply convert the string to a base 52 number. Only uses for first 5 chars */
	for(n = 0; n < 5 || n >= strlen(string); n ++)
		value = value + (string[n] - 'a') * pow(26, n);
	return value;
} // End lexHashFromString:(const char *) string

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:30 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/Object_Hashing.m,v $;
	$Revision: 1.1 $;
	$Log:	Object_Hashing.m,v $
Revision 1.1  93/02/23  02:01:30  me
Begin RCS logging.
;
*/
