/* An Object classification that incorporates a number of methods for 
	hashing.  These methods can be used in ``keyValue'' methods of
	objects used in an ObjectList. */
#import <objc/Object.h>

@interface Object(Hashing)

/* Create a hash value from the string argument. This hashing function from
	is from the book ``Compilers Principles, Techniques and
	Tools'', (The Dragon Book) page 436 */
- (unsigned int) hashFromString:(const char *) string;

/* Create a hash value from the string argument that maintains the
	lexigraphic value of the string */
- (unsigned int) lexHashFromString:(const char *) string;

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:26 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/Object_Hashing.h,v $;
	$Revision: 1.1 $;
	$Log:	Object_Hashing.h,v $
 * Revision 1.1  93/02/23  02:01:26  me
 * Begin RCS logging.
 * ;
*/
